/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.archives.data.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ClassInfo {
    int magic;
    int minor_version;
    int major_version;
    List constant_pool;
    int access_flags;
    ConstantPoolInfo this_class;
    ConstantPoolInfo super_class;
    int interface_count;
    ConstantPoolInfo[] interfaces;
    List fields;
    List methods;
    List attributes;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;

    public ClassInfo(DataInputStream di) throws IOException {
        this.read(di);
    }

    public void read(DataInputStream di) throws IOException {
        this.magic = di.readInt();
        if (this.magic != -889275714) {
            throw new IOException("Wrong magic code for a Java class");
        }
        this.minor_version = di.readUnsignedShort();
        this.major_version = di.readUnsignedShort();
        int n = di.readUnsignedShort();
        this.constant_pool = new ArrayList(n);
        this.constant_pool.add(null);
        int i = 1;
        while (i < n) {
            ConstantPoolInfo cpi = new ConstantPoolInfo(di);
            this.constant_pool.add(cpi);
            switch (cpi.getType()) {
                case 5: 
                case 6: {
                    this.constant_pool.add(null);
                    ++i;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.constant_pool.size()) {
            ConstantPoolInfo cpi = (ConstantPoolInfo)this.constant_pool.get(i2);
            if (cpi != null) {
                cpi.resolve();
            }
            ++i2;
        }
        this.access_flags = di.readUnsignedShort();
        this.this_class = this.getConstantPoolInfo(di.readUnsignedShort());
        this.super_class = this.getConstantPoolInfo(di.readUnsignedShort());
        this.interface_count = di.readUnsignedShort();
        this.interfaces = new ConstantPoolInfo[this.interface_count];
        int i3 = 0;
        while (i3 < this.interfaces.length) {
            this.interfaces[i3] = this.getConstantPoolInfo(di.readUnsignedShort());
            ++i3;
        }
        n = di.readUnsignedShort();
        this.fields = new ArrayList(n);
        int i4 = 0;
        while (i4 < n) {
            this.fields.add(new FieldInfo(di));
            ++i4;
        }
        n = di.readUnsignedShort();
        this.methods = new ArrayList(n);
        int i5 = 0;
        while (i5 < n) {
            this.methods.add(new MethodInfo(di));
            ++i5;
        }
        n = di.readUnsignedShort();
        this.attributes = new ArrayList(n);
        int i6 = 0;
        while (i6 < n) {
            AttributeInfo o = new AttributeInfo(di);
            if ("SourceFile".equals(o.getName())) {
                o.resolveDataRef();
            }
            this.attributes.add(o);
            ++i6;
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        this.updateConstantPoolIndexes();
        dos.writeInt(this.magic);
        dos.writeShort(this.minor_version);
        dos.writeShort(this.major_version);
        dos.writeShort(this.getConstantPoolSize());
        int i = 0;
        while (i < this.constant_pool.size()) {
            ConstantPoolInfo cpi = (ConstantPoolInfo)this.constant_pool.get(i);
            if (cpi != null) {
                cpi.write(dos);
            }
            ++i;
        }
        dos.writeShort(this.access_flags);
        dos.writeShort(this.this_class.index);
        dos.writeShort(this.super_class == null ? 0 : this.super_class.index);
        dos.writeShort(this.interface_count);
        int i2 = 0;
        while (i2 < this.interfaces.length) {
            dos.writeShort(this.interfaces[i2].index);
            ++i2;
        }
        dos.writeShort(this.fields.size());
        int i3 = 0;
        while (i3 < this.fields.size()) {
            FieldInfo field = (FieldInfo)this.fields.get(i3);
            field.write(dos);
            ++i3;
        }
        dos.writeShort(this.methods.size());
        int i4 = 0;
        while (i4 < this.methods.size()) {
            MethodInfo method = (MethodInfo)this.methods.get(i4);
            method.write(dos);
            ++i4;
        }
        dos.writeShort(this.attributes.size());
        int i5 = 0;
        while (i5 < this.attributes.size()) {
            AttributeInfo attribute = (AttributeInfo)this.attributes.get(i5);
            attribute.write(dos);
            ++i5;
        }
    }

    private void updateConstantPoolIndexes() {
        int i = 0;
        while (i < this.constant_pool.size()) {
            ConstantPoolInfo info = (ConstantPoolInfo)this.constant_pool.get(i);
            if (info != null) {
                info.index = i;
            }
            ++i;
        }
    }

    private int getConstantPoolSize() {
        return this.constant_pool.size();
    }

    ConstantPoolInfo getConstantPoolInfo(int index) {
        return (ConstantPoolInfo)this.constant_pool.get(index);
    }

    public void stripByteCode() {
        int i = 0;
        while (i < this.methods.size()) {
            MethodInfo method = (MethodInfo)this.methods.get(i);
            method.removeAttribute("Code");
            ++i;
        }
    }

    public void removeAttribute(String s) {
        Iterator it = this.attributes.iterator();
        while (it.hasNext()) {
            AttributeInfo info = (AttributeInfo)it.next();
            if (!s.equals(info.getName())) continue;
            it.remove();
        }
    }

    public void stripAccessBelow(int accessLevel) {
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            FieldInfo field = (FieldInfo)it.next();
            if (field.getAccessLevel() >= accessLevel) continue;
            it.remove();
        }
        it = this.methods.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            if (method.getAccessLevel() >= accessLevel) continue;
            it.remove();
        }
    }

    public void cleanConstantPool() throws IOException {
        boolean changed;
        AttributeInfo attribute;
        this.updateConstantPoolIndexes();
        boolean[] isUsed = new boolean[this.constant_pool.size()];
        isUsed[((ConstantPoolInfo)this.this_class).index] = true;
        if (this.super_class != null) {
            isUsed[((ConstantPoolInfo)this.super_class).index] = true;
        }
        int i = 0;
        while (i < this.interface_count) {
            isUsed[((ConstantPoolInfo)this.interfaces[i]).index] = true;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.fields.size()) {
            FieldInfo field = (FieldInfo)this.fields.get(i2);
            isUsed[((ConstantPoolInfo)((FieldInfo)field).descriptor).index] = true;
            isUsed[((ConstantPoolInfo)((FieldInfo)field).name).index] = true;
            int j = 0;
            while (j < field.attributes.size()) {
                attribute = (AttributeInfo)field.attributes.get(j);
                isUsed[((ConstantPoolInfo)((AttributeInfo)attribute).attribute_name).index] = true;
                if (attribute.other_ref != null) {
                    isUsed[((ConstantPoolInfo)((AttributeInfo)attribute).other_ref).index] = true;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.methods.size()) {
            MethodInfo method = (MethodInfo)this.methods.get(i3);
            isUsed[((ConstantPoolInfo)((MethodInfo)method).descriptor).index] = true;
            isUsed[((ConstantPoolInfo)((MethodInfo)method).name).index] = true;
            int j = 0;
            while (j < method.attributes.size()) {
                AttributeInfo attribute2 = (AttributeInfo)method.attributes.get(j);
                isUsed[((ConstantPoolInfo)((AttributeInfo)attribute2).attribute_name).index] = true;
                if (attribute2.other_ref != null) {
                    isUsed[((ConstantPoolInfo)((AttributeInfo)attribute2).other_ref).index] = true;
                }
                ++j;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.attributes.size()) {
            attribute = (AttributeInfo)this.attributes.get(i4);
            isUsed[((ConstantPoolInfo)((AttributeInfo)attribute).attribute_name).index] = true;
            if (attribute.other_ref != null) {
                isUsed[((ConstantPoolInfo)((AttributeInfo)attribute).other_ref).index] = true;
            }
            ++i4;
        }
        do {
            changed = false;
            int i5 = 0;
            while (i5 < this.constant_pool.size()) {
                if (isUsed[i5]) {
                    int n;
                    ConstantPoolInfo info = (ConstantPoolInfo)this.constant_pool.get(i5);
                    if (info.cpi1 != null && !isUsed[n = info.cpi1.index]) {
                        isUsed[n] = true;
                        changed = true;
                    }
                    if (info.cpi2 != null && !isUsed[n = info.cpi2.index]) {
                        isUsed[n] = true;
                        changed = true;
                    }
                }
                ++i5;
            }
        } while (changed);
        int pos = 1;
        int lastType = -1;
        Iterator it = this.constant_pool.iterator();
        it.next();
        while (it.hasNext()) {
            ConstantPoolInfo cpi = (ConstantPoolInfo)it.next();
            if (lastType == 5 || lastType == 6) {
                lastType = -1;
            } else if (isUsed[pos]) {
                lastType = cpi.tag;
            } else {
                it.remove();
                lastType = -1;
            }
            ++pos;
        }
    }

    class AttributeInfo {
        private ConstantPoolInfo attribute_name;
        private int attribute_length;
        private byte[] info;
        private ConstantPoolInfo other_ref;

        public AttributeInfo(DataInputStream di) throws IOException {
            this.read(di);
        }

        public String getName() {
            return this.attribute_name.getString();
        }

        public void resolveDataRef() {
            if (this.attribute_length == 2) {
                int offset = this.info[0] & 0xFF;
                offset <<= 8;
                this.other_ref = ClassInfo.this.getConstantPoolInfo(offset += this.info[1] & 0xFF);
            }
        }

        public void read(DataInputStream di) throws IOException {
            int index = di.readUnsignedShort();
            this.attribute_name = ClassInfo.this.getConstantPoolInfo(index);
            this.attribute_length = di.readInt();
            this.info = new byte[this.attribute_length];
            di.readFully(this.info);
        }

        public void write(DataOutputStream dos) throws IOException {
            dos.writeShort(this.attribute_name.index);
            dos.writeInt(this.attribute_length);
            if (this.other_ref != null && this.attribute_length == 2) {
                int index = this.other_ref.index;
                this.info[0] = (byte)(index >> 8);
                this.info[1] = (byte)(index & 0xFF);
            }
            dos.write(this.info);
        }
    }

    class MethodInfo {
        private int access_flags;
        private ConstantPoolInfo name;
        private ConstantPoolInfo descriptor;
        private List attributes;

        public MethodInfo(DataInputStream di) throws IOException {
            this.read(di);
        }

        public int getAccessLevel() {
            if ((this.access_flags & 1) != 0) {
                return 3;
            }
            if ((this.access_flags & 4) != 0) {
                return 2;
            }
            if ((this.access_flags & 2) != 0) {
                return 0;
            }
            return 1;
        }

        public void removeAttribute(String key) {
            Iterator it = this.attributes.iterator();
            while (it.hasNext()) {
                AttributeInfo info = (AttributeInfo)it.next();
                if (!key.equals(info.getName())) continue;
                it.remove();
            }
        }

        public void read(DataInputStream di) throws IOException {
            this.access_flags = di.readUnsignedShort();
            this.name = ClassInfo.this.getConstantPoolInfo(di.readUnsignedShort());
            this.descriptor = ClassInfo.this.getConstantPoolInfo(di.readUnsignedShort());
            int n = di.readUnsignedShort();
            this.attributes = new ArrayList(n);
            int i = 0;
            while (i < n) {
                this.attributes.add(new AttributeInfo(di));
                ++i;
            }
        }

        public void write(DataOutputStream dos) throws IOException {
            dos.writeShort(this.access_flags);
            dos.writeShort(this.name.index);
            dos.writeShort(this.descriptor.index);
            dos.writeShort(this.attributes.size());
            int i = 0;
            while (i < this.attributes.size()) {
                AttributeInfo ai = (AttributeInfo)this.attributes.get(i);
                ai.write(dos);
                ++i;
            }
        }
    }

    class FieldInfo {
        private int access_flags;
        private ConstantPoolInfo name;
        private ConstantPoolInfo descriptor;
        private List attributes;

        public FieldInfo(DataInputStream di) throws IOException {
            this.read(di);
        }

        public int getAccessLevel() {
            if ((this.access_flags & 1) != 0) {
                return 3;
            }
            if ((this.access_flags & 4) != 0) {
                return 2;
            }
            if ((this.access_flags & 2) != 0) {
                return 0;
            }
            return 1;
        }

        public void read(DataInputStream di) throws IOException {
            this.access_flags = di.readUnsignedShort();
            this.name = ClassInfo.this.getConstantPoolInfo(di.readUnsignedShort());
            this.descriptor = ClassInfo.this.getConstantPoolInfo(di.readUnsignedShort());
            int n = di.readUnsignedShort();
            this.attributes = new ArrayList(n);
            int i = 0;
            while (i < n) {
                AttributeInfo o = new AttributeInfo(di);
                if ("ConstantValue".equals(o.getName())) {
                    o.resolveDataRef();
                }
                this.attributes.add(o);
                ++i;
            }
        }

        public void write(DataOutputStream dos) throws IOException {
            dos.writeShort(this.access_flags);
            dos.writeShort(this.name.index);
            dos.writeShort(this.descriptor.index);
            dos.writeShort(this.attributes.size());
            int i = 0;
            while (i < this.attributes.size()) {
                AttributeInfo ai = (AttributeInfo)this.attributes.get(i);
                ai.write(dos);
                ++i;
            }
        }
    }

    class ConstantPoolInfo {
        int tag;
        int ivIndex1;
        int ivIndex2;
        byte[] data;
        private ConstantPoolInfo cpi1;
        private ConstantPoolInfo cpi2;
        private int index;

        public ConstantPoolInfo(DataInputStream di) throws IOException {
            this.read(di);
        }

        public int getType() {
            return this.tag;
        }

        void resolve() {
            if (this.ivIndex1 > 0) {
                this.cpi1 = ClassInfo.this.getConstantPoolInfo(this.ivIndex1);
            }
            if (this.ivIndex2 > 0) {
                this.cpi2 = ClassInfo.this.getConstantPoolInfo(this.ivIndex2);
            }
        }

        public void read(DataInputStream di) throws IOException {
            this.tag = di.readUnsignedByte();
            switch (this.tag) {
                case 7: {
                    this.ivIndex1 = di.readUnsignedShort();
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.ivIndex1 = di.readUnsignedShort();
                    this.ivIndex2 = di.readUnsignedShort();
                    break;
                }
                case 8: {
                    this.ivIndex1 = di.readUnsignedShort();
                    break;
                }
                case 3: 
                case 4: {
                    this.data = new byte[4];
                    di.readFully(this.data);
                    break;
                }
                case 5: 
                case 6: {
                    this.data = new byte[8];
                    di.readFully(this.data);
                    break;
                }
                case 12: {
                    this.ivIndex1 = di.readUnsignedShort();
                    this.ivIndex2 = di.readUnsignedShort();
                    break;
                }
                case 1: {
                    this.data = new byte[di.readUnsignedShort()];
                    di.readFully(this.data);
                    break;
                }
                default: {
                    throw new IOException("Unexpected tag " + this.tag);
                }
            }
        }

        public void write(DataOutputStream dos) throws IOException {
            dos.writeByte(this.tag);
            switch (this.tag) {
                case 7: {
                    dos.writeShort(this.cpi1.index);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    dos.writeShort(this.cpi1.index);
                    dos.writeShort(this.cpi2.index);
                    break;
                }
                case 8: {
                    dos.writeShort(this.cpi1.index);
                    break;
                }
                case 3: 
                case 4: {
                    dos.write(this.data);
                    break;
                }
                case 5: 
                case 6: {
                    dos.write(this.data);
                    break;
                }
                case 12: {
                    dos.writeShort(this.cpi1.index);
                    dos.writeShort(this.cpi2.index);
                    break;
                }
                case 1: {
                    dos.writeShort(this.data.length);
                    dos.write(this.data);
                }
            }
        }

        public String getString() {
            if (this.tag == 1) {
                try {
                    return new String(this.data, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

