/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.archives.data.bytecode;

import com.sap.tc.cbs.util.archives.data.bytecode.ClassInfo;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCodeFilterInputStream
extends FilterInputStream {
    public static final int ACCESSLEVEL_PRIVATE = 0;
    public static final int ACCESSLEVEL_PACKAGE = 1;
    public static final int ACCESSLEVEL_PROTECTED = 2;
    public static final int ACCESSLEVEL_PUBLIC = 3;
    private ByteArrayInputStream byteStream;
    public static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$cbs$util$archives$data$bytecode$ByteCodeFilterInputStream == null ? (class$com$sap$tc$cbs$util$archives$data$bytecode$ByteCodeFilterInputStream = ByteCodeFilterInputStream.class$("com.sap.tc.cbs.util.archives.data.bytecode.ByteCodeFilterInputStream")) : class$com$sap$tc$cbs$util$archives$data$bytecode$ByteCodeFilterInputStream));
    private boolean stripByteCode;
    private int accessLevel;
    static /* synthetic */ Class class$com$sap$tc$cbs$util$archives$data$bytecode$ByteCodeFilterInputStream;

    public ByteCodeFilterInputStream(InputStream in) {
        super(in);
    }

    public void setStripByteCode(boolean stripByteCode) {
        this.stripByteCode = stripByteCode;
    }

    public boolean isStripByteCode() {
        return this.stripByteCode;
    }

    public void setAccessLevel(int accessLevel) {
        this.accessLevel = accessLevel;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    private void prepareData() throws IOException {
        if (this.byteStream == null) {
            int len = Math.min(this.in.available(), 16384);
            ByteArrayOutputStream2 baos = new ByteArrayOutputStream2(len);
            baos.readFully(this.in);
            this.in.close();
            ByteArrayInputStream bais = baos.getInputStream();
            this.in = bais;
            DataInputStream di = new DataInputStream(this.in);
            ClassInfo ci = new ClassInfo(di);
            if (this.stripByteCode) {
                ci.stripByteCode();
            }
            if (this.accessLevel != 0) {
                ci.stripAccessBelow(this.accessLevel);
                ci.cleanConstantPool();
            }
            baos.reset();
            DataOutputStream dos = new DataOutputStream(baos);
            ci.write(dos);
            dos.flush();
            baos.close();
            this.byteStream = baos.getInputStream();
        }
    }

    public int read() throws IOException {
        this.prepareData();
        return this.byteStream.read();
    }

    public int read(byte[] b) throws IOException {
        this.prepareData();
        return this.byteStream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.prepareData();
        return this.byteStream.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        this.prepareData();
        return this.byteStream.skip(n);
    }

    public int available() throws IOException {
        this.prepareData();
        return this.byteStream.available();
    }

    public void close() throws IOException {
        super.close();
        if (this.byteStream != null) {
            this.byteStream.close();
        }
    }

    public synchronized void mark(int readlimit) {
        try {
            this.prepareData();
            this.byteStream.mark(readlimit);
        }
        catch (IOException e) {
            LOCATION.catching((Throwable)e);
        }
    }

    public synchronized void reset() throws IOException {
        this.prepareData();
        this.byteStream.reset();
    }

    public boolean markSupported() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ByteArrayOutputStream2
    extends ByteArrayOutputStream {
        public ByteArrayOutputStream2() {
        }

        public ByteArrayOutputStream2(int size) {
            super(size);
        }

        public ByteArrayInputStream getInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }

        /*
         * WARNING - void declaration
         */
        public void readFully(InputStream in) throws IOException {
            int len;
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) >= 0) {
                void var2_3;
                super.write(buffer, 0, (int)var2_3);
            }
        }
    }
}

