/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.archives.data;

import com.sap.tc.cbs.util.archives.DataNotFoundException;
import com.sap.tc.cbs.util.archives.IData;
import com.sap.tc.cbs.util.archives.data.FileData;
import com.sap.tc.cbs.util.archives.data.ZipData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileData
extends FileData {
    protected static final Set J2EE_EXTENSIONS = new HashSet();
    private ZipFile archive;

    public ZipFileData(File file) {
        super(file);
    }

    protected IData[] wrap(File[] files) throws DataNotFoundException {
        if (ZipFileData.isArchive(this)) {
            try {
                return this.wrapEntries();
            }
            catch (IOException e) {
                throw new DataNotFoundException(e);
            }
        }
        return super.wrap(files);
    }

    private IData[] wrapEntries() throws IOException {
        this.archive = new ZipFile(this._delegate);
        Enumeration<? extends ZipEntry> entries = this.archive.entries();
        if (entries == null) {
            return new IData[0];
        }
        ArrayList<ZipData> entryList = new ArrayList<ZipData>();
        while (entries.hasMoreElements()) {
            entryList.add(new ZipData(this.archive, entries.nextElement()));
        }
        Collections.sort(entryList, FileData._comparator);
        IData[] result = new IData[entryList.size()];
        result = entryList.toArray(result);
        return result;
    }

    protected IData wrap(File file) throws DataNotFoundException {
        return new ZipFileData(file);
    }

    public boolean isContainer() {
        return super.isContainer() || ZipFileData.isArchive(this);
    }

    static boolean isArchive(IData data) {
        String c;
        String name = data.getName().toLowerCase();
        int n = name.lastIndexOf(46);
        return n != -1 && J2EE_EXTENSIONS.contains(c = name.substring(n));
    }

    public void close() throws IOException {
        if (this.archive != null) {
            this.archive.close();
        }
    }

    static {
        J2EE_EXTENSIONS.add(".zip");
        J2EE_EXTENSIONS.add(".jar");
    }
}

