/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.archives.data;

import com.sap.tc.cbs.util.archives.DataNotFoundException;
import com.sap.tc.cbs.util.archives.IData;
import com.sap.tc.cbs.util.archives.data.bytecode.ByteCodeFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipData
implements IData {
    private ZipEntry _delegate;
    private ZipFile _container;

    private ZipData() {
    }

    public ZipData(ZipFile container, ZipEntry entry) {
        this._container = container;
        this._delegate = entry;
    }

    public boolean isContainer() {
        return this._delegate.isDirectory();
    }

    public IData[] getItems() {
        return new IData[0];
    }

    public InputStream getContent(boolean filtered) throws DataNotFoundException {
        try {
            return filtered ? this.getFilteredContent(this._container.getInputStream(this._delegate)) : this._container.getInputStream(this._delegate);
        }
        catch (IOException e) {
            throw new DataNotFoundException(e);
        }
    }

    public String toString() {
        return this._delegate.toString();
    }

    public String getName() {
        return this._delegate.getName();
    }

    public long getSize() {
        return this._delegate.getSize();
    }

    public boolean exists() {
        return true;
    }

    protected InputStream getFilteredContent(InputStream is) {
        InputStream fis = is;
        if (is != null && this.getName().endsWith(".class")) {
            ByteCodeFilterInputStream byteCodeFilter = new ByteCodeFilterInputStream(is);
            byteCodeFilter.setStripByteCode(true);
            byteCodeFilter.setAccessLevel(2);
            fis = byteCodeFilter;
        }
        return fis;
    }

    public void close() throws IOException {
    }
}

