/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.archives.data;

import com.sap.tc.cbs.util.archives.DataNotFoundException;
import com.sap.tc.cbs.util.archives.IData;
import com.sap.tc.cbs.util.archives.data.bytecode.ByteCodeFilterInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;

public class FileData
implements IData {
    protected static Comparator _comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            IData f1 = (IData)o1;
            IData f2 = (IData)o2;
            int caseIdx = (f1.isContainer() ? -1 : 1) + (f2.isContainer() ? 1 : -1);
            return caseIdx == 0 ? this.compareNames(f1, f2) : caseIdx;
        }

        private int compareNames(IData f1, IData f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };
    protected File _delegate;

    private FileData() {
    }

    public FileData(File file) {
        this._delegate = file;
    }

    public boolean isContainer() {
        return this._delegate.isDirectory();
    }

    public IData[] getItems() throws DataNotFoundException {
        return this.wrap(this._delegate.listFiles());
    }

    public InputStream getContent(boolean filtered) throws DataNotFoundException {
        try {
            return filtered ? this.getFilteredContent(new FileInputStream(this._delegate)) : new FileInputStream(this._delegate);
        }
        catch (FileNotFoundException e) {
            throw new DataNotFoundException(e);
        }
    }

    protected IData[] wrap(File[] files) throws DataNotFoundException {
        if (files == null) {
            return new IData[0];
        }
        IData[] result = new IData[files.length];
        int i = 0;
        while (i < files.length) {
            result[i] = this.wrap(files[i]);
            ++i;
        }
        Arrays.sort(result, _comparator);
        return result;
    }

    protected IData wrap(File file) throws DataNotFoundException {
        return new FileData(file);
    }

    public String toString() {
        return this._delegate.toString();
    }

    public String getName() {
        return this._delegate.getName();
    }

    public long getSize() {
        return this.isContainer() ? 0L : this._delegate.length();
    }

    public boolean exists() {
        return this._delegate.exists();
    }

    protected InputStream getFilteredContent(InputStream is) {
        InputStream fis = is;
        if (is != null && this.getName().endsWith(".class")) {
            ByteCodeFilterInputStream byteCodeFilter = new ByteCodeFilterInputStream(is);
            byteCodeFilter.setStripByteCode(true);
            byteCodeFilter.setAccessLevel(1);
            fis = byteCodeFilter;
        }
        return fis;
    }

    public void close() throws IOException {
    }
}

