/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.archives;

import com.sap.tc.cbs.util.archives.DataBrowser;
import com.sap.tc.cbs.util.archives.DataProcessor;
import com.sap.tc.cbs.util.archives.IData;
import com.sap.tc.cbs.util.archives.IDataFilter;
import com.sap.tc.cbs.util.archives.IDataProcessor;
import com.sap.tc.cbs.util.archives.data.AbstractKey;
import com.sap.tc.cbs.util.archives.data.DirKey;
import com.sap.tc.cbs.util.archives.data.FileData;
import com.sap.tc.cbs.util.archives.data.MD5Key;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Test {
    public static final String MD5_DIGEST_NAME = "MD5";
    public static final String SHA_DIGEST_NAME = "SHA";
    private static long executionTime;
    private static short testKey;

    public static void main(String[] args) {
        try {
            File testFile = new File("C:/", "CBS-B03.log");
            testKey = 1;
            Test.test(Test.getKey(), testFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static AbstractKey getKey() throws NoSuchAlgorithmException {
        DirKey key;
        System.err.println(">>");
        switch (testKey) {
            case 2: {
                MessageDigest md = MessageDigest.getInstance(SHA_DIGEST_NAME);
                key = new MD5Key(md, new byte[65536], true);
                System.err.println("SHA digest");
                break;
            }
            case 1: {
                MessageDigest md = MessageDigest.getInstance(MD5_DIGEST_NAME);
                key = new MD5Key(md, new byte[65536], true);
                System.err.println("MD5 digest");
                break;
            }
            default: {
                key = new DirKey(System.out);
                System.err.println("file name browser");
            }
        }
        return key;
    }

    private static void test(AbstractKey key, File file) {
        System.out.println();
        System.out.println(file.getPath());
        FileData test = new FileData(file);
        IDataFilter logFilter = new IDataFilter(){

            public boolean accept(IData data) throws IOException {
                return data.isContainer() || data.getName().toLowerCase().endsWith(".trc");
            }
        };
        try {
            executionTime = System.currentTimeMillis();
            DataProcessor proc = new DataProcessor(key);
            proc.addFilter(logFilter, (short)2);
            DataBrowser.calculateContentKey(test, proc);
            System.out.println("key generated: " + key.toString());
            executionTime = System.currentTimeMillis() - executionTime;
            Test.printStatistic(proc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println();
    }

    private static void printStatistic(IDataProcessor proc) {
        System.out.println("data volume processed: " + proc.getProcessedSize());
        double processingSpeed = (double)proc.getProcessedSize() / (double)(executionTime / 1000L) / 1024.0;
        System.err.println("Average data processing speed " + Math.round(processingSpeed) + " KB/sec");
    }

    static {
        testKey = 1;
    }
}

