/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.archives;

import com.sap.tc.cbs.util.archives.IData;
import com.sap.tc.cbs.util.archives.IDataFilter;
import com.sap.tc.cbs.util.archives.IDataProcessor;
import com.sap.tc.cbs.util.archives.data.AbstractKey;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DataProcessor
implements IDataProcessor {
    private static final Location trace = Location.getLocation((Class)(class$com$sap$tc$cbs$util$archives$DataProcessor == null ? (class$com$sap$tc$cbs$util$archives$DataProcessor = DataProcessor.class$("com.sap.tc.cbs.util.archives.DataProcessor")) : class$com$sap$tc$cbs$util$archives$DataProcessor));
    private AbstractKey _key;
    private long _processedSize;
    private long _processedFiles;
    private long _skippedFiles;
    private long _processedFolders;
    private long _skippedFolders;
    private final List _filters = new ArrayList();
    private short _filteringMode = 0;
    static /* synthetic */ Class class$com$sap$tc$cbs$util$archives$DataProcessor;

    public DataProcessor(AbstractKey key) {
        this._key = key;
    }

    public boolean entry(IData data) throws IOException {
        boolean result;
        boolean bl = result = data.exists() && this.filtersAccept(data);
        if (!result) {
            if (data.isContainer()) {
                ++this._skippedFolders;
            } else {
                ++this._skippedFiles;
            }
        }
        return result;
    }

    public void process(IData data) throws IOException, InterruptedException {
        this._key.alterKey(data);
    }

    public void leave(IData data) throws IOException, InterruptedException {
        if (data.isContainer()) {
            this._key.alterKey(null);
            ++this._processedFolders;
        } else {
            ++this._processedFiles;
            this._processedSize += data.getSize();
        }
    }

    public long getProcessedSize() {
        return this._processedSize;
    }

    public long getProcessedCount(boolean countContainers) {
        return this._processedFiles + (countContainers ? this._processedFolders : 0L);
    }

    public long getSkippedCount(boolean countContainers) {
        return this._skippedFiles + (countContainers ? this._skippedFolders : 0L);
    }

    public synchronized boolean addFilter(IDataFilter filter, short mode) {
        if (filter == null) {
            trace.debugT("Data filter cannot be <null>.");
            return false;
        }
        if (filter == null || this._filters.contains(filter)) {
            trace.debugT("Data filter has been already registered.");
            return false;
        }
        this._filters.add(filter);
        this.setFilteringMode(mode);
        trace.debugT("Data filter has been registered.");
        return true;
    }

    public synchronized boolean removeFilter(IDataFilter filter, short mode) {
        if (filter == null) {
            trace.debugT("Data filter cannot be <null>.");
            return false;
        }
        if (!this._filters.contains(filter)) {
            trace.debugT("Data filter has not been yet registered.");
            return false;
        }
        this._filters.remove(filter);
        this.setFilteringMode(mode);
        trace.debugT("Data filter has been unregistered.");
        return true;
    }

    public synchronized short getFilteringMode() {
        return this._filteringMode;
    }

    public synchronized void setFilteringMode(short mode) {
        if (this._filteringMode != mode) {
            String modeName = this.filterMode(mode);
            this._filteringMode = mode;
            trace.debugT("Data filtering mode has been changed to " + modeName);
        }
    }

    private synchronized boolean filtersAccept(IData data) throws IOException {
        switch (this._filteringMode) {
            case -1: {
                return false;
            }
            case 2: {
                Iterator it = this._filters.iterator();
                while (it.hasNext()) {
                    if (((IDataFilter)it.next()).accept(data)) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                Iterator it = this._filters.iterator();
                while (it.hasNext()) {
                    if (!((IDataFilter)it.next()).accept(data)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private String filterMode(short code) {
        if (code == 0) {
            return "ACCEPT_ALL (any data is accepted)";
        }
        if (code == -1) {
            return "ACCEPT_NONE (any data is not accepted)";
        }
        if (code == 2) {
            return "EACH_ACCEPTS (data is accepted only if it is accepted by each and every registered filter)";
        }
        if (code == 1) {
            return "ONE_ACCEPTS (data is accepted if it is accepted by at least one registered filter)";
        }
        throw new IllegalArgumentException("Unknown filtering mode: " + code);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

