/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.archives;

import com.sap.tc.cbs.util.archives.DataBrowser;
import com.sap.tc.cbs.util.archives.DataNotFoundException;
import com.sap.tc.cbs.util.archives.DataProcessor;
import com.sap.tc.cbs.util.archives.IContentDigestComputer;
import com.sap.tc.cbs.util.archives.IData;
import com.sap.tc.cbs.util.archives.IDataFilter;
import com.sap.tc.cbs.util.archives.data.AbstractKey;
import com.sap.tc.cbs.util.archives.data.J2EEFileData;
import com.sap.tc.cbs.util.archives.data.MD5Key;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ContentMD5Computer
implements IContentDigestComputer {
    protected static final String DIGEST_ALGORITHM = "MD5";
    protected static final IDataFilter DEFAULT_DATA_FILTER = new IDataFilter(){

        public boolean accept(IData data) throws IOException {
            String name = data.getName().toLowerCase();
            if (!data.isContainer()) {
                if (name.endsWith(".class")) {
                    return true;
                }
                if (name.endsWith(".mf")) {
                    if (name.equals("manifest.mf") || name.equals("meta-inf/manifest.mf")) {
                        return false;
                    }
                    if (name.equals("sap_manifest.mf") || name.equals("meta-inf/sap_manifest.mf")) {
                        return false;
                    }
                    if (name.equals("dc_manifest.mf") || name.equals("meta-inf/dc_manifest.mf")) {
                        return false;
                    }
                }
                if (name.endsWith(".hash")) {
                    return false;
                }
            }
            return true;
        }
    };
    protected IDataFilter dataFilter = DEFAULT_DATA_FILTER;

    public byte[] compute(File content, IDataFilter filter) throws NoSuchAlgorithmException, DataNotFoundException, IOException, InterruptedException {
        this.dataFilter = filter;
        return this._compute(content);
    }

    public byte[] compute(File content) throws NoSuchAlgorithmException, DataNotFoundException, IOException, InterruptedException {
        return this._compute(content);
    }

    protected IData getData(File content) {
        return new J2EEFileData(content);
    }

    protected AbstractKey getMD5Key() throws NoSuchAlgorithmException {
        return new MD5Key(MessageDigest.getInstance(DIGEST_ALGORITHM), null, false);
    }

    protected IDataFilter getDataFilter() {
        return this.dataFilter;
    }

    protected byte[] _compute(File content) throws NoSuchAlgorithmException, DataNotFoundException, IOException, InterruptedException {
        IData data = this.getData(content);
        AbstractKey key = this.getMD5Key();
        DataProcessor proc = new DataProcessor(key);
        proc.addFilter(this.getDataFilter(), (short)2);
        DataBrowser.calculateContentKey(data, proc);
        return key.getBytes();
    }
}

