/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util;

import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Util {
    private static final String ACCESS_IS_DENIED_MESSAGE = "Access is denied";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$cbs$util$Util == null ? (class$com$sap$tc$cbs$util$Util = Util.class$("com.sap.tc.cbs.util.Util")) : class$com$sap$tc$cbs$util$Util));
    private static final int CREATE_TEMP_FOLDER_MAX_TRIES = 100;
    private static final int IO_BUFF_SIZE = 102400;
    private static final FilenameFilter AcceptAllFiles = new FilenameFilter(){

        public boolean accept(File folder, String fileName) {
            return true;
        }
    };
    static /* synthetic */ Class class$com$sap$tc$cbs$util$Util;

    public static String replaceSlash(String path) {
        return path.replace('/', '_');
    }

    public static String replaceSlashWithTilde(String path) {
        return path.replace('/', '~');
    }

    public static String replaceSlashWithBlank(String path) {
        return path.replace('/', ' ');
    }

    public static String replaceBlankWithSlash(String string) {
        return string.replace(' ', '/');
    }

    public static String replacePathSeparator(String path) {
        return path.replace(File.separatorChar, '_');
    }

    public static String replacePathAndDriveSeparator(String path) {
        return path.replace(File.separatorChar, '_').replace(':', '_');
    }

    public static String replaceSlashWithSeparator(String path) {
        return path.replace('/', File.separatorChar);
    }

    public static String concatenatePath(String part1, String part2, char separator) {
        if (part1 == null) {
            throw new IllegalArgumentException("The first parameter in method concatenatePath must not be null.");
        }
        if (part1.length() == 0) {
            return part2;
        }
        if (part2 == null || part2.length() == 0) {
            return part1;
        }
        String result = part1.charAt(part1.length() - 1) == separator && part2.charAt(0) == separator ? part1 + part2.substring(1) : (part1.charAt(part1.length() - 1) == separator || part2.charAt(0) == separator ? part1 + part2 : part1 + separator + part2);
        return result;
    }

    public static void deleteDirRecursively(File f) {
        if (f == null || !f.exists() || !f.isDirectory()) {
            return;
        }
        File[] files = f.listFiles();
        if (files == null) {
            return;
        }
        int l = files.length;
        int i = 0;
        while (i < l) {
            if (files[i].isDirectory()) {
                Util.deleteDirRecursively(files[i]);
            }
            files[i].delete();
            ++i;
        }
        files = null;
        f.delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeStreamToFile(InputStream source, File target) throws FileNotFoundException, IOException {
        BufferedOutputStream out = null;
        byte[] buffer = new byte[102400];
        int amountRead = -1;
        try {
            out = new BufferedOutputStream(new FileOutputStream(target), 102400);
            while ((amountRead = source.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, amountRead);
            }
            ((OutputStream)out).flush();
            Object var6_5 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (out == null) throw throwable;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeFileToStream(File source, OutputStream target) throws FileNotFoundException, IOException {
        BufferedInputStream in = null;
        byte[] buffer = new byte[102400];
        int amountRead = -1;
        try {
            in = new BufferedInputStream(new FileInputStream(source), 102400);
            while ((amountRead = ((InputStream)in).read(buffer)) != -1) {
                target.write(buffer, 0, amountRead);
            }
            target.flush();
            Object var6_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeStreamToStream(InputStream source, OutputStream target, boolean autoFlush) throws IOException {
        int BUFF_SIZE = 4096;
        byte[] buffer = new byte[BUFF_SIZE];
        int amountRead = -1;
        try {
            while ((amountRead = source.read(buffer)) != -1) {
                target.write(buffer, 0, amountRead);
            }
            if (autoFlush) {
                target.flush();
            }
            Object var7_6 = null;
            if (source == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (source == null) throw throwable;
            source.close();
            throw throwable;
        }
        source.close();
    }

    public static void writeStreamToStream(InputStream source, OutputStream target) throws IOException {
        Util.writeStreamToStream(source, target, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFileContent(String source, String target) throws FileNotFoundException, IOException {
        OutputStream out;
        block6: {
            BufferedInputStream in = null;
            out = null;
            byte[] buffer = new byte[102400];
            try {
                int amountRead;
                in = new BufferedInputStream(new FileInputStream(source), 102400);
                out = new BufferedOutputStream(new FileOutputStream(target), 102400);
                while ((amountRead = ((InputStream)in).read(buffer)) != -1) {
                    void var5_5;
                    out.write(buffer, 0, (int)var5_5);
                }
                out.flush();
                Object var7_6 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            ((InputStream)in).close();
        }
        if (out != null) {
            out.close();
        }
    }

    public static void copyFolderContent(String source, String target) throws FileNotFoundException, IOException {
        Util.copyFolderContent(source, target, AcceptAllFiles);
    }

    public static void copyFolderContent(String source, String target, FilenameFilter filter) throws IOException {
        File sourceFolder = new File(source);
        File targetFolder = new File(target);
        if (!sourceFolder.exists()) {
            throw new FileNotFoundException(source);
        }
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        String[] fileNames = sourceFolder.list();
        int n = fileNames.length;
        int i = 0;
        while (i < n) {
            String fileName = fileNames[i];
            if (filter.accept(sourceFolder, fileName)) {
                fileName = File.separator + fileName;
                String sourcePath = sourceFolder.getAbsolutePath() + fileName;
                String targetPath = targetFolder.getAbsolutePath() + fileName;
                File file = new File(sourcePath);
                if (file.isDirectory()) {
                    Util.copyFolderContent(sourcePath, targetPath, filter);
                } else {
                    Util.copyFileContent(sourcePath, targetPath);
                }
            }
            ++i;
        }
    }

    public static String printStackTraceToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String getTimeStamp() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Date d = new Date();
        String timeStamp = formatter.format(d);
        return timeStamp;
    }

    public static String normalDateFormat() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd. MMM yyyy 'at' HH:mm:ss z");
        Date d = new Date();
        String timeStamp = formatter.format(d);
        return timeStamp;
    }

    public static String convertStringToOpenSQL(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        return str;
    }

    public static String convertStringFromOpenSQL(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static File createTempFolder(String prefix, String suffix) throws IOException {
        File folder;
        String thisMethod = "createTempFolder";
        int tried = 0;
        while (true) {
            try {
                folder = File.createTempFile(prefix, suffix);
            }
            catch (IOException e) {
                String msg = "Failed to create temp folder: " + e.getMessage();
                LOCATION.traceThrowableT(100, thisMethod, msg, (Throwable)e);
                if (ACCESS_IS_DENIED_MESSAGE.equalsIgnoreCase(e.getMessage()) && tried < 100) {
                    LOCATION.debugT(thisMethod, "trying again to craete temp folder after access was denied.");
                    Thread.yield();
                    ++tried;
                    continue;
                }
                throw e;
            }
            break;
        }
        folder.delete();
        if (!folder.mkdirs()) {
            throw new IOException("could not create temporary folder " + folder.getAbsolutePath());
        }
        return folder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

