/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util;

import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class ArchiveUnpacker {
    public static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$cbs$util$ArchiveUnpacker == null ? (class$com$sap$tc$cbs$util$ArchiveUnpacker = ArchiveUnpacker.class$("com.sap.tc.cbs.util.ArchiveUnpacker")) : class$com$sap$tc$cbs$util$ArchiveUnpacker));
    private ZipInputStream zipStream;
    private static final int BUF_SIZE = 8192;
    private byte[] buf = new byte[8192];
    private int cntFiles = 0;
    private int cntFolders = 0;
    static /* synthetic */ Class class$com$sap$tc$cbs$util$ArchiveUnpacker;

    public void openArchive(File archive) throws FileNotFoundException {
        this.zipStream = new ZipInputStream(new FileInputStream(archive));
    }

    public void openArchive(InputStream source) {
        this.zipStream = new ZipInputStream(source);
    }

    public void closeArchive() {
        try {
            if (this.zipStream != null) {
                this.zipStream.close();
            }
        }
        catch (IOException ex) {
            LOCATION.catching("closeArchive", (Throwable)ex);
        }
    }

    public int unpack(String path) throws IOException, ZipException {
        String rootPath = path.endsWith(File.separator) ? path : path + File.separator;
        File rootFolder = new File(rootPath);
        int bytesWritten = 0;
        if (!rootFolder.exists() && !rootFolder.mkdirs()) {
            throw new IOException("failed to create directory " + rootFolder);
        }
        if (!rootFolder.isDirectory()) {
            throw new IllegalArgumentException("extraction path must be a directory");
        }
        ZipEntry entry = null;
        while ((entry = this.zipStream.getNextEntry()) != null) {
            String absolutePath = rootPath + entry.getName();
            if (entry.isDirectory()) {
                ++this.cntFolders;
                this.createFolder(new File(absolutePath));
            } else {
                ++this.cntFiles;
                File file = new File(absolutePath);
                FileOutputStream dest = null;
                try {
                    dest = new FileOutputStream(file);
                }
                catch (FileNotFoundException ex) {
                    this.createFolder(file.getParentFile());
                    dest = new FileOutputStream(file);
                }
                int cnt = -1;
                while ((cnt = this.zipStream.read(this.buf)) > 0) {
                    dest.write(this.buf, 0, cnt);
                    bytesWritten += cnt;
                }
                dest.close();
            }
            this.zipStream.closeEntry();
        }
        return bytesWritten;
    }

    public Iterator entries() {
        return new Iterator(){
            private ZipEntry current = null;

            public boolean hasNext() {
                try {
                    this.current = ArchiveUnpacker.this.zipStream.getNextEntry();
                    return this.current != null;
                }
                catch (IOException ex) {
                    LOCATION.catching("entries()", (Throwable)ex);
                    return false;
                }
            }

            public Object next() {
                ZipEntry next = this.current;
                if (next == null) {
                    throw new NoSuchElementException();
                }
                try {
                    this.current = ArchiveUnpacker.this.zipStream.getNextEntry();
                }
                catch (IOException ex) {
                    LOCATION.catching("next()", (Throwable)ex);
                    this.current = null;
                }
                return next;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getUnpackedFiles() {
        return this.cntFiles;
    }

    public int getUnpackedFolders() {
        return this.cntFolders;
    }

    private void createFolder(File folder) throws IOException {
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("failed to create directory " + folder.getAbsolutePath());
        }
    }

    public static void main(String[] args) throws IOException, ZipException, FileNotFoundException {
        ArchiveUnpacker unpacker = new ArchiveUnpacker();
        if (args[0].equals("-l")) {
            unpacker.openArchive(new File(args[1]));
            Iterator entries = unpacker.entries();
            while (entries.hasNext()) {
                ZipEntry entry = (ZipEntry)entries.next();
                System.out.println(entry.getName());
            }
            unpacker.closeArchive();
        } else {
            unpacker.openArchive(new File(args[0]));
            long start = System.currentTimeMillis();
            unpacker.unpack(args[1]);
            System.out.println("Unpacked " + unpacker.getUnpackedFiles() + " files in " + unpacker.getUnpackedFolders() + " folders.");
            System.out.println("Elapsed time: " + (System.currentTimeMillis() - start) + "ms");
            unpacker.closeArchive();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

