/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util;

import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ArchivePacker {
    public static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$cbs$util$ArchivePacker == null ? (class$com$sap$tc$cbs$util$ArchivePacker = ArchivePacker.class$("com.sap.tc.cbs.util.ArchivePacker")) : class$com$sap$tc$cbs$util$ArchivePacker));
    private ZipOutputStream zipStream;
    private OutputStream out;
    private File rootFolder;
    private static final int BUF_SIZE = 8192;
    private byte[] buf = new byte[8192];
    private int cntFiles = 0;
    private int cntFolders = 0;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    static /* synthetic */ Class class$com$sap$tc$cbs$util$ArchivePacker;

    public void openArchive(File archive, String rootPath) throws FileNotFoundException {
        this.openArchive(new FileOutputStream(archive), rootPath);
    }

    public void openArchive(OutputStream dest, String rootPath) throws FileNotFoundException {
        this.out = dest;
        this.zipStream = new ZipOutputStream(this.out);
        this.setRootFolder(rootPath);
    }

    public void closeArchive() throws IOException {
        try {
            this.zipStream.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.out.close();
            }
            catch (IOException ex) {
                LOCATION.catching("closeArchive", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            this.out.close();
        }
        catch (IOException ex) {
            LOCATION.catching("closeArchive", (Throwable)ex);
        }
    }

    public void setCompressionLevel(int level) {
        if ((level < 0 || level > 9) && level != -1) {
            throw new IllegalArgumentException("invalid compression level");
        }
        this.zipStream.setLevel(level);
    }

    public void setCompressionMethod(int method) {
        switch (method) {
            case 0: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid compression strategy");
            }
        }
        this.zipStream.setMethod(method);
    }

    public void addAll(boolean recursive) throws IOException, ZipException {
        this.packFolder(this.rootFolder, "", recursive);
    }

    public void add(String[] files, boolean recursive) throws IOException, ZipException {
        int i = 0;
        while (i < files.length) {
            String relPath = this.replaceSeparatorsWithSlashes(files[i]);
            File file = new File(this.rootFolder.getAbsolutePath() + File.separator + files[i]);
            if (file.isDirectory()) {
                if (!relPath.endsWith("/")) {
                    relPath = relPath + "/";
                }
                ZipEntry folderEntry = new ZipEntry(relPath);
                this.zipStream.putNextEntry(folderEntry);
                this.zipStream.closeEntry();
                this.packFolder(file, relPath, recursive);
            } else if (!file.getName().equals("__sap.dir")) {
                Object var10_9;
                ZipEntry fileEntry = new ZipEntry(relPath);
                this.zipStream.putNextEntry(fileEntry);
                FileInputStream source = new FileInputStream(file);
                int cnt = -1;
                try {
                    while ((cnt = source.read(this.buf)) > 0) {
                        this.zipStream.write(this.buf, 0, cnt);
                    }
                    var10_9 = null;
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    source.close();
                    throw throwable;
                }
                source.close();
                this.zipStream.closeEntry();
                ++this.cntFiles;
            }
            ++i;
        }
    }

    public void addDummyEntry(String name) throws IOException, ZipException {
        ZipEntry folderEntry = new ZipEntry(name);
        this.zipStream.putNextEntry(folderEntry);
        this.zipStream.closeEntry();
    }

    public int getPackedFiles() {
        return this.cntFiles;
    }

    public int getPackedFolders() {
        return this.cntFolders;
    }

    private void packFolder(File folder, String pathPrefix, boolean recursive) throws IOException, ZipException {
        String[] fileNames = folder.list();
        int n = fileNames.length;
        int i = 0;
        while (i < n) {
            File file = new File(folder.getAbsolutePath() + File.separator + fileNames[i]);
            if (file.isDirectory()) {
                if (recursive) {
                    String folderPath = pathPrefix + fileNames[i] + "/";
                    ZipEntry folderEntry = new ZipEntry(folderPath);
                    this.zipStream.putNextEntry(folderEntry);
                    this.zipStream.closeEntry();
                    ++this.cntFolders;
                    this.packFolder(file, folderPath, recursive);
                }
            } else if (!file.getName().equals("__sap.dir")) {
                Object var12_11;
                ZipEntry fileEntry = new ZipEntry(pathPrefix + file.getName());
                this.zipStream.putNextEntry(fileEntry);
                FileInputStream source = new FileInputStream(file);
                int cnt = -1;
                try {
                    while ((cnt = source.read(this.buf)) > 0) {
                        this.zipStream.write(this.buf, 0, cnt);
                    }
                    var12_11 = null;
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    source.close();
                    throw throwable;
                }
                source.close();
                this.zipStream.closeEntry();
                ++this.cntFiles;
            }
            ++i;
        }
    }

    private void setRootFolder(String rootPath) throws FileNotFoundException {
        String path = rootPath.endsWith(File.separator) ? rootPath : rootPath + File.separator;
        this.rootFolder = new File(path);
        if (!this.rootFolder.exists()) {
            this.rootFolder.mkdirs();
        }
        if (!this.rootFolder.isDirectory()) {
            throw new FileNotFoundException("invalid root folder " + this.rootFolder);
        }
    }

    private String replaceSeparatorsWithSlashes(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static void main(String[] args) throws IOException, ZipException, FileNotFoundException {
        ArchivePacker packer = new ArchivePacker();
        int index = 0;
        int level = -1;
        int method = 8;
        if (args[index].startsWith("-level")) {
            ++index;
            try {
                level = Integer.parseInt(args[index]);
                ++index;
            }
            catch (NumberFormatException ex) {
                LOCATION.catching("main", (Throwable)ex);
            }
        } else if (args[index].equals("-best")) {
            ++index;
            level = 9;
        } else if (args[index].equals("-fast")) {
            ++index;
            level = 1;
        } else if (args[index].equals("-none")) {
            ++index;
            level = 0;
        }
        if (args[index].equals("-store")) {
            ++index;
            method = 0;
        }
        packer.openArchive(new File(args[index]), args[index + 1]);
        packer.setCompressionLevel(level);
        packer.setCompressionMethod(method);
        long start = System.currentTimeMillis();
        packer.addAll(true);
        System.out.println("Packed " + packer.getPackedFiles() + " files in " + packer.getPackedFolders() + " folders.");
        System.out.println("Elapsed time: " + (System.currentTimeMillis() - start) + "ms");
        packer.closeArchive();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

