/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.api;

import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.cds.ConnectionDataAppServer;
import com.sap.tc.col.cds.ConnectionDataServiceFactory;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import java.util.Locale;

public class ServiceFacadeFactory {
    private static final String INTERNAL_FACTORY_CLASS_NAME = "com.sap.tc.col.client.generic.core.InternalServiceFacadeFactory";
    private static final InternalFactory factory;

    public static synchronized IServiceFacade createServiceFacade(String client, String user, String password, String language, String appServer, String systemNumber, boolean debug) {
        return ServiceFacadeFactory.createServiceFacade(client, user, password, language, appServer, systemNumber, debug, null);
    }

    public static synchronized IServiceFacade createServiceFacade(String client, String user, String password, String language, String appServer, String systemNumber, boolean debug, Locale locale) {
        ConnectionDataAppServer cds = (ConnectionDataAppServer)ConnectionDataServiceFactory.getConnectionDataService().getConnectionData("JCO", "0");
        cds.setClient(client);
        cds.setUser(user);
        cds.setPassword(password);
        cds.setLanguage(language);
        cds.setAppServer(appServer);
        cds.setSystemNumber(systemNumber);
        cds.setDebug(debug);
        cds.setSync(false);
        return ServiceFacadeFactory.createServiceFacade((ConnectionData)cds, locale);
    }

    public static synchronized IServiceFacade createServiceFacade(ConnectionData connectionData) {
        return ServiceFacadeFactory.createServiceFacade(connectionData, null);
    }

    public static synchronized IServiceFacade createServiceFacade(ConnectionData connectionData, Locale locale) {
        return factory.createServiceFacade(connectionData, false, locale);
    }

    static {
        try {
            factory = (InternalFactory)Class.forName(INTERNAL_FACTORY_CLASS_NAME).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to create internal ServiceFacadeFactory 'com.sap.tc.col.client.generic.core.InternalServiceFacadeFactory': " + e);
        }
    }

    public static interface InternalFactory {
        public IServiceFacade createServiceFacade(ConnectionData var1, boolean var2, Locale var3);
    }
}

