/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ear;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class EarPlugin
extends Plugin {
    public static final String ID = "com.tssap.j2ee.core.ear";
    private boolean myTracing;
    private static EarPlugin ourInstance;

    public EarPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
    }

    public static EarPlugin getDefault() {
        return ourInstance;
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public static void logInfo(String text) {
        EarPlugin instance = EarPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        EarPlugin.log(1, text);
    }

    public static void logError(String text) {
        EarPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        EarPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        EarPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        EarPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        EarPlugin instance = EarPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            EarPlugin.log(type, text, new Throwable());
        } else {
            EarPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        EarPlugin instance = EarPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

