/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wsil;

import com.sap.engine.lib.jaxp.SAXParserFactoryImpl;
import com.sap.ide.ws.wsil.WebService;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WSILParser
extends DefaultHandler {
    public static final String NS_WSIL = "http://schemas.xmlsoap.org/ws/2001/10/inspection/";
    private static final int NONE = -1;
    private static final int SERVICE = 0;
    private static final int DESCRIPTION = 1;
    private static final int SERVICE_NAME = 2;
    private static final int ENDPOINT_URI = 3;
    private Vector webServices = new Vector();
    private WebService currentService = new WebService();
    private int startedElement = -1;

    private WebService[] getWebServices() {
        Object[] services = new WebService[this.webServices.size()];
        this.webServices.copyInto(services);
        return services;
    }

    public static WebService[] getServices(String wsilURL) throws Exception {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        SAXParser parser = factory.newSAXParser();
        WSILParser handler = new WSILParser();
        parser.parse(wsilURL, (DefaultHandler)handler);
        return handler.getWebServices();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length).trim();
        switch (this.startedElement) {
            case 2: {
                this.currentService.setName(data);
                break;
            }
            case 1: {
                this.currentService.setDescription(data);
                break;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (NS_WSIL.equals(uri)) {
            if ("service".equals(localName)) {
                this.webServices.addElement(this.currentService);
            } else if ("abstract".equals(localName)) {
                this.startedElement = 0;
            } else if ("name".equals(localName)) {
                this.startedElement = 0;
            } else if ("description".equals(localName)) {
                this.startedElement = 0;
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (NS_WSIL.equals(uri)) {
            if ("service".equals(localName)) {
                this.currentService = new WebService();
            } else if ("abstract".equals(localName)) {
                this.startedElement = 1;
            } else if ("name".equals(localName)) {
                this.startedElement = 2;
            } else if ("description".equals(localName)) {
                String wsdlLocation = attributes.getValue("location");
                if (wsdlLocation != null && wsdlLocation.startsWith("http://")) {
                    int start = wsdlLocation.indexOf("/", 7);
                    int end = wsdlLocation.indexOf("?");
                    String endpoint = end != -1 ? wsdlLocation.substring(start, end) : wsdlLocation.substring(start);
                    this.currentService.appendURI(endpoint);
                }
                if (wsdlLocation != null && this.currentService.getDefaultWSDLURL() == null) {
                    this.currentService.setDefaultWSDLURL(wsdlLocation);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        WebService[] webService = WSILParser.getServices("http://localhost:50000/inspection.wsil");
        int i = 0;
        while (i < webService.length) {
            WebService ws = webService[i];
            System.out.println("WS: " + ws.getName() + ", WSDL: " + ws.getDefaultWSDLURL());
            String[] uri = ws.getEndpointURIs();
            int j = 0;
            while (j < uri.length) {
                System.out.println("      " + uri[j]);
                ++j;
            }
            ++i;
        }
    }
}

