/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wizards.ws.pages;

import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.endpoints.EndpointBrower;
import com.sap.ide.vi.endpoints.EndpointReference;
import com.sap.ide.vi.wizards.generic.adapter.WizardButtonStatusAdapter;
import com.sap.ide.vi.wizards.generic.elements.DialogFieldDescription;
import com.sap.ide.vi.wizards.generic.pages.BasicPage;
import com.sap.ide.vi.wizards.generic.pages.BasicProjectSelectionPage;
import com.sap.ide.vi.wizards.generic.pages.WizardStatusContributor;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.services.content.provider.EndpointProjectProvider;
import com.sap.ide.ws.core.services.content.provider.ProjectProvider;
import com.sap.ide.ws.core.services.editors.DescriptorEditorUtils;
import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.ide.ws.core.services.selena.SelenaJavaAdapter;
import com.sap.ide.ws.editors.descriptor.WsDDEditor;
import com.sap.ide.ws.soapapp.SOAPApplicationDt;
import com.sap.ide.ws.soapapp.SOAPApplicationFactoryDt;
import com.sap.ide.ws.text.CheckServices;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.wizards.ws.WebServiceWizard;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.WebService;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.selena.model.elements.Element;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;

public class WsWizardInitialPage
extends BasicProjectSelectionPage {
    private static String LABEL_CFG_NAME = WsUiTexts.getString("WsWizardLastPage.Labels.configName");
    private static String LABEL_WS_NAME = WsUiTexts.getString("WsWizardLastPage.Labels.wsName");
    private static String LABEL_DEFAULT_CFG_TYPE = WsUiTexts.getString("WsWizardLastPage.Labels.configType");
    private static String LABEL_EJBJAR_PROJECT = WsUiTexts.getString("WsWizardLastPage.Labels.assemplyProjectName");
    private static String LABEL_ENDPOINT_REFERENCE = WsUiTexts.getString("WsWizardLastPage.Labels.endpointName");
    private String assProjectName;
    private String endpointName;
    private SOAPApplicationDt soapApp;
    private Vector forbiddenWsdReferenceNames = new Vector();
    static /* synthetic */ Class class$org$eclipse$jdt$core$IPackageFragmentRoot;

    public WsWizardInitialPage(String descriptorProjectName, String endpointName) {
        super("Last WebServicePage");
        DeploymentDescriptor descriptor;
        this.setDescription(WsUiTexts.getString("WsWizardLastPage.description"));
        this.setTitle(WsUiTexts.getString("WsWizardLastPage.title"));
        this.assProjectName = descriptorProjectName;
        this.endpointName = endpointName;
        this.initialiseSoapApp(descriptorProjectName);
        if (descriptorProjectName != null && (descriptor = this.getDescriptor(descriptorProjectName)) != null) {
            WebService[] webservices = descriptor.getWebServices();
            int i = 0;
            while (i < webservices.length) {
                this.forbiddenWsdReferenceNames.add(webservices[i].getInternalName());
                ++i;
            }
        }
    }

    protected String getPageDescription() {
        return WsUiTexts.getString("WsWizardLastPage.description");
    }

    public void init(Element selenaSelection) {
        super.init(selenaSelection);
        ICompilationUnit compilationUnit = SelenaJavaAdapter.getCompilationUnit((Element)selenaSelection);
        if (compilationUnit != null) {
            this.endpointName = compilationUnit.getType(compilationUnit.getElementName().substring(0, compilationUnit.getElementName().indexOf(46))).getFullyQualifiedName();
        }
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        if (selection.getFirstElement() instanceof ICompilationUnit) {
            ICompilationUnit compilationUnit = (ICompilationUnit)selection.getFirstElement();
            this.endpointName = compilationUnit.getType(compilationUnit.getElementName().substring(0, compilationUnit.getElementName().indexOf(46))).getFullyQualifiedName();
        }
    }

    private JavaProject getJavaProject(ICompilationUnit compilationUnit) {
        IJavaElement parent = compilationUnit.getParent();
        while (!(parent instanceof JavaProject)) {
            parent = parent.getParent();
        }
        return (JavaProject)parent;
    }

    private void initialiseSoapApp(String descriptorProjectName) {
        SOAPApplicationDt[] soapApps = J2eeProjectManager.getJ2eeProject((String)descriptorProjectName) != null ? SOAPApplicationFactoryDt.createSOAPApplication((String)"EP_TYPE_EJB") : SOAPApplicationFactoryDt.createSOAPApplication((String)"EP_TYPE_JAVACLASS");
        if (soapApps != null && soapApps.length > 0) {
            this.soapApp = soapApps[0];
        }
        this.setPageComplete(false);
    }

    private DeploymentDescriptor getDescriptor(String projectName) {
        IEditorPart editor = DescriptorEditorUtils.findEditorPartForDescriptor((String)projectName);
        DeploymentDescriptor dd = null;
        dd = editor == null ? DescriptorManager.getDeploymentDescriptor((String)projectName) : (DeploymentDescriptor)((WsDDEditor)editor).getEditingObject();
        return dd;
    }

    public ProjectProvider getMyProjectListContentProvider() {
        return new EndpointProjectProvider();
    }

    public Class[] getMyAcceptedProjectSelectionClasses() {
        return new Class[]{class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = WsWizardInitialPage.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot};
    }

    public void createControl(Composite parent) {
        int nColumns = 4;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)composite);
        this.createProjectSourceFolderControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createReferencedObjectControls(composite, nColumns, LABEL_ENDPOINT_REFERENCE, this.getUniqueProjectSourceFieldLabel(), new WizardButtonStatusAdapter(){

            public IStatus fieldChanged() {
                IPackageFragmentRoot root = WsWizardInitialPage.this.getRootByContainer();
                if (root == null && this.getText() != null && this.getText().length() > 0) {
                    this.setText("");
                }
                this.setEnabled(root != null);
                return WsWizardInitialPage.this.endpointNameChanged(root);
            }

            public String fieldLabelText() {
                return LABEL_ENDPOINT_REFERENCE;
            }

            public void changeControlPressed(DialogField field) {
                String endpoint = WsWizardInitialPage.this.chooseEndpoint();
                if (endpoint != null) {
                    this.setText(endpoint);
                }
            }
        }, this.endpointName);
        this.createNameControls(composite, nColumns, LABEL_WS_NAME, new WizardStatusContributor(){

            public IStatus fieldChanged() {
                return WsWizardInitialPage.this.wsNameFieldChanged();
            }

            public String fieldLabelText() {
                return LABEL_WS_NAME;
            }
        }, null);
        this.createComboBoxControls(composite, nColumns, LABEL_DEFAULT_CFG_TYPE, new WizardStatusContributor(){

            public IStatus fieldChanged() {
                return WsWizardInitialPage.this.configurationTypeChanged();
            }

            public String fieldLabelText() {
                return LABEL_DEFAULT_CFG_TYPE;
            }
        }, this.soapApp.getDefaultConfigurationNames(), this.soapApp.getDefaultConfigurationNames()[0]);
        this.createDescriptionField(composite, nColumns, true, true, null, 16, new DialogFieldDescription(){

            public String getDescription() {
                return WsWizardInitialPage.this.soapApp.getDescriptionForConfiguration((String)WsWizardInitialPage.this.getContentByLabelText(LABEL_DEFAULT_CFG_TYPE));
            }
        });
        this.createNameControls(composite, nColumns, LABEL_CFG_NAME, new WizardStatusContributor(){

            public IStatus fieldChanged() {
                return WsWizardInitialPage.this.cfgNameFieldChanged();
            }

            public String fieldLabelText() {
                return LABEL_CFG_NAME;
            }
        }, "Config1");
        this.createDescriptionField(composite, nColumns, false, false, WsUiTexts.getString("WsWizardLastPage.Labels.accessUrl"), 2, new DialogFieldDescription(){

            public String getDescription() {
                return WsWizardInitialPage.this.soapApp.getAccessUrlName((String)WsWizardInitialPage.this.getContentByLabelText(LABEL_WS_NAME), (String)WsWizardInitialPage.this.getContentByLabelText(LABEL_CFG_NAME));
            }
        });
        this.setControl((Control)composite);
    }

    private String chooseEndpoint() {
        IPackageFragmentRoot root = this.getRootByContainer();
        if (root == null) {
            return null;
        }
        String projectName = root.getResource().getProject().getName();
        return EndpointBrower.browseEndpoints((String)projectName, (IPackageFragmentRoot)root, (IRunnableContext)this.getWizard().getContainer(), (boolean)true);
    }

    private IStatus endpointNameChanged(IPackageFragmentRoot root) {
        StatusInfo status = new StatusInfo();
        String endpointName = this.getEndpointName();
        ((WebServiceWizard)this.getWizard()).setEndpointName(endpointName);
        if (root != null) {
            if (J2eeProjectManager.getEjbModule((String)root.getJavaProject().getProject().getName()) != null) {
                if (endpointName != null && endpointName.length() == 0) {
                    status.setError(WsUiTexts.getString("WsWizardLastPage.Errors.noEjbRefSpecified"));
                    return status;
                }
                if (root != null && !((WebServiceWizard)this.getWizard()).ejbReferenceExists(endpointName)) {
                    status.setError(WsUiTexts.getString("WsWizardLastPage.Errors.invalidEjbRef"));
                }
            } else if (WebServiceFilterFactory.isJavaProject((IProject)root.getJavaProject().getProject())) {
                if (endpointName != null && endpointName.length() == 0) {
                    status.setError("No Java Class Endpoint specified.");
                }
                IType type = EndpointAnalyser.getITypeByEndpoint((EndpointReference)new EndpointReference(root.getJavaProject().getProject().getName(), endpointName, EndpointReference.CLASS_TYPE));
                try {
                    if (type == null) {
                        status.setError("The endpoint you specified does not exist in the specified project.");
                    } else if (type.isInterface()) {
                        status.setError("The endpoint you have entered is an interface. It has to be a concrete type with a default constructor and public methods.");
                    } else if (Flags.isAbstract((int)type.getFlags())) {
                        status.setError("The endpoint you have entered is an abstract class. It has to be a concrete type with a default constructor and public methods.");
                    }
                }
                catch (JavaModelException e) {
                    status.setError("The endpoint does not exist in the specified project, is corrupt or cannot be checked.");
                }
            }
        }
        return status;
    }

    public String getEndpointName() {
        return (String)this.getContentByLabelText(LABEL_ENDPOINT_REFERENCE);
    }

    public String getAssemblyProject() {
        String value = this.getProjectFromProjectSourceFolderField();
        if (value != null && value.length() < 1) {
            return null;
        }
        return value;
    }

    private IStatus configurationTypeChanged() {
        String text = (String)this.getContentByLabelText(LABEL_DEFAULT_CFG_TYPE);
        StatusInfo status = new StatusInfo();
        if (text == null || text.length() < 1) {
            status.setError(WsUiTexts.getString("WsWizardLastPage.Errors.noDefaultCfgType"));
        } else {
            String[] defaultConfigTypes = this.soapApp.getDefaultConfigurationNames();
            int i = 0;
            while (i < defaultConfigTypes.length) {
                if (defaultConfigTypes[i].equals(text)) {
                    return status;
                }
                ++i;
            }
            status.setError(WsUiTexts.getString("WsWizardLastPage.Errors.invalidDefCfgType"));
        }
        return status;
    }

    public void doStatusUpdate() {
        if (((BasicPage)this).fieldStatusList.size() > 0) {
            IStatus[] resultStatus = new IStatus[((BasicPage)this).fieldStatusList.size()];
            int i = 0;
            while (i < ((BasicPage)this).fieldStatusList.size()) {
                resultStatus[i] = ((WizardStatusContributor)((BasicPage)this).fieldStatusList.get(i)).fieldChanged();
                ++i;
            }
            this.updateStatus(resultStatus);
        }
    }

    private IStatus cfgNameFieldChanged() {
        String text = (String)this.getContentByLabelText(LABEL_CFG_NAME);
        StatusInfo status = new StatusInfo();
        if (text == null || text.length() < 1) {
            status.setError(WsUiTexts.getString("WsWizardLastPage.Errors.noCfgName"));
        } else if (!CheckServices.isValidIdentifier(text)) {
            status.setError(WsUiTexts.getString("WsWizardLastPage.Errors.invalidCfgName", text));
        }
        return status;
    }

    private IStatus wsNameFieldChanged() {
        String text = (String)this.getContentByLabelText(LABEL_WS_NAME);
        StatusInfo status = new StatusInfo();
        if (text == null || text.length() < 1) {
            status.setError(WsUiTexts.getString("WsWizardLastPage.Errors.noWsName"));
        } else if (!CheckServices.isValidIdentifier(text)) {
            status.setError(WsUiTexts.getString("WsWizardLastPage.Errors.invalidWsName", text));
        } else if (this.forbiddenWsdReferenceNames.contains(text)) {
            status.setError(WsUiTexts.getString("WsWizardLastPage.Errors.wsExists", text));
        }
        if (status.isOK()) {
            ((WebServiceWizard)this.getWizard()).setWebServiceName(text);
        }
        return status;
    }

    public String getWebServiceName() {
        return (String)this.getContentByLabelText(LABEL_WS_NAME);
    }

    public String getDefaultConfigurationType() {
        return (String)this.getContentByLabelText(LABEL_DEFAULT_CFG_TYPE);
    }

    public String getConfigName() {
        return (String)this.getContentByLabelText(LABEL_CFG_NAME);
    }

    public String getDescriptorProject() {
        return (String)this.getContentByLabelText(BasicProjectSelectionPage.LABEL_TEXT_SOURCE_FOLDER);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

