/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wizards.descriptor.wscfg.pages;

import com.sap.ide.metamodel.vi.ComplexTypeReference;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.Parameter;
import com.sap.ide.metamodel.vi.TypeReference;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.vi.services.CheckServices;
import com.sap.ide.vi.wizards.generic.pages.BasicPage;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.ui.dialogs.WsSelectionDialog;
import com.sap.ide.ws.ui.dialogs.WsdInfoLabelProvider;
import com.sap.ide.ws.ui.dialogs.typeinfo.WsReferenceTypeInfo;
import com.sap.ide.ws.wizards.descriptor.wscfg.NewWsCfgWizard;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.TransportBinding;
import com.sap.ide.ws.wsddman.WebService;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class NewCfgPage
extends BasicPage {
    private Text wsdReferenceNameText;
    private Button selectWsdReferenceButton;
    private WebServiceDefinition currentDefinition;
    private WebService webService;
    private Text newConfigName;
    private Combo tpBindingList;
    public static String[] SIMPLE_TP_BINDINGS = new String[]{"HTTP GET", "HTTP POST", "HTTP SOAP", "HTTP SOAP with Attachments"};
    public static String[] COMPLEX_TP_BINDINGS = new String[]{"HTTP SOAP", "HTTP SOAP with Attachments"};
    public static String[] PUBLISHED_TP_BINDINGS = new String[]{"HTTP SOAP"};
    private static final String DEFAULT_CONFIG_NAME = "Config";
    private IStatus currentStatus = new StatusInfo(0, "");
    private IStatus wsdStatus = new StatusInfo(0, "");
    private IStatus newConfigStatus = new StatusInfo(0, "");
    private IStatus tpBindingStatus = new StatusInfo(0, "");
    private String[] presetBinding = null;
    private boolean visible = false;

    public NewCfgPage() {
        super("NewConfigurationPage");
        this.setTitle(NewWsCfgWizard.WIZARD_INFO);
        this.setDescription(WsUiTexts.getString("NewCfgPage.description"));
    }

    protected String getPageDescription() {
        return WsUiTexts.getString("NewCfgPage.description");
    }

    public void initialisePage(WebService service) {
        this.webService = service;
        this.currentDefinition = WebServiceMdoResolver.getWebServiceDefinitionFromWorkSpace((String)service.getGUID());
    }

    public static String convertRtBindingNameToDtBingingName(TransportBinding binding) {
        if (binding.getName().equals("SOAPHTTP_TransportBinding")) {
            return "HTTP SOAP";
        }
        if (binding.getName().equals("MIME_TransportBinding")) {
            return "HTTP SOAP with Attachments";
        }
        if (binding.getName().equals("HTTP_TransportBinding")) {
            if (binding.getWebMethod().equals("GET")) {
                return "HTTP GET";
            }
            if (binding.getWebMethod().equals("POST")) {
                return "HTTP POST";
            }
        }
        return null;
    }

    private String[] getAllowedBindingsForService() {
        if (this.webService != null && this.webService.getConfigurations().length > 0) {
            return new String[]{NewCfgPage.convertRtBindingNameToDtBingingName(this.webService.getConfigurations()[0].getTransportBinding())};
        }
        if (this.currentDefinition.getuddiTModelPublicationCount() > 0) {
            return PUBLISHED_TP_BINDINGS;
        }
        return this.getAvailableTpBindingsForVi();
    }

    public void createControl(Composite parent) {
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)3);
        mainPane.setLayoutData((Object)new GridData(32));
        mainPane.addTextLabel("Web Service:", mainPane.createGridLayoutData(4, 4, false, false, 3, 1));
        this.wsdReferenceNameText = mainPane.addTextField("", mainPane.createGridLayoutData(4, 4, true, false, 2, 1));
        this.wsdReferenceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCfgPage.this.doStatusUpdate();
                IStatus wsdStatus = NewCfgPage.this.checkWsdNameStatus();
                if (wsdStatus.getCode() == 0) {
                    NewCfgPage.this.tpBindingList.setItems(NewCfgPage.this.getAllowedBindingsForService());
                    if (NewCfgPage.this.tpBindingList.getItemCount() == 4) {
                        NewCfgPage.this.tpBindingList.select(2);
                        NewCfgPage.this.tpBindingList.setEnabled(true);
                    } else if (NewCfgPage.this.tpBindingList.getItemCount() == 1) {
                        NewCfgPage.this.tpBindingList.select(0);
                        NewCfgPage.this.tpBindingList.setEnabled(false);
                    }
                }
            }
        });
        this.wsdReferenceNameText.setEnabled(false);
        this.selectWsdReferenceButton = mainPane.addPushButton("Browse...", mainPane.createGridLayoutData(1, 4, false, false, 1, 1));
        this.selectWsdReferenceButton.addSelectionListener((SelectionListener)new BrowseWsdButtonSelectionListener());
        mainPane.addPlaceholder();
        mainPane.addPlaceholder();
        mainPane.addPlaceholder();
        mainPane.addHorizontalSeparator();
        mainPane.addPlaceholder();
        mainPane.addPlaceholder();
        mainPane.addPlaceholder();
        mainPane.addTextLabel(WsUiTexts.getString("WsWizardLastPage.Labels.configName"), mainPane.createGridLayoutData(4, 4, false, false, 3, 1));
        this.newConfigName = mainPane.addTextField("", mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        this.setInitialConfigName();
        this.newConfigName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCfgPage.this.doStatusUpdate();
            }
        });
        mainPane.addTextLabel(WsUiTexts.getString("NewCfgPage.Label.transportBinging"), mainPane.createGridLayoutData(4, 4, false, false, 3, 1));
        this.tpBindingList = mainPane.addComboBox(new String[0], "", true, mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        this.tpBindingList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewCfgPage.this.doStatusUpdate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.webService != null) {
            this.wsdReferenceNameText.setText(this.webService.getInternalName());
        }
        this.setControl((Control)mainPane.getComposite());
    }

    private void setInitialConfigName() {
        int i = 1;
        this.newConfigName.setText(DEFAULT_CONFIG_NAME + i);
        ++i;
        while (this.checkConfigNameExists(this.newConfigName.getText())) {
            this.newConfigName.setText(DEFAULT_CONFIG_NAME + i);
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.visible = visible;
        if (visible && this.currentStatus.matches(4)) {
            StatusInfo status = new StatusInfo();
            status.setError("");
            this.currentStatus = status;
        }
        this.doStatusUpdate();
    }

    public String getNewConfigName() {
        return this.newConfigName.getText();
    }

    public WebServiceDefinition getWebServiceDefinition() {
        return this.currentDefinition;
    }

    public WebService getWebService() {
        return this.webService;
    }

    public String getTransportBinding() {
        return this.tpBindingList.getText();
    }

    protected void updateStatus(IStatus[] status) {
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    protected void updateStatus(IStatus status) {
        this.currentStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.visible) {
            StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
        }
    }

    private boolean checkExists(String configName, WebService webService) {
        if (webService != null) {
            Configuration[] cfgs = webService.getConfigurations();
            if (cfgs != null) {
                int i = 0;
                while (i < cfgs.length) {
                    if (cfgs[i].getName().equals(configName)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return false;
    }

    private boolean checkConfigNameExists(String configName) {
        return this.checkExists(configName, this.webService);
    }

    public void doStatusUpdate() {
        this.wsdStatus = this.checkWsdNameStatus();
        IStatus[] status = new IStatus[]{this.wsdStatus, this.newConfigStatus = this.checkNewConfigNameStatus(), this.tpBindingStatus = this.checktpBindingStatus()};
        this.updateStatus(status);
    }

    private IStatus checkWsdNameStatus() {
        if (this.wsdReferenceNameText.getText().length() < 1) {
            this.tpBindingList.setEnabled(false);
            return new StatusInfo(4, WsUiTexts.getString("NewCfgPage.Errors.noWsSelected"));
        }
        if (this.getAllowedBindingsForService().length > 1) {
            this.tpBindingList.setEnabled(true);
        }
        return new StatusInfo(0, this.getPageDescription());
    }

    private String[] getAvailableTpBindingsForVi() {
        VirtualInterface vi = WebServiceMdoResolver.getReferencedViForWsd((String)this.getProjectName(), (String)this.webService.getGUID());
        Function[] functions = vi.getFunctions();
        int i = 0;
        while (i < functions.length) {
            Parameter[] params = functions[i].getIncomingParameters();
            int j = 0;
            while (j < params.length) {
                TypeReference typeRef = params[j].getMappedTypeReference();
                if (typeRef instanceof ComplexTypeReference) {
                    return COMPLEX_TP_BINDINGS;
                }
                ++j;
            }
            ++i;
        }
        return SIMPLE_TP_BINDINGS;
    }

    private IStatus checktpBindingStatus() {
        if (this.tpBindingList.getText() == null || this.tpBindingList.getText().length() < 1) {
            return new StatusInfo(4, WsUiTexts.getString("NewCfgPage.Errors.noTbSelected"));
        }
        if (this.currentDefinition.getuddiTModelPublicationCount() > 0 && !this.tpBindingList.getText().equals("HTTP SOAP")) {
            return new StatusInfo(2, WsUiTexts.getString("NewCfgPage.Warnings.binding"));
        }
        return new StatusInfo(0, this.getPageDescription());
    }

    private IStatus checkNewConfigNameStatus() {
        String content = this.newConfigName.getText();
        if (!CheckServices.isValidIdentifier((String)content) || CheckServices.startsWithNumber((String)content)) {
            return new StatusInfo(4, WsUiTexts.getString("NewCfgPage.Errors.noCfgName"));
        }
        if (this.checkConfigNameExists(content)) {
            return new StatusInfo(4, WsUiTexts.getString("NewCfgPage.Errors.cfgNameExists"));
        }
        return new StatusInfo(0, this.getPageDescription());
    }

    private String getProjectName() {
        return ((NewWsCfgWizard)this.getWizard()).getProjectName();
    }

    private void browseWebServices() {
        Object o;
        WsSelectionDialog dialog = new WsSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WsdInfoLabelProvider(16), (ILabelProvider)new WsdInfoLabelProvider(40), "Web Service", this.getProjectName(), ((NewWsCfgWizard)this.getWizard()).getDeploymentDescriptor());
        dialog.setTitle(WsUiTexts.getString("NewCfgPage.wsSelection"));
        dialog.setMessage(WsUiTexts.getString("NewCfgPage.wsSelectionDialogMessage"));
        if (dialog.open() == 0 && (o = dialog.getFirstResult()) instanceof WsReferenceTypeInfo) {
            this.currentDefinition = ((WsReferenceTypeInfo)((Object)o)).getWsd();
            String serviceName = ((WsReferenceTypeInfo)((Object)o)).getTypeName();
            this.webService = ((NewWsCfgWizard)this.getWizard()).getDeploymentDescriptor().getWebService(this.currentDefinition.getGuid(), serviceName);
            this.wsdReferenceNameText.setText(serviceName);
        }
    }

    private class BrowseWsdButtonSelectionListener
    implements SelectionListener {
        private BrowseWsdButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            NewCfgPage.this.browseWebServices();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }
    }
}

