/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wizards.descriptor.wscfg;

import com.sap.ide.ws.configuration.WsConfigurationManager;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.wizards.descriptor.wscfg.pages.NewCfgPage;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.WebService;
import com.sap.ide.ws.wsddman.impl0.FeatureImpl;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewWsCfgWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_INFO = WsUiTexts.getString("NewWsCfgWizard.title");
    private NewCfgPage newCfgPage;
    private DeploymentDescriptor dd;
    private WebService parentService;
    private Configuration config;
    private String projectName;

    private NewWsCfgWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WsCoreUiTexts.getString((String)"WebServices.Wizards.title"));
    }

    public NewWsCfgWizard(WebService parentService, String projectName, DeploymentDescriptor dd) {
        this();
        this.parentService = parentService;
        this.projectName = projectName;
        this.dd = dd;
    }

    public WebService getParentService() {
        return this.parentService;
    }

    public void addPages() {
        this.newCfgPage = new NewCfgPage();
        this.addPage((IWizardPage)this.newCfgPage);
        if (this.parentService != null) {
            this.newCfgPage.initialisePage(this.parentService);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        if (this.newCfgPage.getWebService() != null) {
            this.config = WsConfigurationManager.createConfiguration(this.newCfgPage.getWebService(), this.newCfgPage.getNewConfigName(), this.newCfgPage.getTransportBinding(), null, this.projectName, this.newCfgPage.getWebServiceDefinition());
            return true;
        }
        return false;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.dd;
    }

    public String getProjectName() {
        return this.projectName;
    }

    private void addFeature(ArrayList a, String featurename, String protocol) {
        FeatureImpl newfeature = new FeatureImpl();
        newfeature.setName(featurename);
        newfeature.setProtocol(protocol);
        a.add(newfeature);
    }
}

