/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wizards.descriptor.ws.pages;

import com.sap.ide.vi.wizards.generic.adapter.WizardButtonStatusAdapter;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.ui.dialogs.BeanSelectionDialog;
import com.sap.ide.ws.wizards.descriptor.ws.AddWsToDescriptorWizard;
import com.sap.ide.ws.wizards.descriptor.ws.pages.AbstractNewWsPage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class NewEJBBasedWsPage
extends AbstractNewWsPage {
    private static final String CHOOSE_EJB_LABEL = WsUiTexts.getString("NewEJBBasedWsPage.Labels.selectEjb");

    public NewEJBBasedWsPage(String endpointProjectName) {
        super(endpointProjectName);
    }

    protected String getLabel() {
        return CHOOSE_EJB_LABEL;
    }

    protected void createControls(Composite composite, int nColumns) {
        this.createReferencedObjectControls(composite, nColumns, CHOOSE_EJB_LABEL, null, WsCoreUiTexts.getString((String)"WsButton.browse"), new WizardButtonStatusAdapter(){

            public IStatus fieldChanged() {
                return NewEJBBasedWsPage.this.ejbNameFieldChanged();
            }

            public String fieldLabelText() {
                return CHOOSE_EJB_LABEL;
            }

            public void changeControlPressed(DialogField field) {
                String beanName = NewEJBBasedWsPage.this.handleBrowseEjbsButtonPressed();
                if (beanName != null) {
                    this.setText(beanName);
                    NewEJBBasedWsPage.this.doStatusUpdate();
                }
            }
        });
    }

    protected boolean checkInput() {
        return this.checkEjbExists((String)this.getContentByLabelText(CHOOSE_EJB_LABEL)) != null;
    }

    public String getEjbName() {
        return (String)this.getContentByLabelText(CHOOSE_EJB_LABEL);
    }

    private IStatus ejbNameFieldChanged() {
        String content = (String)this.getContentByLabelText(CHOOSE_EJB_LABEL);
        if (content == null || content.length() < 1) {
            return new StatusInfo(4, WsUiTexts.getString("NewEJBBasedWsPage.Errors.noEjbSelected"));
        }
        Entity beanProxy = this.checkEjbExists(content);
        if (beanProxy == null) {
            return new StatusInfo(4, WsUiTexts.getString("NewEJBBasedWsPage.Errors.invalidNameSpecified"));
        }
        this.setPageData(beanProxy);
        return new StatusInfo(0, "");
    }

    private void setPageData(Entity beanProxy) {
        Element bean = this.getReferencedBean((Element)beanProxy);
        this.setProjectName(bean.getModel().getUniqueName().getName());
        this.setImplClassName(bean.getPropertyValue("beanClass"));
    }

    private Entity checkEjbExists(String beanName) {
        Object[] beanList = BeanSelectionDialog.getBeansForProject(this.getProjectName());
        int i = 0;
        while (i < beanList.length) {
            if (((Entity)beanList[i]).getProperty("$name").getValue().equals(beanName)) {
                return (Entity)beanList[i];
            }
            ++i;
        }
        return null;
    }

    private String handleBrowseEjbsButtonPressed() {
        Object[] result;
        BeanSelectionDialog dialog = new BeanSelectionDialog(Display.getCurrent().getActiveShell(), ((AddWsToDescriptorWizard)this.getWizard()).getProjectName());
        dialog.setTitle(WsUiTexts.getString("AbstractNewWsPage.wsdSelectionDialogTitle"));
        dialog.setMessage(WsUiTexts.getString("AbstractNewWsPage.wsdSelectionDialogMessage"));
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0 && result[0] != null) {
            return ((Entity)result[0]).getPropertyValue("$name");
        }
        return null;
    }

    private Element getReferencedBean(Element beanProxy) {
        return ProxyMetaInfo.getSourceEntity((UniqueName)beanProxy.getUniqueName());
    }
}

