/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wizards.descriptor.ws.pages;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.vi.EjbEndpointReference;
import com.sap.ide.metamodel.vi.EndpointReference;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.metamodel.ws.plugin.WSRootManager;
import com.sap.ide.vi.wizards.generic.adapter.WizardButtonStatusAdapter;
import com.sap.ide.vi.wizards.generic.pages.BasicProjectSelectionPage;
import com.sap.ide.vi.wizards.generic.pages.WizardStatusContributor;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.core.services.editors.DescriptorEditorUtils;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.text.CheckServices;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.ui.dialogs.WsSelectionDialog;
import com.sap.ide.ws.ui.dialogs.WsdInfoLabelProvider;
import com.sap.ide.ws.ui.dialogs.typeinfo.WsTypeInfo;
import com.sap.ide.ws.wizards.descriptor.ws.AddWsToDescriptorWizard;
import com.sap.ide.ws.wizards.wsd.WebServiceDefinitionWizard;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.WebService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractNewWsPage
extends BasicProjectSelectionPage {
    private static final String CHOOSE_WSD_LABEL = WsUiTexts.getString("AbstractNewWsPage.Labels.selectWsd");
    private static final String REFERENCE_NAME_LABEL = WsUiTexts.getString("WsWizardLastPage.Labels.wsName");
    private WebServiceDefinition wsd;
    private String endpointProjectName;
    private String qualifiedImplClassName;

    public AbstractNewWsPage(String endpointProjectName) {
        super("Add WSD");
        this.endpointProjectName = endpointProjectName;
        this.setTitle(WsUiTexts.getString("AbstractNewWsPage.title"));
        this.setDescription(WsUiTexts.getString("AbstractNewWsPage.description"));
    }

    protected String getPageDescription() {
        return WsUiTexts.getString("AbstractNewWsPage.description");
    }

    public void createControl(Composite parent) {
        int nColumns = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)composite);
        this.createControls(composite, nColumns);
        this.createReferencedObjectControls(composite, nColumns, CHOOSE_WSD_LABEL, this.getLabel(), WsCoreUiTexts.getString((String)"WsButton.browse"), new WizardButtonStatusAdapter(){

            public IStatus fieldChanged() {
                IStatus status;
                this.setEnabled(AbstractNewWsPage.this.checkInput());
                if (!AbstractNewWsPage.this.checkInput() && this.getText().length() > 0) {
                    this.setText("");
                }
                if ((status = AbstractNewWsPage.this.wsdNameFieldChanged()).getSeverity() == 0) {
                    AbstractNewWsPage.this.wsd = AbstractNewWsPage.this.getWebServiceDefinition((String)AbstractNewWsPage.this.getContentByLabelText(CHOOSE_WSD_LABEL));
                }
                return status;
            }

            public String fieldLabelText() {
                return CHOOSE_WSD_LABEL;
            }

            public void changeControlPressed(DialogField field) {
                WebServiceDefinition newWsd = AbstractNewWsPage.this.handleBrowseWsdsButtonPressed();
                if (newWsd != null) {
                    String wsdPackage = newWsd.getPackage();
                    if (wsdPackage.length() > 0) {
                        this.setText(newWsd.getPackage() + "." + newWsd.getName());
                    } else {
                        this.setText(newWsd.getName());
                    }
                    AbstractNewWsPage.this.wsd = newWsd;
                    AbstractNewWsPage.this.doStatusUpdate();
                }
            }
        });
        this.createNameControls(composite, nColumns, REFERENCE_NAME_LABEL, new WizardStatusContributor(){

            public IStatus fieldChanged() {
                return AbstractNewWsPage.this.wsdReferenceNameFieldChanged();
            }

            public String fieldLabelText() {
                return REFERENCE_NAME_LABEL;
            }
        }, null);
        this.setControl((Control)composite);
    }

    public String getWsdGuid() {
        return this.wsd.getGuid();
    }

    public WebServiceDefinition getWsd() {
        return this.wsd;
    }

    public String getWsdName() {
        return (String)this.getContentByLabelText(CHOOSE_WSD_LABEL);
    }

    public String getWebServiceName() {
        return (String)this.getContentByLabelText(REFERENCE_NAME_LABEL);
    }

    protected String getProjectName() {
        return ((AddWsToDescriptorWizard)this.getWizard()).getProjectName();
    }

    public void setProjectName(String projectName) {
        this.endpointProjectName = projectName;
    }

    protected void setImplClassName(String implClassName) {
        this.qualifiedImplClassName = implClassName;
    }

    private IStatus wsdNameFieldChanged() {
        String content = (String)this.getContentByLabelText(CHOOSE_WSD_LABEL);
        if (content == null || content.length() < 1) {
            return new StatusInfo(4, WsUiTexts.getString("AbstractNewWsPage.Errors.noWsdSelected"));
        }
        if (!this.checkWsdExists(content)) {
            return new StatusInfo(4, WsUiTexts.getString("AbstractNewWsPage.Errors.enterExistingWsd"));
        }
        if (!this.checkWsdIsBasedOnEndpoint(content)) {
            return new StatusInfo(4, WsUiTexts.getString("AbstractNewWsPage.Errors.wsdNotBasedOnBean"));
        }
        return new StatusInfo(0, "");
    }

    private boolean checkWsdExists(String qualifiedWSDName) {
        return this.getWebServiceDefinition(qualifiedWSDName) != null;
    }

    private boolean checkWsdIsBasedOnEndpoint(String qualifiedWSDName) {
        EndpointReference epRef;
        WebServiceDefinition wsd = this.getWebServiceDefinition(qualifiedWSDName);
        if (wsd != null && (epRef = WebServiceMdoResolver.getViForWsd((WebServiceDefinition)wsd).getEndpointReference()) instanceof EjbEndpointReference) {
            return ((EjbEndpointReference)epRef).getBeanName().equals(this.qualifiedImplClassName);
        }
        return true;
    }

    private WebServiceDefinition getWebServiceDefinition(String qualifiedWSDName) {
        String packageName = null;
        String wsdName = null;
        if (qualifiedWSDName.indexOf(46) > -1) {
            packageName = qualifiedWSDName.substring(0, qualifiedWSDName.lastIndexOf(46));
            wsdName = qualifiedWSDName.substring(qualifiedWSDName.lastIndexOf(46) + 1, qualifiedWSDName.length());
        } else {
            wsdName = qualifiedWSDName;
        }
        return (WebServiceDefinition)WebServiceDefinitionWizard.exists(this.endpointProjectName, packageName, wsdName);
    }

    private IStatus wsdReferenceNameFieldChanged() {
        String content = (String)this.getContentByLabelText(REFERENCE_NAME_LABEL);
        if (content == null || content.length() < 1) {
            return new StatusInfo(4, WsUiTexts.getString("AbstractNewWsPage.Errors.noWsNameEntered"));
        }
        if (!CheckServices.isValidIdentifier(content)) {
            return new StatusInfo(4, WsUiTexts.getString("WsWizardLastPage.Errors.invalidWsName", content));
        }
        if (this.checkWebServiceNameExists(content)) {
            return new StatusInfo(4, WsUiTexts.getString("AbstractNewWsPage.Errors.wsNameExists"));
        }
        return new StatusInfo(0, "");
    }

    private boolean checkWebServiceNameExists(String wsdReferenceName) {
        DeploymentDescriptor dd = null;
        IEditorPart editor = DescriptorEditorUtils.findEditorPartForDescriptor((String)this.getProjectName());
        if (editor != null && editor instanceof EditorItemI) {
            dd = (DeploymentDescriptor)((EditorItemI)editor).getEditingObject();
        }
        if (dd != null) {
            WebService[] services = dd.getWebServices();
            int i = 0;
            while (i < services.length) {
                if (services[i].getInternalName().equals(wsdReferenceName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private WebServiceDefinition handleBrowseWsdsButtonPressed() {
        Object o;
        WsSelectionDialog dialog = new WsSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WsdInfoLabelProvider(16), (ILabelProvider)new WsdInfoLabelProvider(40), "WSD", WSRootManager.getWSRoot((Metamodel)MetamodelManager.getMetamodel((String)this.endpointProjectName)), this.endpointProjectName, this.qualifiedImplClassName);
        dialog.setTitle(WsUiTexts.getString("AbstractNewWsPage.wsdSelectionDialogTitle"));
        dialog.setMessage(WsUiTexts.getString("AbstractNewWsPage.wsdSelectionDialogMessage"));
        if (dialog.open() == 0 && (o = dialog.getFirstResult()) instanceof WsTypeInfo) {
            return ((WsTypeInfo)((Object)o)).getWebServiceDefinition();
        }
        return null;
    }

    protected abstract String getLabel();

    protected abstract boolean checkInput();

    protected abstract void createControls(Composite var1, int var2);
}

