/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.wizards.descriptor;

import com.sap.ide.vi.wizards.generic.CreationFailedException;
import com.sap.ide.vi.wizards.generic.GenericProjectWizard;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.descriptors.DescriptorCreator;
import com.sap.ide.ws.core.services.editors.DescriptorEditorUtils;
import com.sap.ide.ws.core.services.resources.EclipseProjectService;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.wizards.descriptor.pages.NewWsDDPage;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class WsDDWizard
extends GenericProjectWizard
implements INewWizard {
    private static final String META_INF_DIR = "META-INF";
    private static final String WS_DD_FILENAME = "META-INF" + File.separator + "ws-deployment-descriptor.xml";
    private String initialProjectName;

    public WsDDWizard() {
        this.setWindowTitle(WsCoreUiTexts.getString((String)"WebServices.Wizards.title"));
    }

    public WsDDWizard(String initialProjectName) {
        this.initialProjectName = initialProjectName;
        this.setWindowTitle(WsCoreUiTexts.getString((String)"WebServices.Wizards.title"));
    }

    public void addPages() {
        this.projectPage = new NewWsDDPage();
        this.projectPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.projectPage);
        if (this.getSelenaSelection() != null) {
            this.projectPage.init(this.getSelenaSelection());
        } else {
            this.projectPage.init((IStructuredSelection)this.getSelection());
        }
    }

    protected Object exists() {
        return null;
    }

    protected void delete(Object existingObject) {
    }

    public String getProjectName() {
        return this.projectPage.getProjectFromProjectSourceFolderField();
    }

    public static boolean checkDescriptorExistsForProject(String projectName) {
        return EclipseProjectService.checkFileExistsInProject((String)projectName, (String)WS_DD_FILENAME);
    }

    protected Object createNewDO(IProgressMonitor monitor) throws CreationFailedException {
        return DescriptorCreator.createDescriptor((String)this.getProjectName());
    }

    protected void startEditor(Object[] args) {
        DescriptorEditorUtils.start((IFile)DescriptorManager.getDescriptorFileByProjectName((String)((String)args[0])), (String)"com.sap.ide.ws.editors.descriptor.WsDDEditor");
    }
}

