/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.ui.dialogs.uddi;

import com.sap.ide.ws.core.ui.preferences.WebServicePreferences;
import com.sap.ide.ws.ui.dialogs.uddi.UDDIClientDialog;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IEUDDIClientDialog
extends UDDIClientDialog {
    private Shell parentShell;
    private String url;
    static final int Navigate = 104;
    static final int eOnStatusTextChange = 102;
    protected static final String UDDI_ACTION = "action";
    protected static final String UDDI_ACTION_PUBLISH_TMODEL = "TModel";
    protected static final String UDDI_ACTION_REQUEST_TMODEL_KEY = "getTModel";
    protected static final String UDDI_ACTION_REMOVE_TMODEL_KEY = "removeTModel";
    protected static final String UDDI_ACTION_SEARCH_REGISTRY = "search";
    protected static final String UDDI_RESPONSE_DONE = "DONE";
    protected static final String WSD_ID = "WSDID";
    protected static final String OVERVIEW_URL = "overviewURL";
    protected static final String LANGUAGE = "language";
    protected static final String LANGUAGE_EN = "en";
    protected static final String TMODEL_KEY = "tModelKey";
    public static final String UDDI_KEY_PREFIX = "UDDI_KEY: ";
    public static final String WSDL_URL_PREFIX = "WSDL_URL: ";
    public static final String INQUIRY_URL_PREFIX = "INQUIRY_URL: ";
    public static final String PUBLISH_URL_PREFIX = "PUBLISH_URL: ";
    private static final String DISABLE_OK = "DISABLE_OK";
    private Hashtable returnValue;
    private String errorMessage;

    public IEUDDIClientDialog(Shell parentShell) {
        super(parentShell);
    }

    public Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        this.getShell().setText("SAP UDDI Client Browser");
        OleFrame frame = new OleFrame(parent, 0);
        OleControlSite site = new OleControlSite((Composite)frame, 0, "Shell.Explorer.1");
        site.addEventListener(102, new OleListener(){

            public void handleEvent(OleEvent e) {
                IEUDDIClientDialog.super.getButton(0).setEnabled(IEUDDIClientDialog.this.returnValue.size() > 0);
                if (e.arguments[0] != null) {
                    String statusBarText = e.arguments[0].getString();
                    if (statusBarText != null && statusBarText.startsWith(IEUDDIClientDialog.UDDI_KEY_PREFIX)) {
                        IEUDDIClientDialog.this.returnValue.put(IEUDDIClientDialog.UDDI_KEY_PREFIX, statusBarText.substring(IEUDDIClientDialog.UDDI_KEY_PREFIX.length()));
                        IEUDDIClientDialog.super.getButton(0).setEnabled(true);
                        IEUDDIClientDialog.super.getButton(1).setEnabled(false);
                    } else if (statusBarText != null && statusBarText.startsWith(IEUDDIClientDialog.WSDL_URL_PREFIX)) {
                        IEUDDIClientDialog.this.returnValue.put(IEUDDIClientDialog.WSDL_URL_PREFIX, statusBarText.substring(IEUDDIClientDialog.WSDL_URL_PREFIX.length()));
                        IEUDDIClientDialog.super.getButton(0).setEnabled(true);
                    } else if (statusBarText != null && statusBarText.startsWith(IEUDDIClientDialog.DISABLE_OK)) {
                        IEUDDIClientDialog.this.returnValue = new Hashtable();
                        IEUDDIClientDialog.super.getButton(0).setEnabled(false);
                    } else if (statusBarText != null && statusBarText.startsWith(IEUDDIClientDialog.INQUIRY_URL_PREFIX)) {
                        IEUDDIClientDialog.this.returnValue.put(IEUDDIClientDialog.INQUIRY_URL_PREFIX, statusBarText.substring(IEUDDIClientDialog.INQUIRY_URL_PREFIX.length()));
                    } else if (statusBarText != null && statusBarText.startsWith(IEUDDIClientDialog.PUBLISH_URL_PREFIX)) {
                        IEUDDIClientDialog.this.returnValue.put(IEUDDIClientDialog.PUBLISH_URL_PREFIX, statusBarText.substring(IEUDDIClientDialog.PUBLISH_URL_PREFIX.length()));
                    }
                }
            }
        });
        site.doVerb(-5);
        OleAutomation auto = new OleAutomation((OleClientSite)site);
        auto.invoke(104, new Variant[]{new Variant(this.url)});
        frame.setBounds(10, 10, 800, 400);
        frame.pack();
        return frame;
    }

    public String getUrl() {
        return this.url;
    }

    public String getError() {
        return null;
    }

    public Hashtable publishTModel(String guid) {
        this.url = this.assembleTmodelPublicationUrl(guid);
        return this.startDialog();
    }

    public String browseUDDIDirectory() {
        this.url = this.assembleRegistrySearchUrl();
        Hashtable result = this.startDialog();
        if (result != null) {
            return (String)result.get(WSDL_URL_PREFIX);
        }
        return null;
    }

    public void updatePublication(String tModelKey, String guid) {
        this.url = this.assembleUpdateTmodelRequestUrl(tModelKey, guid);
        this.open();
    }

    private Hashtable startDialog() {
        this.returnValue = new Hashtable();
        int dialogRespone = this.open();
        if (dialogRespone == 101) {
            MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), "Error", null, "There is no UDDI Client Tool URL set in the preferences", 1, new String[]{"Ok"}, 0);
            dlg.open();
        } else if (dialogRespone == 1) {
            return null;
        }
        return this.returnValue;
    }

    private String createOverViewUrl(String wsdGuid) {
        String clientStr = WebServicePreferences.getUDDIClientURL();
        clientStr = clientStr.substring(0, clientStr.indexOf("uddiclient"));
        return clientStr + "wsd2wsdl?wsd=" + wsdGuid;
    }

    private String assembleUpdateTmodelRequestUrl(String tModelKey, String guid) {
        String overviewUrl = this.createOverViewUrl(guid);
        String toolUrl = WebServicePreferences.getUDDIClientURL();
        if (toolUrl != null && toolUrl.length() > 0) {
            return WebServicePreferences.getUDDIClientURL() + "?" + UDDI_ACTION + "=" + UDDI_ACTION_PUBLISH_TMODEL + "&" + WSD_ID + "=" + guid + "&" + TMODEL_KEY + "=" + tModelKey + "&" + OVERVIEW_URL + "=" + overviewUrl + "&" + LANGUAGE + "=" + LANGUAGE_EN;
        }
        return null;
    }

    private String assembleTmodelPublicationUrl(String guid) {
        String overviewUrl = this.createOverViewUrl(guid);
        String toolUrl = WebServicePreferences.getUDDIClientURL();
        if (toolUrl != null && toolUrl.length() > 0) {
            return WebServicePreferences.getUDDIClientURL() + "?" + UDDI_ACTION + "=" + UDDI_ACTION_PUBLISH_TMODEL + "&" + WSD_ID + "=" + guid + "&" + OVERVIEW_URL + "=" + overviewUrl + "&" + LANGUAGE + "=" + LANGUAGE_EN;
        }
        return null;
    }

    private String assembleRegistrySearchUrl() {
        return WebServicePreferences.getUDDIClientURL() + "?" + UDDI_ACTION + "=" + UDDI_ACTION_SEARCH_REGISTRY + "&" + LANGUAGE + "=" + LANGUAGE_EN;
    }
}

