/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.ui.dialogs;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.vi.EndpointReference;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.WSDRoot;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.metamodel.ws.plugin.WSRootManager;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.core.typeinfo.AbstractTypeInfo;
import com.sap.ide.ws.elements.WebServiceElementManager;
import com.sap.ide.ws.ui.dialogs.typeinfo.WsReferenceTypeInfo;
import com.sap.ide.ws.ui.dialogs.typeinfo.WsTypeInfo;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.WebService;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class WsSelectionDialog
extends TwoPaneElementSelector {
    private WSDRoot wsRoot;
    private DeploymentDescriptor descriptor;
    private String projectName;
    private String implClassName;
    static /* synthetic */ Class class$com$sap$ide$ws$ui$dialogs$WsSelectionDialog;

    public WsSelectionDialog(Shell parentShell, ILabelProvider elementRenderer, ILabelProvider qualifiedRenderer, String upperListLabel, WSDRoot wsRoot) {
        this(parentShell, elementRenderer, qualifiedRenderer, upperListLabel);
        this.wsRoot = wsRoot;
    }

    public WsSelectionDialog(Shell parentShell, ILabelProvider elementRenderer, ILabelProvider qualifiedRenderer, String upperListLabel, WSDRoot wsRoot, String projectName, String implClassName) {
        this(parentShell, elementRenderer, qualifiedRenderer, upperListLabel, wsRoot);
        this.projectName = projectName;
        this.implClassName = implClassName;
    }

    public WsSelectionDialog(Shell parentShell, ILabelProvider elementRenderer, ILabelProvider qualifiedRenderer, String upperListLabel, String projectName, DeploymentDescriptor descriptor) {
        this(parentShell, elementRenderer, qualifiedRenderer, upperListLabel);
        this.projectName = projectName;
        this.descriptor = descriptor;
    }

    private WsSelectionDialog(Shell parentShell, ILabelProvider elementRenderer, ILabelProvider qualifiedRenderer, String upperListLabel) {
        super(parentShell, elementRenderer, qualifiedRenderer);
        this.setUpperListLabel(upperListLabel);
        this.setLowerListLabel(WsCoreUiTexts.getString((String)"WsCore.Labels.General.packages"));
    }

    private WebServiceDefinition[] getWsdListForAssemblyProject() {
        if (this.descriptor != null) {
            return WebServiceElementManager.getReferencesForProject(this.projectName, this.descriptor);
        }
        return null;
    }

    private WebService[] getWsListForAssemblyProject() {
        WebService[] services = this.descriptor.getWebServices();
        return services;
    }

    private WebServiceDefinition[] getImplClassFilteredWsListForProject(WSDRoot root, String qualifiedImplClassName) {
        ArrayList<WebServiceDefinition> list = new ArrayList<WebServiceDefinition>();
        WebServiceDefinition[] wsds = new WebServiceDefinition[]{};
        try {
            wsds = root.getWebServiceDefinitions();
        }
        catch (LoadException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$ui$dialogs$WsSelectionDialog == null ? (class$com$sap$ide$ws$ui$dialogs$WsSelectionDialog = WsSelectionDialog.class$("com.sap.ide.ws.ui.dialogs.WsSelectionDialog")) : class$com$sap$ide$ws$ui$dialogs$WsSelectionDialog));
        }
        int i = 0;
        while (i < wsds.length) {
            VirtualInterface vi = WebServiceMdoResolver.resolveViReferenceByGuidForProject((String)this.projectName, (String)wsds[i].getVirtualInterfaceReferences()[0].getViGuid());
            if (vi != null && EndpointAnalyser.getEndPointName((EndpointReference)vi.getEndpointReference()).equals(qualifiedImplClassName)) {
                list.add(wsds[i]);
            }
            ++i;
        }
        return list.toArray(new WebServiceDefinition[list.size()]);
    }

    public int open() {
        ArrayList<AbstractTypeInfo> typeList = new ArrayList<AbstractTypeInfo>();
        WebServiceDefinition[] list = null;
        WebService[] webServiceList = null;
        if (this.descriptor != null) {
            if (this.isAssemblyProject()) {
                list = this.getWsdListForAssemblyProject();
            } else {
                this.wsRoot = WSRootManager.getWSRoot((Metamodel)MetamodelManager.getMetamodel((String)this.projectName));
                list = WebServiceMdoResolver.getWsdsForProject((WSDRoot)this.wsRoot);
            }
            webServiceList = this.getWsListForAssemblyProject();
        } else if (this.wsRoot != null && this.implClassName != null) {
            list = this.getImplClassFilteredWsListForProject(this.wsRoot, this.implClassName);
        } else if (this.wsRoot != null) {
            list = WebServiceMdoResolver.getWsdsForProject((WSDRoot)this.wsRoot);
        } else if (!this.isAssemblyProject()) {
            list = WebServiceMdoResolver.getWsdsForWorkspace();
        }
        if (webServiceList == null) {
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    WebServiceDefinition temp = list[i];
                    typeList.add(new WsTypeInfo(temp));
                    ++i;
                }
            }
            WsTypeInfo[] typeRefs = typeList.toArray(new WsTypeInfo[typeList.size()]);
            this.setElements((Object[])typeRefs);
        } else {
            if (list != null) {
                int i = 0;
                while (i < webServiceList.length) {
                    String serviceGuid = webServiceList[i].getGUID();
                    int j = 0;
                    while (j < list.length) {
                        if (list[j].getGuid().equals(serviceGuid)) {
                            typeList.add(new WsReferenceTypeInfo(list[j], webServiceList[i].getInternalName()));
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            WsReferenceTypeInfo[] typeRefs = typeList.toArray(new WsReferenceTypeInfo[typeList.size()]);
            this.setElements((Object[])typeRefs);
        }
        return super.open();
    }

    private boolean isAssemblyProject() {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName).hasNature("com.tssap.j2ee.core.ejbjar.ejbJarNature");
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$ui$dialogs$WsSelectionDialog == null ? (class$com$sap$ide$ws$ui$dialogs$WsSelectionDialog = WsSelectionDialog.class$("com.sap.ide.ws.ui.dialogs.WsSelectionDialog")) : class$com$sap$ide$ws$ui$dialogs$WsSelectionDialog));
            return false;
        }
    }

    protected void computeResult() {
        AbstractTypeInfo ref = (AbstractTypeInfo)this.getLowerSelectedElement();
        if (ref == null) {
            return;
        }
        ArrayList<AbstractTypeInfo> result = new ArrayList<AbstractTypeInfo>(1);
        result.add(ref);
        this.setResult(result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

