/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.ui.dialogs;

import com.sap.ide.ws.core.services.content.provider.ProjectProvider;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.ui.dialogs.GenericProjectCtv;
import com.sap.ide.ws.ui.dialogs.ProjectListContentProvider;
import com.sap.ide.ws.ui.dialogs.ProjectListLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.MessageLine;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class GenericProjectSelectionDialog
extends Dialog {
    private MessageLine fStatusLine;
    private IStatus fStatus;
    private GenericProjectCtv ctv;
    private IProject selectedProject;
    private ProjectProvider projectProvider;
    private ILabelProvider labelProvider;
    private IContentProvider contentProvider;

    public GenericProjectSelectionDialog(Shell parentShell, ProjectProvider projectProvider, ILabelProvider labelProvider, IContentProvider contentProvider) {
        super(parentShell);
        this.projectProvider = projectProvider;
        this.labelProvider = labelProvider;
        this.contentProvider = contentProvider;
    }

    public GenericProjectSelectionDialog(Shell parentShell, ProjectProvider projectProvider) {
        this(parentShell, projectProvider, (ILabelProvider)new ProjectListLabelProvider(), (IContentProvider)new ProjectListContentProvider());
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        c.getShell().setText(WsUiTexts.getString("GenericProjectSelectionDialog.title"));
        new Label(c, 0).setText(WsUiTexts.getString("GenericProjectSelectionDialog.Labels.list"));
        this.ctv = new GenericProjectCtv(c, 2048, this.projectProvider, this.labelProvider, this.contentProvider);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 300;
        this.ctv.getTree().setLayoutData((Object)data);
        return c;
    }

    protected void okPressed() {
        this.selectedProject = this.ctv.getProject();
        super.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        this.fStatusLine = new MessageLine(parent);
        this.fStatusLine.setAlignment(16384);
        this.fStatusLine.setLayoutData((Object)new GridData(768));
        this.fStatusLine.setErrorStatus(null);
        this.fStatusLine.setFont(parent.getFont());
        return super.createButtonBar(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (!this.ctv.isProjectAvailable()) {
            this.fStatus = new StatusInfo(4, "No entries available");
            this.fStatusLine.setErrorStatus(this.fStatus);
        } else {
            this.fStatus = new StatusInfo(0, "");
            this.fStatusLine.setErrorStatus(this.fStatus);
        }
        this.getButton(0).setEnabled(this.fStatus.getSeverity() != 4);
    }

    protected Point getInitialSize() {
        return new Point(400, 450);
    }

    public IProject getReferencedProject() {
        return this.selectedProject;
    }
}

