/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.ui.dialogs;

import com.sap.ide.ws.text.WsUiTexts;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DeleteProjectDialog
extends MessageDialog {
    private String projectPath;
    private boolean doDeleteOfContents;

    public DeleteProjectDialog(Shell parentShell, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String projectPath) {
        super(parentShell, WsUiTexts.getString("DeleteProjectDialog.Messages.confirmDeletion"), dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.projectPath = projectPath;
    }

    protected Control createCustomArea(Composite parent) {
        IGridLayoutPane buttonPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
        final Button deleteContentsButton = buttonPane.addRadioButton(WsUiTexts.getString("DeleteProjectDialog.Labels.deleteContents") + " " + this.projectPath);
        deleteContentsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeleteProjectDialog.this.doDeleteOfContents = deleteContentsButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button dontDeleteContentsButton = buttonPane.addRadioButton(WsUiTexts.getString("DeleteProjectDialog.Labels.doNoteDeleteContents"));
        dontDeleteContentsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeleteProjectDialog.this.doDeleteOfContents = false;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        dontDeleteContentsButton.setSelection(true);
        return buttonPane.getComposite();
    }

    public boolean doDeleteContents() {
        return this.doDeleteOfContents;
    }
}

