/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.ui.dialogs;

import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.impl.SessionBean;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class BeanSelectionDialog
extends SelectionDialog {
    private String ejbJarProjectName;

    public BeanSelectionDialog(Shell parentShell, String ejbJarProjectName) {
        super(parentShell);
        this.ejbJarProjectName = ejbJarProjectName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 100;
        data.widthHint = 250;
        dialogArea.setLayoutData((Object)data);
        dialogArea.getShell().setText("Select Bean");
        Table newTable = new Table(dialogArea, this.getViewerStyle(false));
        final TableViewer listViewer = new TableViewer(newTable);
        listViewer.setContentProvider((IContentProvider)new BeanListViewerContentProvider());
        listViewer.setLabelProvider((IBaseLabelProvider)new BeanListViewerLabelProvider());
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(((IStructuredSelection)listViewer.getSelection()).getFirstElement());
                BeanSelectionDialog.super.setResult(list);
            }
        });
        listViewer.setInput((Object)"");
        return dialogArea;
    }

    private int getViewerStyle(boolean pEnableMultipleSelection) {
        int viewerStyle = 68352;
        viewerStyle = pEnableMultipleSelection ? (viewerStyle |= 2) : (viewerStyle |= 4);
        return viewerStyle;
    }

    public static Object[] getBeansForProject(String projectName) {
        IEjbModule assemblyProject;
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (projectName != null && (assemblyProject = J2eeProjectManager.getEjbModule((String)projectName)) != null) {
            IEnterpriseJavaBean[] beans = assemblyProject.getReferencedEjbs();
            int i = 0;
            while (i < beans.length) {
                if (beans[i] instanceof SessionBean) {
                    list.add(beans[i].getSelenaEntity());
                }
                ++i;
            }
        }
        return list.toArray();
    }

    private class BeanListViewerContentProvider
    implements IStructuredContentProvider {
        private BeanListViewerContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return BeanSelectionDialog.getBeansForProject(BeanSelectionDialog.this.ejbJarProjectName);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class BeanListViewerLabelProvider
    extends LabelProvider {
        private BeanListViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Entity) {
                return ((Entity)element).getPropertyValue("$name");
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof Entity && EjbJarModelMetaInfo.isEjb((UniqueName)((Entity)element).getUniqueName())) {
                return UIPlugin.getDefault().getImageRegistry().get("sessionBean");
            }
            return super.getImage(element);
        }
    }
}

