/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.label;

import com.sap.ide.ws.core.decorators.DecoratedElementI;
import com.sap.ide.ws.core.decorators.WsLabelDecorator;
import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.ide.ws.core.services.selena.SelenaFileAdapter;
import com.sap.ide.ws.core.services.selena.SelenaJavaAdapter;
import com.sap.ide.ws.decorator.DescriptorDecoratorLabelProvider;
import com.sap.ide.ws.decorator.WsdDecoratorFlagProvider;
import com.sap.ide.ws.decorator.WsdStructureDecoratorFlagProvider;
import com.tssap.j2ee.core.providers.vi.ui.WsUIPlugin;
import com.tssap.j2ee.core.providers.ws.WsConfigModelInfo;
import com.tssap.j2ee.core.providers.ws.WsModelMetaInfo;
import com.tssap.j2ee.core.providers.ws.WsdModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.LpModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.LptModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.PrxClassesModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.PrxModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.SeiModelMetaInfo;
import com.tssap.j2ee.core.providers.wsproxy.WsdlModelMetaInfo;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.view.GenericJ2eeLabelProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class WsLabelProvider
extends GenericJ2eeLabelProvider {
    public static final String WS_DEPLOYMENT_DESCRIPTOR_NAME = "Web Service Configurations";
    protected ImageRegistry imageRegistry = UIPlugin.getDefault().getImageRegistry();

    public Image getImage(Object element) {
        if (element instanceof Element) {
            if (this.isWebServiceObject(((Element)element).getUniqueName())) {
                return WsLabelDecorator.getInstance().decorateImage(WsLabelProvider.getWebServiceImage((Element)element), (Object)this.getDecoratorFlagProvider((Element)element));
            }
            if (SelenaFileAdapter.isEarFile((Element)((Element)element))) {
                return WsLabelDecorator.getInstance().decorateImage(UIPlugin.getDefault().getImageRegistry().get("ear"), (Object)SelenaJavaAdapter.getProject((Element)((Element)element)));
            }
            if (SelenaFileAdapter.isClientAPIJarFile((Element)((Element)element))) {
                return WsLabelDecorator.getInstance().decorateImage(UIPlugin.getDefault().getImageRegistry().get("Archives"), (Object)SelenaJavaAdapter.getProject((Element)((Element)element)));
            }
        }
        return null;
    }

    public DecoratedElementI getDecoratorFlagProvider(Element element) {
        if (WsdModelMetaInfo.isWsd((UniqueName)element.getUniqueName())) {
            return new WsdDecoratorFlagProvider(element);
        }
        if (WsdModelMetaInfo.isWsdStructureNode((UniqueName)element.getUniqueName())) {
            return new WsdStructureDecoratorFlagProvider(element);
        }
        if (WsModelMetaInfo.isWsdRefList((UniqueName)element.getUniqueName())) {
            return new DescriptorDecoratorLabelProvider(element.getModel().getUniqueName().getName(), "/META-INF/ws-deployment-descriptor.xml", "com.sap.ide.ws.checkMarker");
        }
        return null;
    }

    private boolean isWebServiceObject(UniqueName uniqueName) {
        return WsdModelMetaInfo.isWsd((UniqueName)uniqueName) || WsdModelMetaInfo.isWsdStructureNode((UniqueName)uniqueName) || WsModelMetaInfo.isWsdReference((UniqueName)uniqueName) || WsModelMetaInfo.isWsdRefList((UniqueName)uniqueName) || WsConfigModelInfo.isWsConfiguration((UniqueName)uniqueName) || WebServiceFilterFactory.isProxyOrProxyDCProject((UniqueName)uniqueName) || PrxModelMetaInfo.isProxy((UniqueName)uniqueName) || PrxClassesModelMetaInfo.isPrxClassStructureNode((UniqueName)uniqueName) || PrxClassesModelMetaInfo.isPrxClass((UniqueName)uniqueName) || PrxClassesModelMetaInfo.isPrxClassInterface((UniqueName)uniqueName) || SeiModelMetaInfo.isSeiStructureNode((UniqueName)uniqueName) || SeiModelMetaInfo.isSeiClass((UniqueName)uniqueName) || SeiModelMetaInfo.isSeiInterface((UniqueName)uniqueName) || WsdlModelMetaInfo.isWsdlStructureNode((UniqueName)uniqueName) || WsdlModelMetaInfo.isWsdl((UniqueName)uniqueName) || LpModelMetaInfo.isLp((UniqueName)uniqueName) || LpModelMetaInfo.isLpStructureNode((UniqueName)uniqueName) || LptModelMetaInfo.isLpt((UniqueName)uniqueName) || LptModelMetaInfo.isLptStructureNode((UniqueName)uniqueName);
    }

    public Image getGenericParentImage(Object element) {
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof Element && this.isWebServiceObject(((Element)element).getUniqueName())) {
            return WsLabelProvider.getWebServiceText((Element)element);
        }
        return null;
    }

    public String getGenericParentText(Object element) {
        return super.getText(element);
    }

    public static String getWebServiceText(Element element) {
        if (ProxyMetaInfo.isProxyUniqueName((UniqueName)element.getUniqueName()) && WsModelMetaInfo.isWsdReference((UniqueName)element.getUniqueName())) {
            return element.getUniqueName().getParameter(element.getUniqueName().getParametersCount() - 1);
        }
        if (WsModelMetaInfo.isWsdRefList((UniqueName)element.getUniqueName())) {
            return WS_DEPLOYMENT_DESCRIPTOR_NAME;
        }
        if (PrxModelMetaInfo.isProxy((UniqueName)element.getUniqueName())) {
            return element.getUniqueName().getLocation() + "." + element.getUniqueName().getName();
        }
        if (LpModelMetaInfo.isLp((UniqueName)element.getUniqueName())) {
            Property prop = element.getProperty("display_name");
            if (prop != null) {
                return prop.getValue();
            }
            return element.getUniqueName().getName();
        }
        if (WsdlModelMetaInfo.isWsdl((UniqueName)element.getUniqueName()) || SeiModelMetaInfo.isSeiClass((UniqueName)element.getUniqueName()) || SeiModelMetaInfo.isSeiInterface((UniqueName)element.getUniqueName()) || PrxClassesModelMetaInfo.isPrxClass((UniqueName)element.getUniqueName()) || PrxClassesModelMetaInfo.isPrxClassInterface((UniqueName)element.getUniqueName())) {
            return element.getUniqueName().getParameter(0);
        }
        return element.getUniqueName().getName();
    }

    public static Image getWebServiceImage(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        if (WsdModelMetaInfo.isWsd((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/webservice_definition/WebServiceDefinition.gif");
        }
        if (WsdModelMetaInfo.isWsdStructureNode((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/webservice_definition/FolderWebServiceDef.gif");
        }
        if (WsModelMetaInfo.isWsdReference((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/webservice/WebService.gif");
        }
        if (WsModelMetaInfo.isWsdRefList((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/webservice/WebServiceDescriptor.gif");
        }
        if (WsConfigModelInfo.isWsConfiguration((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/webservice/WebServiceConfiguration.gif");
        }
        if (WebServiceFilterFactory.isDeployableProxyOrDeployableProxyDCProject((UniqueName)uniqueName)) {
            if (!ResourcesPlugin.getWorkspace().getRoot().getProject(uniqueName.getName()).isOpen()) {
                WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/closed_proxy_project.gif");
            }
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/ProxyProject.gif");
        }
        if (WebServiceFilterFactory.isStandaloneProxyOrStandaloneProxyDCProject((UniqueName)uniqueName)) {
            if (!ResourcesPlugin.getWorkspace().getRoot().getProject(uniqueName.getName()).isOpen()) {
                WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/closed_proxy_project.gif");
            }
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/ProxyProject.gif");
        }
        if (SeiModelMetaInfo.isSeiStructureNode((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/FolderServiceEndpointInterface.gif");
        }
        if (PrxClassesModelMetaInfo.isPrxClassStructureNode((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/FolderProxyClasses.gif");
        }
        if (PrxModelMetaInfo.isProxy((UniqueName)uniqueName)) {
            if (WebServiceFilterFactory.isDeployableProxyOrDeployableProxyDCProject((UniqueName)element.getModel().getUniqueName())) {
                return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/DeployableProxyDef.gif");
            }
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/StandaloneProxyDef.gif");
        }
        if (PrxClassesModelMetaInfo.isPrxClass((UniqueName)uniqueName) || SeiModelMetaInfo.isSeiClass((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/class.gif");
        }
        if (SeiModelMetaInfo.isSeiInterface((UniqueName)uniqueName) || PrxClassesModelMetaInfo.isPrxClassInterface((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/sei.gif");
        }
        if (WsdlModelMetaInfo.isWsdlStructureNode((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/FolderWSDLs.gif");
        }
        if (WsdlModelMetaInfo.isWsdl((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/WSDL.gif");
        }
        if (LpModelMetaInfo.isLpStructureNode((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/FolderLogicalPort.gif");
        }
        if (LpModelMetaInfo.isLp((UniqueName)uniqueName)) {
            if (Boolean.TRUE.toString().equals(element.getProperty("default_port").getValue())) {
                return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/DefaultLogicalPort.gif");
            }
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/LogicalPort.gif");
        }
        if (LptModelMetaInfo.isLptStructureNode((UniqueName)uniqueName)) {
            return WsUIPlugin.getDefault().getImageRegistry().get("web_services/proxy_project/lpt_structure.gif");
        }
        return null;
    }
}

