/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.wsd.ui;

import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.ws.editors.wsd.WSDEditor;
import com.sap.ide.ws.soapapp.FeatureDt;
import com.sap.ide.ws.soapapp.PropertyDt;
import com.tssap.j2ee.core.providers.vi.ui.WsUIPlugin;
import com.tssap.util.ui.viewer.tree.SapAbstractTreeLabelProvider;
import com.tssap.util.ui.viewer.tree.SapTreeLabelProvider;
import javax.swing.tree.DefaultMutableTreeNode;
import org.eclipse.swt.graphics.Image;

public class WSDOutlineLabelProvider
extends SapTreeLabelProvider {
    private static final Image SELECTED_FEATURE_ICON = WsUIPlugin.getImage((String)"web_services/webservice_definition/FeatureSelected.gif");
    private static final Image DESELECTED_FEATURE_ICON = WsUIPlugin.getImage((String)"web_services/webservice_definition/Feature.gif");
    private static final Image SELECTED_PROPERTY_ICON = WsUIPlugin.getImage((String)"web_services/webservice_definition/PropertySelected.gif");
    private static final Image DESELECTED_PROPERTY_ICON = WsUIPlugin.getImage((String)"web_services/webservice_definition/Property.gif");
    private static final Image WSD_ICON = WsUIPlugin.getImage((String)"web_services/webservice_definition/WebServiceDefinition.gif");
    private WSDEditor editor;

    public WSDOutlineLabelProvider(WSDEditor editor) {
        this.editor = editor;
    }

    public String getText(Object obj) {
        if (obj instanceof DefaultMutableTreeNode) {
            if (((DefaultMutableTreeNode)obj).getUserObject() instanceof WebServiceDefinition) {
                return this.getQualifiedWsdName((WebServiceDefinition)((DefaultMutableTreeNode)obj).getUserObject());
            }
            if (((DefaultMutableTreeNode)obj).getUserObject() instanceof FeatureDt) {
                return ((FeatureDt)((DefaultMutableTreeNode)obj).getUserObject()).getDisplayName();
            }
        }
        return super.getText(obj);
    }

    private String getQualifiedWsdName(WebServiceDefinition wsDefinition) {
        String packageText = wsDefinition.getPackage();
        String name = wsDefinition.getName();
        if (packageText == null || packageText.length() < 1) {
            return name;
        }
        return packageText + "." + name;
    }

    public Image getImage(Object obj) {
        DefaultMutableTreeNode treeNode = null;
        if (obj instanceof DefaultMutableTreeNode) {
            treeNode = (DefaultMutableTreeNode)obj;
            if (treeNode.getUserObject() instanceof FeatureDt) {
                if (this.editor.checkFeatureSelected(((FeatureDt)treeNode.getUserObject()).getName())) {
                    return SELECTED_FEATURE_ICON;
                }
                return DESELECTED_FEATURE_ICON;
            }
            if (treeNode.getUserObject() instanceof WebServiceDefinition) {
                return WSD_ICON;
            }
            if (treeNode.getUserObject() instanceof PropertyDt) {
                if (this.editor.checkPropertySelected(((FeatureDt)((DefaultMutableTreeNode)treeNode.getParent()).getUserObject()).getName(), ((PropertyDt)treeNode.getUserObject()).getName())) {
                    return SELECTED_PROPERTY_ICON;
                }
                return DESELECTED_PROPERTY_ICON;
            }
        }
        if (treeNode.getChildCount() > 0) {
            return SapAbstractTreeLabelProvider.getIcon((int)1);
        }
        return SapAbstractTreeLabelProvider.getIcon((int)2);
    }
}

