/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.wsd.ui;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.ws.Feature;
import com.sap.ide.metamodel.ws.Property;
import com.sap.ide.ws.core.editors.GenericMultiPageEditorPage;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.MdoReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.editors.wsd.WSDEditor;
import com.sap.ide.ws.editors.wsd.pages.FeaturePage;
import com.sap.ide.ws.editors.wsd.pages.WsdEditorPage;
import com.sap.ide.ws.editors.wsd.ui.UIUtil;
import com.sap.ide.ws.soapapp.Enum;
import com.sap.ide.ws.soapapp.EnumValue;
import com.sap.ide.ws.soapapp.FeatureDt;
import com.sap.ide.ws.soapapp.PropertyDt;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.ui.layers.LayeredComposite;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PropertyPane
extends LayeredComposite {
    private Hashtable propertySelectedButtons = new Hashtable();
    private Hashtable propertyValueButtons = new Hashtable();
    private ITabbedPane mainTabPane;

    public PropertyPane(Object[] objects, FeatureDt feature, FeaturePage parentEditorPage) {
        super(objects, feature, parentEditorPage);
        parentEditorPage.addFeatureSelectedListener(this);
    }

    protected Control getControl(Composite parent) {
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        return this.createControls(parent, this.getLayerObjects());
    }

    private Control createControls(Composite parent, Object[] objects) {
        this.mainTabPane = PaneFactory.createTabbedPane((Composite)parent);
        this.mainTabPane.setLayoutData((Object)new GridData(1808));
        if (objects instanceof PropertyDt[]) {
            int i = 0;
            while (i < objects.length) {
                if (((PropertyDt)objects[i]).isVisible()) {
                    final PropertyDt currentProperty = (PropertyDt)objects[i];
                    IGridLayoutPane propPane = this.mainTabPane.addGridLayoutPaneAsTab(((PropertyDt)objects[i]).getName(), 1);
                    propPane.setLayoutData((Object)new GridData(1808));
                    IGridLayoutPane descriptionPane = propPane.addGridLayoutPane(2);
                    descriptionPane.setLayoutData((Object)new GridData(768));
                    UIUtil.createFillLabel(descriptionPane, 2, 1);
                    descriptionPane.addTextLabel(WsCoreUiTexts.getString((String)"WsCore.Labels.General.description"), descriptionPane.createGridLayoutData(1, 4, false, false, 1, 1));
                    Text description = descriptionPane.addTextField(((PropertyDt)objects[i]).getDescription(), descriptionPane.createGridLayoutData(4, 4, true, false, 1, 1));
                    description.setEnabled(false);
                    UIUtil.createFillLabel(descriptionPane, 2, 1);
                    final Button propSelectedButton = descriptionPane.addCheckBox(WsUiTexts.getString("PropertyPane.Labels.selectProperty"));
                    Feature feature = ((WsdEditorPage)((Object)this.getContainer())).getWebServiceDefinition().getSoapApplications()[0].getFeature(((FeatureDt)this.getMyLayerSelector()).getName());
                    propSelectedButton.setData(objects[i]);
                    if (((PropertyDt)objects[i]).isRequired()) {
                        propSelectedButton.setSelection(true);
                        propSelectedButton.setEnabled(false);
                    } else {
                        if (feature != null) {
                            propSelectedButton.setSelection(feature.getProperty(currentProperty.getName()) != null);
                        } else {
                            propSelectedButton.setSelection(false);
                            propSelectedButton.setEnabled(false);
                        }
                        propSelectedButton.addSelectionListener(new SelectionListener(){
                            static /* synthetic */ Class class$com$sap$ide$ws$editors$wsd$ui$PropertyPane;

                            public void widgetSelected(SelectionEvent e) {
                                if (!((GenericMultiPageEditorPage)PropertyPane.this.getContainer()).isInResetMode()) {
                                    if (!((GenericMultiPageEditorPage)PropertyPane.this.getContainer()).isChangeAllowed((HandleReadOnlyStateI)new MdoReadOnlyStateHandler((MainDevelopmentObject)((WsdEditorPage)((Object)PropertyPane.this.getContainer())).getWebServiceDefinition()), new ResetPageStateI(this){
                                        private final /* synthetic */ 1 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        public void handleReset() {
                                            1.access$000(this.this$1).setSelection(!1.access$000(this.this$1).getSelection());
                                        }
                                    })) {
                                        return;
                                    }
                                    Feature myFeature = ((WsdEditorPage)((Object)PropertyPane.this.getContainer())).getWebServiceDefinition().getSoapApplications()[0].getFeature(((FeatureDt)PropertyPane.super.getMyLayerSelector()).getName());
                                    if (propSelectedButton.getSelection()) {
                                        try {
                                            Property p = myFeature.createProperty(currentProperty.getName());
                                            p.setValue(currentProperty.getDefaultValue());
                                        }
                                        catch (CreateException ce) {
                                            WebServiceCorePlugin.logError((Throwable)ce, (Class)(class$com$sap$ide$ws$editors$wsd$ui$PropertyPane == null ? (class$com$sap$ide$ws$editors$wsd$ui$PropertyPane = 1.class$("com.sap.ide.ws.editors.wsd.ui.PropertyPane")) : class$com$sap$ide$ws$editors$wsd$ui$PropertyPane));
                                        }
                                    } else {
                                        Property p = myFeature.getProperty(currentProperty.getName());
                                        if (p != null) {
                                            try {
                                                p.delete();
                                            }
                                            catch (DeleteException de) {
                                                WebServiceCorePlugin.logError((Throwable)de, (Class)(class$com$sap$ide$ws$editors$wsd$ui$PropertyPane == null ? (class$com$sap$ide$ws$editors$wsd$ui$PropertyPane = 1.class$("com.sap.ide.ws.editors.wsd.ui.PropertyPane")) : class$com$sap$ide$ws$editors$wsd$ui$PropertyPane));
                                            }
                                        }
                                    }
                                    PropertyPane.this.getContainer().getLayerContainerParent().notifyOfChange();
                                    PropertyPane.this.enablePropertyValueButtons(propSelectedButton.getData());
                                }
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }

                            static /* synthetic */ Button access$000(1 x0) {
                                return x0.propSelectedButton;
                            }

                            static /* synthetic */ Class class$(String x0) {
                                try {
                                    return Class.forName(x0);
                                }
                                catch (ClassNotFoundException x1) {
                                    throw new NoClassDefFoundError(x1.getMessage());
                                }
                            }
                        });
                    }
                    this.propertySelectedButtons.put(objects[i], propSelectedButton);
                    this.addPropertyValueButtons(propPane, currentProperty);
                }
                ++i;
            }
        }
        return this.mainTabPane.getComposite();
    }

    private void addPropertyValueButtons(IGridLayoutPane parentPane, final PropertyDt currentProperty) {
        IGridLayoutPane valuePane = parentPane.addGridLayoutPane(WsUiTexts.getString("PropertyPane.Labels.values"), 2);
        valuePane.setLayoutData((Object)new GridData(1808));
        Enum values = currentProperty.getPossibleValues();
        int k = 0;
        Vector<Button> propValButtons = new Vector<Button>();
        while (values.hasMoreElements()) {
            EnumValue val = values.nextElement();
            final Button b = valuePane.addRadioButton(val.getDescription(), valuePane.createGridLayoutData(4, 4, true, false, 1, 1));
            b.setData((Object)val.getValue());
            b.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (b.getSelection() && !((GenericMultiPageEditorPage)PropertyPane.this.getContainer()).isInResetMode()) {
                        if (!((GenericMultiPageEditorPage)PropertyPane.this.getContainer()).isChangeAllowed((HandleReadOnlyStateI)new MdoReadOnlyStateHandler((MainDevelopmentObject)((WsdEditorPage)((Object)PropertyPane.this.getContainer())).getWebServiceDefinition()), new ResetPageStateI(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void handleReset() {
                                Object propValue = null;
                                Feature feature = ((WsdEditorPage)((Object)3.access$300(this.this$1).getContainer())).getWebServiceDefinition().getSoapApplications()[0].getFeature(((FeatureDt)PropertyPane.access$401(3.access$300(this.this$1))).getName());
                                if (feature != null && feature.getProperty(3.access$500(this.this$1).getName()) != null) {
                                    PropertyPane.access$200(3.access$300(this.this$1), 3.access$500(this.this$1));
                                }
                            }
                        })) {
                            return;
                        }
                        PropertyPane.this.propertyValueChanged(currentProperty, (String)b.getData());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                static /* synthetic */ PropertyPane access$300(3 x0) {
                    return x0.PropertyPane.this;
                }

                static /* synthetic */ PropertyDt access$500(3 x0) {
                    return x0.currentProperty;
                }
            });
            b.setEnabled(false);
            if (k == 0) {
                valuePane.addTextLabel(WsUiTexts.getString("PropertyPane.Labels.defaultValue") + " " + currentProperty.getDefaultValue(), valuePane.createGridLayoutData(1, 1, true, false, 1, 1));
            } else {
                UIUtil.createFillLabel(valuePane, 1, 1);
            }
            ++k;
            propValButtons.add(b);
        }
        if (k == 0) {
            if (!currentProperty.isRequired()) {
                valuePane.addTextLabel(WsUiTexts.getString("PropertyPane.Labels.propertyValue"), valuePane.createGridLayoutData(1, 1, false, false, 2, 1));
                final Text editableTextBox = valuePane.addTextField(false, valuePane.createGridLayoutData(4, 4, true, false, 1, 1));
                if (currentProperty.getDefaultValue() != null) {
                    editableTextBox.setText(currentProperty.getDefaultValue());
                }
                editableTextBox.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (!((GenericMultiPageEditorPage)PropertyPane.this.getContainer()).isInResetMode()) {
                            if (!((GenericMultiPageEditorPage)PropertyPane.this.getContainer()).isChangeAllowed((HandleReadOnlyStateI)new MdoReadOnlyStateHandler((MainDevelopmentObject)((WsdEditorPage)((Object)PropertyPane.this.getContainer())).getWebServiceDefinition()), new ResetPageStateI(this){
                                private final /* synthetic */ 5 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void handleReset() {
                                    Feature feature = ((WsdEditorPage)((Object)5.access$700(this.this$1).getContainer())).getWebServiceDefinition().getSoapApplications()[0].getFeature(((FeatureDt)PropertyPane.access$801(5.access$700(this.this$1))).getName());
                                    if (feature != null && feature.getProperty(5.access$900(this.this$1).getName()) != null) {
                                        5.access$1000(this.this$1).setText(feature.getProperty(5.access$900(this.this$1).getName()).getValue());
                                    }
                                }
                            })) {
                                return;
                            }
                            PropertyPane.this.propertyValueChanged(currentProperty, editableTextBox.getText());
                        }
                    }

                    static /* synthetic */ PropertyPane access$700(5 x0) {
                        return x0.PropertyPane.this;
                    }

                    static /* synthetic */ PropertyDt access$900(5 x0) {
                        return x0.currentProperty;
                    }

                    static /* synthetic */ Text access$1000(5 x0) {
                        return x0.editableTextBox;
                    }
                });
            }
            valuePane.addTextLabel(WsUiTexts.getString("PropertyPane.Labels.enterValue") + " " + currentProperty.getDefaultValue(), valuePane.createGridLayoutData(2, 2, true, false, 1, 1));
        }
        this.propertyValueButtons.put(currentProperty, propValButtons);
        this.enablePropertyValueButtons(currentProperty);
    }

    public void selectPropertyTab(String tabName) {
        TabItem[] tabs = ((TabFolder)this.mainTabPane.getComposite()).getItems();
        int j = 0;
        while (j < tabs.length) {
            if (tabs[j].getText().equals(tabName)) {
                ((TabFolder)this.mainTabPane.getComposite()).setSelection(j);
                break;
            }
            ++j;
        }
    }

    private void propertyValueChanged(PropertyDt currentProperty, String newValue) {
        Feature feature = ((WsdEditorPage)((Object)this.getContainer())).getWebServiceDefinition().getSoapApplications()[0].getFeature(((FeatureDt)this.getMyLayerSelector()).getName());
        if (feature != null && feature.getProperty(currentProperty.getName()) != null) {
            feature.getProperty(currentProperty.getName()).setValue(newValue);
        }
        ((WsdEditorPage)((Object)this.getContainer())).getParentEditor().notifyOfChange();
    }

    private void enablePropertyValueButtons(Object property) {
        Vector v = (Vector)this.propertyValueButtons.get(property);
        Feature feature = ((WsdEditorPage)((Object)this.getContainer())).getWebServiceDefinition().getSoapApplications()[0].getFeature(((FeatureDt)this.getMyLayerSelector()).getName());
        if (feature != null && feature.getProperty(((PropertyDt)property).getName()) != null) {
            int i = 0;
            while (i < v.size()) {
                if (((Button)v.elementAt(i)).getData().equals(feature.getProperty(((PropertyDt)property).getName()).getValue())) {
                    ((Button)v.elementAt(i)).setSelection(true);
                } else {
                    ((Button)v.elementAt(i)).setSelection(false);
                }
                ((Button)v.elementAt(i)).setEnabled(true);
                ++i;
            }
        } else {
            int i = 0;
            while (i < v.size()) {
                if (((Button)v.elementAt(i)).getData().equals(((PropertyDt)property).getDefaultValue())) {
                    ((Button)v.elementAt(i)).setSelection(true);
                } else {
                    ((Button)v.elementAt(i)).setSelection(false);
                }
                ((Button)v.elementAt(i)).setEnabled(false);
                ++i;
            }
        }
    }

    public void updateLayer(Object layerSelector) {
        if (this.getMyLayerSelector() == layerSelector) {
            Enumeration keys = this.propertySelectedButtons.keys();
            while (keys.hasMoreElements()) {
                PropertyDt property = (PropertyDt)keys.nextElement();
                Button b = (Button)this.propertySelectedButtons.get(property);
                b.setEnabled(((WSDEditor)this.getContainer().getLayerContainerParent()).checkFeatureSelected(((FeatureDt)layerSelector).getName()) && !property.isRequired());
                b.setSelection(property.isRequired());
                this.enablePropertyValueButtons(property);
            }
        }
    }

    static /* synthetic */ Object access$401(PropertyPane x0) {
        return super.getMyLayerSelector();
    }

    static /* synthetic */ Object access$801(PropertyPane x0) {
        return super.getMyLayerSelector();
    }
}

