/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.wsd.pages;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.ws.UDDITModelPublication;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.MdoReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.upload.UsernamePasswordHandler;
import com.sap.ide.ws.editors.wsd.WSDEditor;
import com.sap.ide.ws.editors.wsd.pages.WsdEditorPage;
import com.sap.ide.ws.editors.wsd.ui.UIUtil;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.ui.dialogs.uddi.UDDIClientDialog;
import com.sap.ide.ws.ui.dialogs.uddi.UDDIClientDialogFactory;
import com.sap.ide.ws.uploadclient.WsdUploadClient;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UDDIPage
extends WsdEditorPage {
    public static final String UDDI_PAGE_TEXT = WsUiTexts.getString("UDDIPage.Labels.uddi");
    private Button publishButton;
    private Button updatePublicationButton;
    private ListViewer tModelKeyViewer;
    private Composite comp;
    static /* synthetic */ Class class$com$sap$ide$ws$editors$wsd$pages$UDDIPage;

    public UDDIPage(Composite parentComposite, WSDEditor parentEditor) {
        super(parentComposite, parentEditor);
    }

    public synchronized boolean checkWsdPublishable() {
        String password;
        String userName;
        try {
            userName = UsernamePasswordHandler.getUsername();
            password = UsernamePasswordHandler.getPassword();
        }
        catch (Exception e) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)WsUiTexts.getString("UDDIPage.Messages.uploadFailed"), (String)WsUiTexts.getString("UDDIPage.Messages.uploadFailedReason"));
            WebServiceCorePlugin.logErrorSimulated((Throwable)e);
            return false;
        }
        WsdUploadClient client = new WsdUploadClient();
        return client.wsdAndViExistsOn((MainDevelopmentObject)this.getWebServiceDefinition(), (MainDevelopmentObject)((WSDEditor)this.getParentEditor()).getVirtualInterface(), userName, password);
    }

    public Composite getControl() {
        int nColumns = 3;
        IGridLayoutPane uddiPane = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)nColumns);
        uddiPane.setLayoutData((Object)new GridData(1808));
        IGridLayoutPane uddiPublicationsPane = uddiPane.addGridLayoutPane(1);
        uddiPublicationsPane.addPlaceholder();
        uddiPublicationsPane.setLayoutData((Object)new GridData(1808));
        uddiPublicationsPane.addTextLabel(WsUiTexts.getString("UDDIPage.Labels.tmodelPublications"), uddiPublicationsPane.createGridLayoutData(4, 4, true, false));
        this.tModelKeyViewer = uddiPublicationsPane.addListViewer(false, uddiPublicationsPane.createGridLayoutData(4, 4, true, true));
        this.tModelKeyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (UDDIPage.this.tModelKeyViewer.getSelection() != null) {
                    UDDIPage.this.updatePublicationButton.setEnabled(true);
                }
            }
        });
        this.setTModelList();
        uddiPublicationsPane.addPlaceholder(3, 1);
        uddiPublicationsPane.addPlaceholder(3, 1);
        uddiPublicationsPane.addPlaceholder(3, 1);
        uddiPublicationsPane.addPlaceholder(3, 1);
        uddiPublicationsPane.addPlaceholder(3, 1);
        uddiPublicationsPane.addPlaceholder(3, 1);
        IGridLayoutPane uddiPublicationButtonsPane = uddiPane.addGridLayoutPane(2);
        uddiPublicationButtonsPane.setLayoutData((Object)new GridData(770));
        uddiPublicationButtonsPane.addPlaceholder();
        UIUtil.createFillLabel(uddiPublicationButtonsPane, 2, 1);
        this.publishButton = uddiPublicationButtonsPane.addPushButton(WsUiTexts.getString("UDDIPage.Labels.publish"), uddiPublicationButtonsPane.createGridLayoutData(4, 1, false, false));
        this.publishButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!UDDIPage.this.isChangeAllowed((HandleReadOnlyStateI)new MdoReadOnlyStateHandler((MainDevelopmentObject)UDDIPage.this.getWebServiceDefinition()), new ResetPageStateI(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleReset() {
                    }
                })) {
                    return;
                }
                UDDIPage.this.initiatePublication();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        UIUtil.createFillLabel(uddiPublicationButtonsPane, 1, 1);
        this.updatePublicationButton = uddiPublicationButtonsPane.addPushButton(WsUiTexts.getString("UDDIPage.Labels.update"), uddiPublicationButtonsPane.createGridLayoutData(4, 1, false, false));
        this.updatePublicationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!UDDIPage.this.isChangeAllowed((HandleReadOnlyStateI)new MdoReadOnlyStateHandler((MainDevelopmentObject)UDDIPage.this.getWebServiceDefinition()), new ResetPageStateI(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleReset() {
                    }
                })) {
                    return;
                }
                UDDIPage.this.initiateUpdate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updatePublicationButton.setEnabled(false);
        return uddiPane.getComposite();
    }

    public boolean initiateUpload() {
        String password;
        String userName;
        try {
            userName = UsernamePasswordHandler.getUsername();
            password = UsernamePasswordHandler.getPassword();
        }
        catch (Exception e) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)WsUiTexts.getString("UDDIPage.Messages.uploadFailed"), (String)WsUiTexts.getString("UDDIPage.Messages.uploadFailedReason"));
            WebServiceCorePlugin.logErrorSimulated((Throwable)e);
            return false;
        }
        String ack = new WsdUploadClient().uploadWsdAndVi((MainDevelopmentObject)this.getWebServiceDefinition(), (MainDevelopmentObject)((WSDEditor)this.getParentEditor()).getVirtualInterface(), userName, password);
        return ack != null && ack.equals("OK");
    }

    private void initiatePublication() {
        if (!this.initiateUpload()) {
            return;
        }
        Hashtable newKey = null;
        UDDIClientDialog dialog = UDDIClientDialogFactory.getOSSpecificUDDIClientDialog(Display.getCurrent().getActiveShell());
        if (dialog != null && (newKey = dialog.publishTModel(this.getWebServiceDefinition().getGuid())) != null && newKey.containsKey("UDDI_KEY: ")) {
            try {
                UDDITModelPublication publication = this.getWebServiceDefinition().createuddiTModelPublication((String)newKey.get("UDDI_KEY: "));
                if (newKey.containsKey("INQUIRY_URL: ")) {
                    publication.setInquiryUrl((String)newKey.get("INQUIRY_URL: "));
                }
                if (newKey.containsKey("INQUIRY_URL: ")) {
                    publication.setPublishUrl((String)newKey.get("PUBLISH_URL: "));
                }
                this.tModelKeyViewer.add((Object)((String)newKey.get("UDDI_KEY: ")));
                this.getParentEditor().notifyOfChange();
            }
            catch (CreateException cex) {
                WebServiceCorePlugin.logError((Throwable)cex, (Class)(class$com$sap$ide$ws$editors$wsd$pages$UDDIPage == null ? (class$com$sap$ide$ws$editors$wsd$pages$UDDIPage = UDDIPage.class$("com.sap.ide.ws.editors.wsd.pages.UDDIPage")) : class$com$sap$ide$ws$editors$wsd$pages$UDDIPage));
            }
        }
    }

    private void initiateUpdate() {
        UDDIClientDialog dialog = UDDIClientDialogFactory.getOSSpecificUDDIClientDialog(Display.getCurrent().getActiveShell());
        if (dialog != null) {
            dialog.updatePublication(((StructuredSelection)this.tModelKeyViewer.getSelection()).getFirstElement().toString(), this.getWebServiceDefinition().getGuid());
        }
    }

    private void setTModelList() {
        UDDITModelPublication[] publications = this.getWebServiceDefinition().getuddiTModelPublications();
        int i = 0;
        while (i < publications.length) {
            this.tModelKeyViewer.add((Object)publications[i].getName());
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

