/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.wsd.pages;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.vi.InterfaceType;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.Feature;
import com.sap.ide.metamodel.ws.Property;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.MdoReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.editors.wsd.FeatureSelected;
import com.sap.ide.ws.editors.wsd.WSDEditor;
import com.sap.ide.ws.editors.wsd.pages.WsdEditorPage;
import com.sap.ide.ws.editors.wsd.ui.FeatureListLabelProvider;
import com.sap.ide.ws.editors.wsd.ui.PropertyPane;
import com.sap.ide.ws.editors.wsd.ui.PropertyPaneLayerContainer;
import com.sap.ide.ws.editors.wsd.ui.UIUtil;
import com.sap.ide.ws.soapapp.FeatureDt;
import com.sap.ide.ws.soapapp.PropertyDt;
import com.sap.ide.ws.soapapp.SOAPApplicationDt;
import com.sap.ide.ws.soapapp.SOAPApplicationFactoryDt;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.ui.GenericListContentProvider;
import com.sap.ide.ws.ui.layers.ILayerParentContainer;
import com.sap.ide.ws.ui.layers.INotifiable;
import com.sap.ide.ws.ui.layers.IUpdateLayer;
import com.sap.ide.ws.ui.layers.LayerContainer;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FeaturePage
extends WsdEditorPage
implements ILayerParentContainer {
    public static final String FEATURE_PAGE_TEXT = WsUiTexts.getString("FeaturePage.Labels.features");
    private ListViewer featureList;
    private Button featureSelected;
    private Text featureDescriptionText;
    private IGridLayoutPane propertyListPane;
    private LayerContainer layers;
    private Vector listeners = new Vector();
    static /* synthetic */ Class class$com$sap$ide$ws$editors$wsd$pages$FeaturePage;

    public FeaturePage(Composite parentComposite, WSDEditor parentEditor) {
        super(parentComposite, parentEditor);
    }

    public INotifiable getLayerContainerParent() {
        return (WSDEditor)super.getParentEditor();
    }

    public void addFeatureSelectedListener(IUpdateLayer listener) {
        this.listeners.add(listener);
    }

    public void removeFeatureSelectedListener(IUpdateLayer listener) {
        this.listeners.remove(listener);
    }

    public Composite getControl() {
        IGridLayoutPane detailsPane = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)1);
        detailsPane.setLayoutData((Object)new GridData(1808));
        detailsPane.addPlaceholder();
        IGridLayoutPane featureDetailPane = detailsPane.addGridLayoutPane(3);
        featureDetailPane.setLayoutData((Object)new GridData(1808));
        featureDetailPane.addTextLabel(WsCoreUiTexts.getString((String)"WsCore.Labels.General.name"), featureDetailPane.createGridLayoutData(4, 4, true, false, 3, 1));
        this.featureList = featureDetailPane.addListViewer(false, featureDetailPane.createGridLayoutData(4, 4, true, false));
        featureDetailPane.addTextLabel(WsCoreUiTexts.getString((String)"WsCore.Labels.General.description"), featureDetailPane.createGridLayoutData(4, 4, true, false, 3, 1));
        this.featureDescriptionText = featureDetailPane.addTextField("", true, featureDetailPane.createGridLayoutData(4, 4, true, false, 1, 1));
        UIUtil.createFillLabel(featureDetailPane, 3, 1);
        this.featureSelected = featureDetailPane.addCheckBox(WsUiTexts.getString("FeaturePage.Labels.selectFeature"), false, featureDetailPane.createGridLayoutData(4, 4, 3, 1));
        this.featureSelected.addSelectionListener((SelectionListener)new FeatureSelectedListener());
        this.propertyListPane = featureDetailPane.addGridLayoutPane(1);
        this.propertyListPane.setLayoutData((Object)new GridData(1808));
        this.featureList.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.featureList.setLabelProvider((IBaseLabelProvider)new FeatureListLabelProvider((FeatureSelected)this.getParentEditor()));
        this.setFeatureListForFirstVI();
        this.featureList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FeaturePage.this.setFeaturePaneElements((FeatureDt)((IStructuredSelection)event.getSelection()).getFirstElement());
                FeaturePage.this.layers.bringLayerToTop((FeatureDt)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        return detailsPane.getComposite();
    }

    public void selectFeature(FeatureDt feature) {
        this.featureList.setSelection((ISelection)new StructuredSelection((Object)feature));
    }

    public void selectProperty(PropertyDt currentProperty, FeatureDt parentFeature) {
        PropertyPane pane = (PropertyPane)this.layers.getLayerComposite(parentFeature);
        pane.selectPropertyTab(currentProperty.getName());
    }

    private void setFeatureListForFirstVI() {
        SOAPApplicationDt[] apps;
        Object[] features;
        SOAPApplicationDt app = null;
        VirtualInterface vi = ((WSDEditor)this.getParentEditor()).getVirtualInterface();
        if (vi != null && (features = (app = (apps = SOAPApplicationFactoryDt.createSOAPApplication((String)SOAPApplicationFactoryDt.convertConstant((InterfaceType)vi.getInterfaceType())))[0]).getFeatures()) != null && features.length > 0) {
            this.layers = new PropertyPaneLayerContainer(features, this.propertyListPane, this);
            this.featureList.setInput((Object)features);
            this.featureList.setSelection((ISelection)new StructuredSelection(features[0]));
            this.layers.bringLayerToTop(features[0]);
            this.featureSelected.setSelection(((WSDEditor)this.getParentEditor()).checkFeatureSelected(features[0].getName()));
        }
    }

    private void setFeaturePaneElements(FeatureDt currentFeature) {
        this.featureDescriptionText.setText(currentFeature.getDescription());
        this.featureSelected.setSelection(((WSDEditor)this.getParentEditor()).checkFeatureSelected(currentFeature.getName()));
        this.featureSelected.setEnabled(!currentFeature.isRequired());
        if (currentFeature.isRequired()) {
            try {
                if (this.getWebServiceDefinition().getSoapApplications()[0].getFeature(currentFeature.getName()) == null) {
                    this.getWebServiceDefinition().getSoapApplications()[0].createFeature(currentFeature.getName());
                }
            }
            catch (CreateException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$editors$wsd$pages$FeaturePage == null ? (class$com$sap$ide$ws$editors$wsd$pages$FeaturePage = FeaturePage.class$("com.sap.ide.ws.editors.wsd.pages.FeaturePage")) : class$com$sap$ide$ws$editors$wsd$pages$FeaturePage));
            }
        }
    }

    private void notifyListenersOfUpdate(FeatureDt feature) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((IUpdateLayer)this.listeners.elementAt(i)).updateLayer(feature);
            ++i;
        }
    }

    private void attachRequiredProperties(String featureName) {
        SOAPApplicationDt[] app = SOAPApplicationFactoryDt.createSOAPApplication((String)SOAPApplicationFactoryDt.convertConstant((InterfaceType)((WSDEditor)this.getParentEditor()).getVirtualInterface().getInterfaceType()));
        if (app != null && app.length > 0) {
            FeatureDt[] features = app[0].getFeatures();
            int i = 0;
            while (i < features.length) {
                if (features[i].getName().equals(featureName)) {
                    PropertyDt[] properties = features[i].getProperties();
                    int j = 0;
                    while (j < properties.length) {
                        if (properties[j].isRequired()) {
                            Feature f = this.getWebServiceDefinition().getSoapApplications()[0].getFeature(features[i].getName());
                            try {
                                Property p = f.createProperty(properties[j].getName());
                                p.setValue(properties[j].getDefaultValue());
                            }
                            catch (CreateException e) {
                                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$editors$wsd$pages$FeaturePage == null ? FeaturePage.class$("com.sap.ide.ws.editors.wsd.pages.FeaturePage") : class$com$sap$ide$ws$editors$wsd$pages$FeaturePage));
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FeatureSelectedListener
    implements SelectionListener {
        static /* synthetic */ Class class$com$sap$ide$ws$editors$wsd$pages$FeaturePage;

        private FeatureSelectedListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!FeaturePage.this.isInResetMode()) {
                if (!FeaturePage.this.isChangeAllowed((HandleReadOnlyStateI)new MdoReadOnlyStateHandler((MainDevelopmentObject)FeaturePage.this.getWebServiceDefinition()), new ResetPageStateI(this){
                    private final /* synthetic */ FeatureSelectedListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleReset() {
                        FeaturePage.access$400(FeatureSelectedListener.access$300(this.this$1)).setSelection(!FeaturePage.access$400(FeatureSelectedListener.access$300(this.this$1)).getSelection());
                    }
                })) {
                    return;
                }
                FeaturePage.this.getParentEditor().notifyOfChange();
                if (FeaturePage.this.featureSelected.getSelection()) {
                    try {
                        FeaturePage.this.getWebServiceDefinition().getSoapApplications()[0].createFeature(((FeatureDt)((IStructuredSelection)FeaturePage.this.featureList.getSelection()).getFirstElement()).getName());
                        FeaturePage.this.attachRequiredProperties(((FeatureDt)((IStructuredSelection)FeaturePage.this.featureList.getSelection()).getFirstElement()).getName());
                    }
                    catch (CreateException ce) {
                        WebServiceCorePlugin.logError((Throwable)ce, (Class)(class$com$sap$ide$ws$editors$wsd$pages$FeaturePage == null ? (class$com$sap$ide$ws$editors$wsd$pages$FeaturePage = FeatureSelectedListener.class$("com.sap.ide.ws.editors.wsd.pages.FeaturePage")) : class$com$sap$ide$ws$editors$wsd$pages$FeaturePage));
                    }
                } else {
                    Feature f = FeaturePage.this.getWebServiceDefinition().getSoapApplications()[0].getFeature(((FeatureDt)((IStructuredSelection)FeaturePage.this.featureList.getSelection()).getFirstElement()).getName());
                    try {
                        f.delete();
                    }
                    catch (DeleteException de) {
                        WebServiceCorePlugin.logError((Throwable)de, (Class)(class$com$sap$ide$ws$editors$wsd$pages$FeaturePage == null ? (class$com$sap$ide$ws$editors$wsd$pages$FeaturePage = FeatureSelectedListener.class$("com.sap.ide.ws.editors.wsd.pages.FeaturePage")) : class$com$sap$ide$ws$editors$wsd$pages$FeaturePage));
                    }
                }
                FeaturePage.this.notifyListenersOfUpdate((FeatureDt)((IStructuredSelection)FeaturePage.this.featureList.getSelection()).getFirstElement());
                ((WSDEditor)FeaturePage.this.getParentEditor()).refreshOutline();
            }
        }

        static /* synthetic */ FeaturePage access$300(FeatureSelectedListener x0) {
            return x0.FeaturePage.this;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

