/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.wsd;

import com.sap.ide.eclipse.dii.component.IAskForSaveEditor;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.vi.InterfaceType;
import com.sap.ide.metamodel.vi.VIRoot;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.vi.plugin.VIRootManager;
import com.sap.ide.metamodel.ws.Feature;
import com.sap.ide.metamodel.ws.Property;
import com.sap.ide.metamodel.ws.VirtualInterfaceReference;
import com.sap.ide.metamodel.ws.WSDRoot;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.metamodel.ws.plugin.WSRootManager;
import com.sap.ide.ws.core.decorators.WsLabelDecorator;
import com.sap.ide.ws.core.editors.GenericMultiPageEditor;
import com.sap.ide.ws.core.editors.GenericMultiPageEditorPage;
import com.sap.ide.ws.core.editors.MdoReadOnlyStateHandler;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.dtr.MdoDtrService;
import com.sap.ide.ws.core.services.resources.EclipseFilePathService;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import com.sap.ide.ws.core.ui.preferences.WebServicePreferences;
import com.sap.ide.ws.decorator.WsdDecoratorFlagProvider;
import com.sap.ide.ws.editors.wsd.FeatureSelected;
import com.sap.ide.ws.editors.wsd.pages.DocumentationPage;
import com.sap.ide.ws.editors.wsd.pages.FeaturePage;
import com.sap.ide.ws.editors.wsd.pages.OverviewPage;
import com.sap.ide.ws.editors.wsd.pages.UDDIPage;
import com.sap.ide.ws.editors.wsd.pages.WSDOutlinePage;
import com.sap.ide.ws.editors.wsd.ui.UiElementWidgetId;
import com.sap.ide.ws.soapapp.Enum;
import com.sap.ide.ws.soapapp.FeatureDt;
import com.sap.ide.ws.soapapp.InvalidSAConfigurationException;
import com.sap.ide.ws.soapapp.PropertyDt;
import com.sap.ide.ws.soapapp.SOAPApplicationDt;
import com.sap.ide.ws.soapapp.SOAPApplicationFactoryDt;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.ui.layers.INotifiable;
import com.tssap.j2ee.core.providers.vi.ui.WsUIPlugin;
import com.tssap.util.help.ContextHelp;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class WSDEditor
extends GenericMultiPageEditor
implements FeatureSelected,
INotifiable,
IDevelopmentObjectEditor,
IAskForSaveEditor {
    public static final String EDITOR_ID = "com.sap.ide.ws.editors.wsd.WSDEditor";
    private OverviewPage overviewPage;
    private int overviewIndex;
    private FeaturePage featurePage;
    private int featureIndex;
    private DocumentationPage documentationPage;
    private int documentationIndex;
    private UDDIPage uddiPage;
    private int uddiIndex;
    private DefaultTreeModel treeModel;
    private String projectName;
    private WebServiceDefinition wsDefinition;
    private VirtualInterface[] viList;
    private IStatus featureStatus;
    private WSDOutlinePage outlinePage;
    static /* synthetic */ Class class$com$sap$ide$ws$editors$wsd$WSDEditor;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public boolean isEditedObjectReadOnly() {
        return MdoDtrService.isMdoOrLanguageFileReadOnly((MainDevelopmentObject)((WebServiceDefinition)this.getEditingObject()));
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(this.documentationIndex);
        super.gotoMarker(marker);
    }

    protected String getProjectName() {
        return this.projectName;
    }

    private void doSave() {
        try {
            CommitResult result = this.wsDefinition.commitChanges();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.open();
            IProgressMonitor progressMonitor = dialog.getProgressMonitor();
            MetamodelManager.getMetamodelManager((String)this.projectName).processDeletedFiles(result, progressMonitor);
            dialog.close();
            if (WebServicePreferences.isAutoUploadEnabled() && this.uddiPage.checkWsdPublishable()) {
                this.uddiPage.initiateUpload();
            }
            new WsRefreshAction().refresh(this.projectName);
        }
        catch (Exception e) {
            try {
                this.wsDefinition.rollbackChanges();
            }
            catch (LoadException le) {
                WebServiceCorePlugin.logError((Throwable)le, (Class)(class$com$sap$ide$ws$editors$wsd$WSDEditor == null ? (class$com$sap$ide$ws$editors$wsd$WSDEditor = WSDEditor.class$(EDITOR_ID)) : class$com$sap$ide$ws$editors$wsd$WSDEditor));
            }
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$editors$wsd$WSDEditor == null ? (class$com$sap$ide$ws$editors$wsd$WSDEditor = WSDEditor.class$(EDITOR_ID)) : class$com$sap$ide$ws$editors$wsd$WSDEditor));
        }
    }

    protected boolean doSaveTask() {
        this.checkSaveAbility();
        if (this.featureStatus.getSeverity() == 0) {
            MdoReadOnlyStateHandler readStateHandler = new MdoReadOnlyStateHandler((MainDevelopmentObject)this.wsDefinition);
            if (readStateHandler.isReadOnly() && (readStateHandler.isDtrRelevant() ? !readStateHandler.checkOutFromDtr() : !readStateHandler.changeFileReadOnlyFlag())) {
                return false;
            }
            this.doSave();
            return true;
        }
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)WsUiTexts.getString("WSDEditor.Errors.wsdStatusError"), (String)this.featureStatus.getMessage());
        return false;
    }

    public DevelopmentObject getDevelopmentObject() {
        return this.wsDefinition;
    }

    public void updateUI() {
        Image image = WsUIPlugin.getImage((String)"web_services/webservice_definition/WebServiceDefinition.gif");
        this.setTitleImage(WsLabelDecorator.getInstance().decorateImage(image, (Object)new WsdDecoratorFlagProvider(this.wsDefinition)));
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = WSDEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            this.createOutlineTree();
            this.outlinePage = new WSDOutlinePage(this.treeModel, this);
            this.outlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    WSDEditor.this.doOutlineSelectionChanged(event);
                }
            });
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            this.projectName = file.getProject().getName();
            try {
                String name = file.getName().substring(0, file.getName().indexOf(46));
                String packAndSrc = EclipseFilePathService.removeFileNameFromPath((String)file.getProjectRelativePath().toOSString());
                String pack = EclipseFilePathService.removeSrcFolderPartFromPath((String)packAndSrc, (String)file.getProject().getName());
                WSDRoot root = WSRootManager.getWSRoot((String)this.projectName);
                if (root == null) {
                    root = WSRootManager.getWSRoot((String)this.projectName);
                }
                this.wsDefinition = root.getWebServiceDefinition(EclipseFilePathService.convertSlashesToDots((String)pack), name);
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$editors$wsd$WSDEditor == null ? (class$com$sap$ide$ws$editors$wsd$WSDEditor = WSDEditor.class$(EDITOR_ID)) : class$com$sap$ide$ws$editors$wsd$WSDEditor));
            }
        }
        this.setTitle(this.wsDefinition.getName());
        this.setTitleImage(WsUIPlugin.getImage((String)"web_services/webservice_definition/WebServiceDefinition.gif"));
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.wsDefinition);
        this.treeModel = new DefaultTreeModel(rootNode);
        this.setViList(this.wsDefinition.getVirtualInterfaceReferences());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doDisposeTask() {
        if (this.wsDefinition != null) {
            try {
                this.wsDefinition.rollbackChanges();
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$editors$wsd$WSDEditor == null ? (class$com$sap$ide$ws$editors$wsd$WSDEditor = WSDEditor.class$(EDITOR_ID)) : class$com$sap$ide$ws$editors$wsd$WSDEditor));
            }
        }
    }

    public Object getEditingObject() {
        return this.wsDefinition;
    }

    public void setPageAndIndex(GenericMultiPageEditorPage page, int index) {
        if (page instanceof OverviewPage) {
            this.overviewPage = (OverviewPage)page;
            this.overviewIndex = index;
        } else if (page instanceof FeaturePage) {
            this.featurePage = (FeaturePage)page;
            this.featureIndex = index;
        } else if (page instanceof DocumentationPage) {
            this.documentationPage = (DocumentationPage)page;
            this.documentationIndex = index;
        } else if (page instanceof UDDIPage) {
            this.uddiPage = (UDDIPage)page;
            this.uddiIndex = index;
        }
    }

    public void refreshOutline() {
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    protected void createPages() {
        this.getContainer().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                ContextHelp.show((String)"com.sap.devmanual.doc.user", (String)"WSWSD");
            }
        });
        OverviewPage overviewPage = new OverviewPage(this.getContainer(), this);
        int overviewIndex = this.addPage((Control)overviewPage.getControl());
        this.setPageText(overviewIndex, OverviewPage.OVERVIEW_PAGE_TEXT);
        this.setPageAndIndex(overviewPage, overviewIndex);
        FeaturePage featurePage = new FeaturePage(this.getContainer(), this);
        int featureIndex = this.addPage((Control)featurePage.getControl());
        this.setPageText(featureIndex, FeaturePage.FEATURE_PAGE_TEXT);
        this.setPageAndIndex(featurePage, featureIndex);
        DocumentationPage documentationPage = new DocumentationPage(this.getContainer(), this);
        int dcumentationIndex = this.addPage((Control)documentationPage.getControl());
        this.setPageText(dcumentationIndex, DocumentationPage.DOCUMENTATION_PAGE_TEXT);
        this.setPageAndIndex(documentationPage, dcumentationIndex);
        UDDIPage uddiPage = new UDDIPage(this.getContainer(), this);
        int uddiIndex = this.addPage((Control)uddiPage.getControl());
        this.setPageText(uddiIndex, UDDIPage.UDDI_PAGE_TEXT);
        this.setPageAndIndex(uddiPage, uddiIndex);
        this.updateUI();
    }

    private void createOutlineTree() {
        DefaultMutableTreeNode overviewNode = new DefaultMutableTreeNode(new UiElementWidgetId(OverviewPage.OVERVIEW_PAGE_TEXT));
        ((DefaultMutableTreeNode)this.treeModel.getRoot()).add(overviewNode);
        DefaultMutableTreeNode featureListNode = new DefaultMutableTreeNode(new UiElementWidgetId(FeaturePage.FEATURE_PAGE_TEXT));
        ((DefaultMutableTreeNode)this.treeModel.getRoot()).add(featureListNode);
        if (this.viList != null) {
            int i = 0;
            while (i < this.viList.length) {
                if (this.viList[i] != null) {
                    SOAPApplicationDt[] app = SOAPApplicationFactoryDt.createSOAPApplication((String)SOAPApplicationFactoryDt.convertConstant((InterfaceType)this.viList[i].getInterfaceType()));
                    FeatureDt[] features = app[0].getFeatures();
                    int j = 0;
                    while (j < features.length) {
                        DefaultMutableTreeNode featureNode = new DefaultMutableTreeNode(features[j], true);
                        PropertyDt[] properties = features[j].getProperties();
                        int k = 0;
                        while (k < properties.length) {
                            featureNode.add(new DefaultMutableTreeNode(properties[k]));
                            ++k;
                        }
                        featureListNode.add(featureNode);
                        ++j;
                    }
                }
                ++i;
            }
        }
        DefaultMutableTreeNode documentationNode = new DefaultMutableTreeNode(new UiElementWidgetId(DocumentationPage.DOCUMENTATION_PAGE_TEXT));
        ((DefaultMutableTreeNode)this.treeModel.getRoot()).add(documentationNode);
        DefaultMutableTreeNode uddiNode = new DefaultMutableTreeNode(new UiElementWidgetId(UDDIPage.UDDI_PAGE_TEXT));
        ((DefaultMutableTreeNode)this.treeModel.getRoot()).add(uddiNode);
    }

    private void doOutlineSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.reflectOutlineSelectionChanged(selection);
    }

    private void reflectOutlineSelectionChanged(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structSel = (StructuredSelection)selection;
            Object[] arr = structSel.toArray();
            int i = 0;
            while (i < arr.length) {
                Object object = arr[i];
                if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() instanceof FeatureDt) {
                    this.setFeatureDataOutlineSelection((DefaultMutableTreeNode)object);
                } else if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() instanceof PropertyDt) {
                    this.setPropertyDataOnOutlineSelection((DefaultMutableTreeNode)object);
                } else if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() instanceof UiElementWidgetId) {
                    this.setTabOnOutlineSelection((UiElementWidgetId)((DefaultMutableTreeNode)object).getUserObject());
                }
                ++i;
            }
        }
    }

    private void setTabOnOutlineSelection(UiElementWidgetId id) {
        if (id.getWidgetId().equals(OverviewPage.OVERVIEW_PAGE_TEXT)) {
            this.setActivePage(this.overviewIndex);
        } else if (id.getWidgetId().equals(FeaturePage.FEATURE_PAGE_TEXT)) {
            this.setActivePage(this.featureIndex);
        } else if (id.getWidgetId().equals(DocumentationPage.DOCUMENTATION_PAGE_TEXT)) {
            this.setActivePage(this.documentationIndex);
        } else if (id.getWidgetId().equals(UDDIPage.UDDI_PAGE_TEXT)) {
            this.setActivePage(this.uddiIndex);
        }
    }

    private void setFeatureDataOutlineSelection(DefaultMutableTreeNode node) {
        this.setTabOnOutlineSelection(new UiElementWidgetId(FeaturePage.FEATURE_PAGE_TEXT));
        this.featurePage.selectFeature((FeatureDt)node.getUserObject());
    }

    private void setParentFeature(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof FeatureDt) {
            this.setFeatureDataOutlineSelection(node);
        } else {
            this.setParentFeature((DefaultMutableTreeNode)node.getParent());
        }
    }

    private void setPropertyDataOnOutlineSelection(DefaultMutableTreeNode node) {
        this.setTabOnOutlineSelection(new UiElementWidgetId(FeaturePage.FEATURE_PAGE_TEXT));
        PropertyDt currentProperty = (PropertyDt)node.getUserObject();
        if (node.getParent() != null) {
            this.setParentFeature(node);
        }
        this.featurePage.selectProperty(currentProperty, (FeatureDt)((DefaultMutableTreeNode)node.getParent()).getUserObject());
    }

    private String[] convertEnumToStringArray(Enum enum_) {
        Vector<String> enumValues = new Vector<String>();
        while (enum_.hasMoreElements()) {
            enumValues.add(enum_.nextElement().toString());
        }
        String[] values = new String[enumValues.size()];
        int i = 0;
        while (i < enumValues.size()) {
            values[i] = enumValues.elementAt(i).toString();
            ++i;
        }
        return values;
    }

    private String[] convertObjectToStringArray(Object[] arr) {
        String[] temp = new String[arr.length];
        int i = 0;
        while (i < arr.length) {
            temp[i] = arr[i].toString();
            ++i;
        }
        return temp;
    }

    private FeatureDt getFeatureDtForName(String name) {
        SOAPApplicationDt[] apps = SOAPApplicationFactoryDt.createSOAPApplication((String)SOAPApplicationFactoryDt.convertConstant((InterfaceType)this.viList[0].getInterfaceType()));
        FeatureDt[] features = apps[0].getFeatures();
        int i = 0;
        while (i < features.length) {
            if (features[i].getName().equals(name)) {
                return features[i];
            }
            ++i;
        }
        return null;
    }

    private void checkSaveAbility() {
        this.featureStatus = this.checkSoapAppConfig();
    }

    private IStatus checkSoapAppConfig() {
        SOAPApplicationDt[] app = SOAPApplicationFactoryDt.createSOAPApplication((String)SOAPApplicationFactoryDt.convertConstant((InterfaceType)this.viList[0].getInterfaceType()));
        try {
            app[0].checkConfiguration((Object)this.wsDefinition.getSoapApplication(SOAPApplicationFactoryDt.convertConstant((InterfaceType)this.viList[0].getInterfaceType())));
        }
        catch (InvalidSAConfigurationException e) {
            WebServiceCorePlugin.logErrorSimulated((Throwable)e);
            return new StatusInfo(4, e.getMessage());
        }
        return new StatusInfo(0, "");
    }

    public boolean checkPropertySelected(String featureName, String propertyName) {
        Feature f = this.wsDefinition.getSoapApplications()[0].getFeature(featureName);
        if (f == null) {
            return false;
        }
        Property p = f.getProperty(propertyName);
        return p != null;
    }

    public boolean checkFeatureSelected(String featureName) {
        Feature[] features = ((WebServiceDefinition)this.getEditingObject()).getSoapApplications()[0].getFeatures();
        int i = 0;
        while (i < features.length) {
            if (features[i].getName().equals(featureName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public VirtualInterface getVirtualInterface() {
        return this.viList[0];
    }

    public void setViList(VirtualInterfaceReference[] viReferenceList) {
        VIRoot viRoot = VIRootManager.getVIRoot((String)this.projectName);
        this.viList = new VirtualInterface[viReferenceList.length];
        int i = 0;
        while (i < viReferenceList.length) {
            try {
                this.viList[i] = viRoot.getVirtualInterface(viReferenceList[i].getPackage(), viReferenceList[i].getName());
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$editors$wsd$WSDEditor == null ? WSDEditor.class$(EDITOR_ID) : class$com$sap$ide$ws$editors$wsd$WSDEditor));
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

