/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.descriptor.ui.panes;

import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.cfg.DeploymentConfiguration;
import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.editors.descriptor.pages.WsDDTreeEditorPage;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.wsddman.Configuration;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IReuseable;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public abstract class WsDDGenericEditorPane
implements IReuseable,
EditorItemI,
PaintListener {
    private Composite parentComposite;
    private EditorItemI parentEditorItem;
    private DeploymentConfiguration deployData;
    private Configuration config;
    protected boolean canShowData = true;

    public WsDDGenericEditorPane(Composite parentComposite, EditorItemI parentEditor, DeploymentConfiguration deployData, Configuration config) {
        this.parentComposite = parentComposite;
        this.parentEditorItem = parentEditor;
        this.deployData = deployData;
        this.config = config;
    }

    public WsDDGenericEditorPane(EditorItemI parentEditorItem, DeploymentConfiguration deployData, Configuration config) {
        this(null, parentEditorItem, deployData, config);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public DeploymentConfiguration getDeployData() {
        return this.deployData;
    }

    public WsDDTreeEditorPage getParentPage() {
        return (WsDDTreeEditorPage)this.parentEditorItem;
    }

    public boolean getReadOnly() {
        return this.parentEditorItem.getReadOnly();
    }

    public Control createPartControl(Composite parent) {
        this.parentComposite = parent;
        Control control = this.getControl();
        this.init();
        return control;
    }

    public Composite getParentComposite() {
        return this.parentComposite;
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.deployData;
    }

    public void setEnabled(boolean enabled) {
    }

    public boolean isEnabled() {
        return false;
    }

    public Object getEditingObject() {
        return this.config;
    }

    public void notifyOfChange() {
        this.parentEditorItem.notifyOfChange();
    }

    public void checkWSDAndVI() {
        if (this.deployData == null) {
            this.canShowData = false;
            return;
        }
        WebServiceDefinition wsd = this.deployData.getWebServiceDefinition();
        VirtualInterface vi = WebServiceMdoResolver.getReferencedVi((String)this.getDeployData().getDescriptorProjectName(), (WebServiceDefinition)this.getDeployData().getWebServiceDefinition());
        this.canShowData = wsd != null && vi != null;
    }

    public void createErrorLabel(IGridLayoutPane parent) {
        Label errorLabel = parent.addTextLabel(WsUiTexts.getString("WsDDEditor.missing.VI.or.WSD.1") + '\n' + WsUiTexts.getString("WsDDEditor.missing.VI.or.WSD.2") + '\n' + WsUiTexts.getString("WsDDEditor.missing.VI.or.WSD.3"), parent.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setLabelColor(errorLabel);
        errorLabel.addPaintListener((PaintListener)this);
    }

    public void setLabelColor(Label l) {
        Color c = l.getBackground();
        int red = c.getRed() + 32;
        int green = c.getGreen() + 128;
        int blue = c.getBlue() + 64;
        if (red > 256) {
            red -= 256;
        }
        if (green > 255) {
            green -= 256;
        }
        if (blue > 256) {
            blue -= 256;
        }
        Color c1 = new Color((Device)Display.getCurrent(), red, green, blue);
        l.setForeground(c1);
    }

    public void paintControl(PaintEvent e) {
        if (e.widget instanceof Label) {
            Label l = (Label)e.widget;
            this.setLabelColor(l);
        }
    }

    public abstract Control getControl();

    public abstract void init();
}

