/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.descriptor.ui.panes;

import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.ws.cfg.DeploymentConfiguration;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.core.editors.FileReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.editors.descriptor.ui.panes.WsDDGenericEditorPane;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.JavaClassSecurityRole;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.impl0.JavaClassSecurityRoleImpl;
import com.sap.ide.ws.wsddman.impl0.OperationConfigurationImpl;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class SecurityRolesPane
extends WsDDGenericEditorPane
implements SelectionListener,
ModifyListener {
    private ISelection selection;
    private OperationConfiguration[] configs;
    private List roles = null;
    private String transportbinding;
    private String[] operations = null;
    private WebServiceDefinition wsd = null;
    private Text nametext = null;
    private Text descrtext = null;
    private Button addbutton = null;
    private Button removebutton = null;
    private Text userstext = null;
    private Text groupstext = null;
    JavaClassSecurityRole[] ddroles = null;
    String[] rolenames = null;
    IGridLayoutPane pane2 = null;
    IGridLayoutPane mappingspane = null;
    boolean changeallowed = true;

    public SecurityRolesPane(Composite parentComposite, EditorItemI parentEditor, DeploymentConfiguration deployData, Configuration cfg) {
        super(parentComposite, parentEditor, deployData, cfg);
    }

    public SecurityRolesPane(EditorItemI parentEditor, DeploymentConfiguration deployData, Configuration cfg) {
        this(null, parentEditor, deployData, cfg);
    }

    public void init() {
        this.changeallowed = false;
        this.ddroles = super.getConfiguration().getJavaSecurityRoles();
        this.rolenames = new String[this.ddroles.length];
        int i = 0;
        while (i < this.rolenames.length) {
            this.rolenames[i] = this.ddroles[i].getName();
            ++i;
        }
        this.roles.setItems(this.rolenames);
        if (this.rolenames.length > 0) {
            this.pane2.getComposite().setVisible(true);
            this.mappingspane.getComposite().setVisible(true);
            this.roles.setSelection(0);
            this.setTextFields(0);
        }
        this.changeallowed = true;
    }

    public Control getControl() {
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)1);
        IGridLayoutPane rolepane = mainPane.addGridLayoutPane("", 2, mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
        IGridLayoutPane pane1 = rolepane.addGridLayoutPane("", 1, mainPane.createGridLayoutData(4, 4, true, true, 1, 2));
        this.pane2 = rolepane.addGridLayoutPane("", 1, mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
        pane1.addTextLabel(WsUiTexts.getString("SecurityRolesPane.Labels.securityRoles"));
        this.roles = pane1.addList(new String[0], false, mainPane.createGridLayoutData(4, 4, true, true, 1, 4));
        IGridLayoutPane buttonpane = pane1.addGridLayoutPane(2, mainPane.createGridLayoutData(1, 1, false, false, 1, 1));
        this.pane2.addTextLabel(WsCoreUiTexts.getString((String)"WsCore.Labels.General.name"));
        this.nametext = this.pane2.addTextField("", false, mainPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.pane2.addTextLabel(WsCoreUiTexts.getString((String)"WsCore.Labels.General.description"));
        this.descrtext = this.pane2.addTextPane("", false, true, mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.addbutton = buttonpane.addPushButton(WsCoreUiTexts.getString((String)"WsCore.Labels.General.add"), mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.removebutton = buttonpane.addPushButton(WsCoreUiTexts.getString((String)"WsCore.Labels.General.remove"), mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mappingspane = rolepane.addGridLayoutPane(WsUiTexts.getString("SecurityRolesPane.Labels.mappings"), 1, mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mappingspane.addTextLabel(WsUiTexts.getString("SecurityRolesPane.Labels.userNames"));
        this.userstext = this.mappingspane.addTextPane("", false, true, mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mappingspane.addTextLabel(WsUiTexts.getString("SecurityRolesPane.Labels.groupNames"));
        this.groupstext = this.mappingspane.addTextPane("", false, true, mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.pane2.getComposite().setVisible(false);
        this.mappingspane.getComposite().setVisible(false);
        this.addbutton.addSelectionListener((SelectionListener)this);
        this.removebutton.addSelectionListener((SelectionListener)this);
        this.roles.addSelectionListener((SelectionListener)this);
        this.addListeners();
        return mainPane.getComposite();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (!this.getParentPage().isInResetMode()) {
            if (!this.getParentPage().isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName((String)this.getDeployData().getDescriptorProjectName())), null)) {
                return;
            }
            this.adjustPageData((TypedEvent)event);
        }
    }

    void adjustPageData(TypedEvent te) {
        if (te.widget == this.addbutton) {
            if (this.roles.getItems().length == 0) {
                this.pane2.getComposite().setVisible(true);
                this.mappingspane.getComposite().setVisible(true);
            }
            JavaClassSecurityRole[] ddroles1 = new JavaClassSecurityRole[this.ddroles.length + 1];
            System.arraycopy(this.ddroles, 0, ddroles1, 0, this.ddroles.length);
            ddroles1[this.ddroles.length] = this.createSecurityRole();
            this.ddroles = ddroles1;
            this.roles.add(this.ddroles[this.ddroles.length - 1].getName());
            this.rolenames = this.roles.getItems();
            this.roles.setSelection(this.ddroles.length - 1);
            this.setTextFields(this.ddroles.length - 1);
            super.getConfiguration().setJavaSecurityRoles(this.ddroles);
            super.notifyOfChange();
        } else if (te.widget == this.removebutton) {
            if (this.rolenames.length == 1) {
                this.pane2.getComposite().setVisible(false);
                this.mappingspane.getComposite().setVisible(false);
            }
            int j = this.roles.getSelectionIndex();
            this.rolenames = this.roles.getItems();
            if (this.rolenames.length > 0 && j > -1) {
                String[] rolenames1 = new String[this.rolenames.length - 1];
                JavaClassSecurityRole[] ddroles1 = new JavaClassSecurityRole[this.ddroles.length - 1];
                int newindex = j;
                if (j > 0) {
                    System.arraycopy(this.ddroles, 0, ddroles1, 0, j);
                }
                if (j < this.rolenames.length - 1) {
                    System.arraycopy(this.ddroles, j + 1, ddroles1, j, ddroles1.length - j);
                } else {
                    newindex = j > 0 ? 0 : -1;
                }
                this.ddroles = ddroles1;
                String removedrole = this.roles.getItem(j);
                this.roles.remove(j);
                if (newindex > -1) {
                    this.setTextFields(newindex);
                    this.roles.setSelection(newindex);
                }
                this.rolenames = this.roles.getItems();
                Configuration cfg = super.getConfiguration();
                cfg.setJavaSecurityRoles(this.ddroles);
                OperationConfiguration[] opcfgs = cfg.getOperationConfigurations();
                int i = 0;
                while (i < opcfgs.length) {
                    Vector oproles = ((OperationConfigurationImpl)opcfgs[i]).getSecurityRoles();
                    j = 0;
                    while (j < oproles.size()) {
                        if (removedrole.equals(oproles.elementAt(j))) {
                            oproles.remove(j);
                        }
                        ++j;
                    }
                    ((OperationConfigurationImpl)opcfgs[i]).setSecurityRoles(oproles);
                    ++i;
                }
                super.notifyOfChange();
            }
        } else if (te.widget == this.roles) {
            int index = this.roles.getSelectionIndex();
            if (index > -1) {
                this.pane2.getComposite().setVisible(true);
                this.mappingspane.getComposite().setVisible(true);
                this.setTextFields(index);
            }
        } else if (te.widget == this.nametext) {
            if (this.changeallowed) {
                this.roles.setItem(this.roles.getSelectionIndex(), this.nametext.getText());
                this.ddroles[this.roles.getSelectionIndex()].setName(this.nametext.getText());
                super.notifyOfChange();
            }
        } else if (te.widget == this.descrtext) {
            if (this.changeallowed) {
                this.ddroles[this.roles.getSelectionIndex()].setDescription(this.descrtext.getText());
                super.notifyOfChange();
            }
        } else if (te.widget == this.userstext) {
            if (this.changeallowed) {
                this.ddroles[this.roles.getSelectionIndex()].setUserMapping(this.userstext.getText());
                super.notifyOfChange();
            }
        } else if (te.widget == this.groupstext && this.changeallowed) {
            this.ddroles[this.roles.getSelectionIndex()].setGroupMapping(this.groupstext.getText());
            super.notifyOfChange();
        }
    }

    public void modifyText(final ModifyEvent e) {
        if (!this.getParentPage().isInResetMode()) {
            if (!this.getParentPage().isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName((String)this.getDeployData().getDescriptorProjectName())), new ResetPageStateI(){

                public void handleReset() {
                    if ((e.widget == SecurityRolesPane.this.nametext || e.widget == SecurityRolesPane.this.descrtext || e.widget == SecurityRolesPane.this.userstext || e.widget == SecurityRolesPane.this.groupstext) && SecurityRolesPane.this.rolenames.length > 0) {
                        SecurityRolesPane.this.pane2.getComposite().setVisible(true);
                        SecurityRolesPane.this.mappingspane.getComposite().setVisible(true);
                        SecurityRolesPane.this.roles.setSelection(0);
                        SecurityRolesPane.this.setTextFields(0);
                    }
                }
            })) {
                return;
            }
            this.adjustPageData((TypedEvent)e);
        }
    }

    public JavaClassSecurityRole createSecurityRole() {
        JavaClassSecurityRoleImpl jcsr = new JavaClassSecurityRoleImpl();
        jcsr.setName(this.getUniqueRoleName());
        return jcsr;
    }

    private String getUniqueRoleName() {
        int i = 1;
        String name = "role1";
        while (this.nameExists(name)) {
            name = "role" + ++i;
        }
        return name;
    }

    private boolean nameExists(String name) {
        boolean exists = false;
        int i = 0;
        while (i < this.rolenames.length) {
            exists = exists || name.equals(this.rolenames[i]);
            ++i;
        }
        return exists;
    }

    private void setTextFields(int j) {
        this.changeallowed = false;
        this.nametext.setText(this.ddroles[j].getName());
        this.descrtext.setText(this.ddroles[j].getDescription());
        this.userstext.setText(this.ddroles[j].getUserMapping());
        this.groupstext.setText(this.ddroles[j].getGroupMapping());
        this.changeallowed = true;
    }

    private void removeListeners() {
        this.nametext.removeModifyListener((ModifyListener)this);
        this.descrtext.removeModifyListener((ModifyListener)this);
        this.userstext.removeModifyListener((ModifyListener)this);
        this.groupstext.removeModifyListener((ModifyListener)this);
    }

    private void addListeners() {
        this.nametext.addModifyListener((ModifyListener)this);
        this.descrtext.addModifyListener((ModifyListener)this);
        this.userstext.addModifyListener((ModifyListener)this);
        this.groupstext.addModifyListener((ModifyListener)this);
    }
}

