/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.descriptor.ui.panes;

import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.cfg.DeploymentConfiguration;
import com.sap.ide.ws.configuration.WsConfigurationManager;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.core.editors.FileReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.editors.descriptor.ui.panes.WsDDGenericEditorPane;
import com.sap.ide.ws.soapapp.FeatureConstants;
import com.sap.ide.ws.soapapp.SoapAppToolPlugin;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.Feature;
import com.sap.ide.ws.wsddman.JavaClassSecurityRole;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.Property;
import com.sap.ide.ws.wsddman.impl0.FeatureImpl;
import com.sap.ide.ws.wsddman.impl0.OperationConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.PropertyImpl;
import com.sap.ide.ws.wsddman.impl0.WSConfigurationImpl;
import com.sap.security.core.policy.PolicyTemplateInfoManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SecurityConfigurationPane
extends WsDDGenericEditorPane
implements SelectionListener,
FeatureConstants,
ISelectionChangedListener,
PaintListener {
    private static final Image OPERATION_ICON = SoapAppToolPlugin.getImage((String)"config_wizard/operation1.gif");
    public static final String MECHANISM_NONE = "None";
    public static final String MECHANISM_HTTP = "HTTP Authentication";
    public static final String MECHANISM_DOCUMENT = "Document Authentication";
    private static final String[] TRANSPORTS = new String[]{"HTTP", "HTTPS"};
    private static final String[] HTTPS_TRANSPORT = new String[]{"HTTPS"};
    private static final String[] AUTHENTICATIONS = new String[]{"None", "Basic", "X.509"};
    private static final String[] DOCUMENT_MECHANISM = new String[]{"Document Authentication"};
    private static final String[] HTTP_MECHANISM = new String[]{"HTTP Authentication"};
    private static final String[] MECHANISMS = new String[]{"None", "HTTP Authentication", "Document Authentication"};
    private static final String[] DOC_AND_NONE_MECHANISMS = new String[]{"None", "Document Authentication"};
    private static final String[] AUTH_MECHANISMS = new String[]{"HTTP Authentication", "Document Authentication"};
    private static final String[] HTTP_AND_NONE = new String[]{"None", "HTTP Authentication"};
    private ISelection selection;
    private OperationConfiguration[] configs;
    private Property[] currentproperties = new Property[0];
    private IGridLayoutPane mainPane = null;
    private org.eclipse.swt.widgets.List tv = null;
    private Button authorcheckbox = null;
    private Label norolelabel = null;
    private IGridLayoutPane norolepane = null;
    private Vector availablerolesnames = new Vector();
    private Vector selectedrolesnames = new Vector();
    private Combo transporttype = null;
    private Combo authmechanism = null;
    private Feature[] features = null;
    private boolean changerequired = false;
    private boolean isstateful = false;
    private int wsdsecuritylevel = 0;
    private int wscfgsecuritylevel = 0;
    private Button currentselectedbutton = null;
    private boolean wscfgauthorizationselected = false;
    private boolean wsdauthorizationselected = false;
    private Button basicauthbutton = null;
    private Button certauthbutton = null;
    private Button acceptSAPticket = null;
    private CheckboxTableViewer roletable = null;
    private Combo requestcombo = null;
    private Combo responsecombo = null;
    private Vector lastcheckedelements = new Vector();
    PolicyTemplateInfoManager ptim = new PolicyTemplateInfoManager();
    private Text requestlabel = null;
    private Text responselabel = null;
    private boolean hassso = false;
    private boolean putsso = false;
    private boolean canhavedocauth = true;
    private int nonemechanismindex = 0;
    private int httpmechanismindex = 0;
    private int docmechanismindex = 0;
    private Vector allroles = new Vector();
    static /* synthetic */ Class class$com$sap$ide$ws$editors$descriptor$ui$panes$SecurityConfigurationPane;

    public SecurityConfigurationPane(Composite parentComposite, EditorItemI parentEditor, DeploymentConfiguration deployData, Configuration cfg) {
        super(parentComposite, parentEditor, deployData, cfg);
    }

    public SecurityConfigurationPane(EditorItemI parentEditor, DeploymentConfiguration deployData, Configuration cfg) {
        this(null, parentEditor, deployData, cfg);
    }

    public Feature[] createDeployTimeFeatures() {
        Property[] properties;
        Feature[] dtfeatures = new Feature[]{};
        this.putsso = false;
        int deployfeaturecount = 0;
        if (this.isstateful) {
            ++deployfeaturecount;
        }
        int httpindex = this.transporttype.getItemCount() - 2;
        int httpsindex = this.transporttype.getItemCount() - 1;
        int noneauthindex = this.nonemechanismindex;
        int transportindex = this.transporttype.getSelectionIndex();
        int authindex = this.authmechanism.getSelectionIndex();
        if (authindex == noneauthindex) {
            this.hassso = false;
        } else if (authindex == noneauthindex + 1) {
            this.putsso = true;
        }
        if (transportindex == httpindex && authindex == noneauthindex) {
            dtfeatures = new Feature[deployfeaturecount];
            this.roletable.setAllGrayed(true);
            this.roletable.getControl().setEnabled(false);
            this.wscfgsecuritylevel = 0;
        } else if (transportindex == httpsindex && authindex == noneauthindex) {
            dtfeatures = new Feature[++deployfeaturecount];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("TLSType");
            properties[0].setValue("SSL");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            this.wscfgsecuritylevel = 1;
        } else if (transportindex == httpindex && this.basicauthbutton.getSelection() && this.basicauthbutton.getVisible()) {
            if (!this.authorcheckbox.getSelection()) {
                this.roletable.setAllGrayed(true);
                this.roletable.getControl().setEnabled(false);
            }
            dtfeatures = new Feature[++deployfeaturecount];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("BasicAuth");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            this.wscfgsecuritylevel = 4;
        } else if (transportindex == httpsindex && this.basicauthbutton.getSelection() && this.basicauthbutton.getVisible()) {
            if (!this.authorcheckbox.getSelection()) {
                this.roletable.setAllGrayed(true);
                this.roletable.getControl().setEnabled(false);
            }
            dtfeatures = new Feature[deployfeaturecount += 2];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("BasicAuth");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            dtfeatures[1] = new FeatureImpl();
            dtfeatures[1].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("TLSType");
            properties[0].setValue("SSL");
            dtfeatures[1].setProperties(properties);
            ((FeatureImpl)dtfeatures[1]).setProtocol("SecurityProtocol");
            ((FeatureImpl)dtfeatures[1]).setIsDeployTimeFeature(true);
            this.wscfgsecuritylevel = 5;
        } else if (transportindex == httpsindex && this.certauthbutton.getSelection() && this.certauthbutton.getVisible()) {
            if (!this.authorcheckbox.getSelection()) {
                this.roletable.setAllGrayed(true);
                this.roletable.getControl().setEnabled(false);
            }
            dtfeatures = new Feature[deployfeaturecount += 2];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("CertAuth");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            dtfeatures[1] = new FeatureImpl();
            dtfeatures[1].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("TLSType");
            properties[0].setValue("SSL");
            dtfeatures[1].setProperties(properties);
            ((FeatureImpl)dtfeatures[1]).setProtocol("SecurityProtocol");
            ((FeatureImpl)dtfeatures[1]).setIsDeployTimeFeature(true);
            this.wscfgsecuritylevel = 9;
        } else if (transportindex == httpindex && this.certauthbutton.getSelection() && this.certauthbutton.getVisible()) {
            if (!this.authorcheckbox.getSelection()) {
                this.roletable.setAllGrayed(true);
                this.roletable.getControl().setEnabled(false);
            }
            dtfeatures = new Feature[++deployfeaturecount];
            dtfeatures[0] = new FeatureImpl();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("CertAuth");
            dtfeatures[0].setProperties(properties);
            ((FeatureImpl)dtfeatures[0]).setProtocol("SecurityProtocol");
            ((FeatureImpl)dtfeatures[0]).setIsDeployTimeFeature(true);
            this.wscfgsecuritylevel = 8;
        }
        if (this.isstateful) {
            dtfeatures[deployfeaturecount - 1] = new FeatureImpl();
            dtfeatures[deployfeaturecount - 1].setName("http://www.sap.com/webas/630/soap/features/session/");
            properties = new Property[]{new PropertyImpl()};
            properties[0].setName("SessionMethod");
            properties[0].setValue("httpCookies");
            dtfeatures[deployfeaturecount - 1].setProperties(properties);
            ((FeatureImpl)dtfeatures[deployfeaturecount - 1]).setIsDeployTimeFeature(true);
            ((FeatureImpl)dtfeatures[deployfeaturecount - 1]).setProtocol("HTTP_StatefulProtocol");
        }
        int index = this.authmechanism.getSelectionIndex();
        Property pt = this.findProperty(dtfeatures, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism");
        if (pt == null) {
            dtfeatures = this.addFeature(dtfeatures, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism", MECHANISM_NONE);
            ((FeatureImpl)dtfeatures[dtfeatures.length - 1]).setIsDeployTimeFeature(true);
            pt = dtfeatures[dtfeatures.length - 1].getProperties()[0];
        }
        if (index == this.httpmechanismindex) {
            pt.setValue("HTTP");
        } else if (index == this.docmechanismindex) {
            pt.setValue("Document");
        }
        return dtfeatures;
    }

    public void init() {
        if (this.canShowData) {
            int i;
            int i2;
            this.canhavedocauth = super.getConfiguration().getTransportBinding().getName().equals("SOAPHTTP_TransportBinding");
            VirtualInterface vi = WebServiceMdoResolver.getReferencedVi((String)super.getDeployData().getDescriptorProjectName(), (WebServiceDefinition)super.getDeployData().getWebServiceDefinition());
            if (vi == null) {
                this.canShowData = false;
                return;
            }
            int i3 = 0;
            while (i3 < this.configs.length) {
                Function f = vi.getFunction(this.configs[i3].getName());
                ((OperationConfigurationImpl)this.configs[i3]).setNameMappedTo(f.getNameMappedTo());
                ++i3;
            }
            this.features = super.getConfiguration().getGlobalFeatures();
            String[] s = new String[this.configs.length];
            this.tv.addSelectionListener((SelectionListener)this);
            int i4 = 0;
            while (i4 < this.configs.length) {
                s[i4] = ((OperationConfigurationImpl)this.configs[i4]).getNameMappedTo();
                ++i4;
            }
            this.tv.setItems(s);
            this.wscfgauthorizationselected = this.containsAuthorization(this.features);
            Feature[] designtime = WsConfigurationManager.getSelectedSoapFeatures(super.getDeployData(), super.getConfiguration());
            this.wsdauthorizationselected = this.containsAuthorization(designtime);
            this.initFeatures(this.features);
            if (this.configs.length > 0) {
                this.tv.setSelection(0);
                this.allroles = this.getSecurityRoles();
                i2 = 0;
                while (i2 < this.allroles.size()) {
                    this.roletable.add(this.allroles.elementAt(i2));
                    ++i2;
                }
                this.selectedrolesnames = ((OperationConfigurationImpl)this.configs[0]).getSecurityRoles();
                this.lastcheckedelements.clear();
                this.roletable.setAllChecked(false);
                i = 0;
                while (i < this.selectedrolesnames.size()) {
                    this.roletable.setChecked(this.selectedrolesnames.elementAt(i), true);
                    this.lastcheckedelements.add(this.selectedrolesnames.elementAt(i));
                    ++i;
                }
                String descr = this.ptim.getOutboundPolicyShortDescription(this.responsecombo.getText());
                if (descr != null) {
                    this.responselabel.setText(descr);
                }
                if ((descr = this.ptim.getInboundPolicyShortDescription(this.requestcombo.getText())) != null) {
                    this.requestlabel.setText(descr);
                }
            }
            i2 = 0;
            while (i2 < this.configs.length) {
                this.getPolicy(this.configs[i2], "RequestPolicy");
                this.getPolicy(this.configs[i2], "ResponsePolicy");
                ++i2;
            }
            this.authorcheckbox.setSelection(this.wscfgauthorizationselected && this.wscfgsecuritylevel > 1);
            this.authorcheckbox.setEnabled((this.wscfgsecuritylevel & 0xC) > 1 && !this.wsdauthorizationselected);
            this.norolepane.getComposite().setVisible(this.roletable.getCheckedElements().length == 0 && this.authorcheckbox.getSelection());
            i = 0;
            while (i < this.configs.length) {
                ((OperationConfigurationImpl)this.configs[i]).setSecurityRolesAllowed(this.authorcheckbox.getSelection());
                ++i;
            }
            this.roletable.getControl().setEnabled(this.authorcheckbox.getSelection());
            this.roletable.setAllGrayed(!this.authorcheckbox.getSelection());
            if (this.wsdauthorizationselected && !this.containsAuthorization(this.features)) {
                this.features = this.addAuthorization(this.features);
                super.notifyOfChange();
            }
        }
    }

    void initFeatures(Feature[] features) {
        int index;
        Feature[] wsdfeatures = WsConfigurationManager.getSelectedSoapFeatures(super.getDeployData(), super.getConfiguration());
        this.wsdsecuritylevel = WsConfigurationManager.getWSDSecurityLevel(wsdfeatures);
        this.wscfgsecuritylevel = WsConfigurationManager.getCfgSecurityLevel(features);
        Property pt = this.findProperty(features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism");
        this.basicauthbutton.setEnabled((this.wsdsecuritylevel & 0xC) < 8);
        this.certauthbutton.setEnabled((this.wscfgsecuritylevel & 3) > 0 || pt != null && pt.getValue().equals("Document"));
        if ((this.wsdsecuritylevel & 3) < 1 && (this.wscfgsecuritylevel & 0xC) < 8 || pt.getValue().equals("Document")) {
            this.transporttype.setItems(TRANSPORTS);
        } else {
            this.transporttype.setItems(HTTPS_TRANSPORT);
        }
        this.basicauthbutton.setSelection((this.wscfgsecuritylevel & 0xC) == 4);
        this.certauthbutton.setSelection((this.wscfgsecuritylevel & 0xC) == 8);
        if ((this.wsdsecuritylevel & 3) < 1 && (this.wscfgsecuritylevel & 0xC) < 8 || pt.getValue().equals("Document")) {
            if ((this.wscfgsecuritylevel & 3) < 1) {
                this.transporttype.select(0);
            } else {
                this.transporttype.select(1);
            }
        } else {
            this.transporttype.select(0);
        }
        this.setAuthenticationMechanismCombo();
        if (!this.transporttype.getText().equals("HTTPS") && this.certauthbutton.getSelection()) {
            pt.setValue("Document");
        }
        if ((this.wscfgsecuritylevel & 0xC) == 0) {
            if (this.nonemechanismindex > -1) {
                this.authmechanism.select(this.nonemechanismindex);
            }
        } else {
            if (pt == null) {
                features = this.addFeature(features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism", "HTTP");
                super.getConfiguration().setGlobalFeatures(features);
                pt = features[features.length - 1].getProperties()[0];
            }
            if (pt.getValue().equals("Document")) {
                if (this.docmechanismindex >= 0) {
                    this.authmechanism.select(this.docmechanismindex);
                } else {
                    this.authmechanism.select(0);
                }
            } else if (this.httpmechanismindex >= 0) {
                this.authmechanism.select(this.httpmechanismindex);
            }
        }
        this.basicauthbutton.setVisible((index = this.authmechanism.getSelectionIndex()) > this.nonemechanismindex);
        this.certauthbutton.setVisible(index > this.nonemechanismindex);
        this.acceptSAPticket.setVisible(index == this.httpmechanismindex);
        boolean enabled = !this.authmechanism.getText().equals(MECHANISM_NONE) && this.authorcheckbox.getSelection();
        this.roletable.getControl().setEnabled(enabled);
        this.roletable.setAllGrayed(!enabled);
        Feature f = this.getSSOFeature();
        Property p = f.getProperties()[0];
        if (p.getValue().equals("true")) {
            this.hassso = true;
            this.acceptSAPticket.setSelection(true);
        } else {
            this.hassso = false;
            this.acceptSAPticket.setSelection(false);
        }
        this.setInitialSelectedRadioButton();
    }

    public Control getControl() {
        this.checkWSDAndVI();
        VirtualInterface vi = WebServiceMdoResolver.getReferencedVi((String)super.getDeployData().getDescriptorProjectName(), (WebServiceDefinition)super.getDeployData().getWebServiceDefinition());
        this.configs = super.getConfiguration().getOperationConfigurations();
        int i = 0;
        while (i < this.configs.length) {
            Function f = vi.getFunction(this.configs[i].getName());
            if (f == null) {
                this.canShowData = false;
            }
            ++i;
        }
        try {
            IGridLayoutPane mainPane1 = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)3);
            if (this.canShowData) {
                IGridLayoutPane tpane = mainPane1.addGridLayoutPane(1, mainPane1.createGridLayoutData(4, 4, true, true, 2, 2));
                IGridLayoutPane generalpane = tpane.addGridLayoutPane(1, tpane.createGridLayoutData(4, 1, true, false, 1, 2));
                this.createTransportPane(generalpane);
                this.createAuthenticationPane(generalpane);
                this.mainPane = tpane.addGridLayoutPane(2, generalpane.createGridLayoutData(4, 4, true, true, 1, 1));
                this.createOperationListPane(tpane);
                this.norolepane = tpane.addGridLayoutPane(3, this.mainPane.createGridLayoutData(4, 3, true, false, 3, 1));
                this.norolelabel = this.norolepane.addTextLabel(WsUiTexts.getString("SecurityConfigurationPane.Warnings.noRoleSelected"), this.mainPane.createGridLayoutData(4, 3, true, false, 3, 1));
                this.setLabelColor(this.norolelabel);
                this.norolelabel.addPaintListener((PaintListener)this);
            } else {
                this.createErrorLabel(mainPane1);
            }
            return mainPane1.getComposite();
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$ws$editors$descriptor$ui$panes$SecurityConfigurationPane == null ? (class$com$sap$ide$ws$editors$descriptor$ui$panes$SecurityConfigurationPane = SecurityConfigurationPane.class$("com.sap.ide.ws.editors.descriptor.ui.panes.SecurityConfigurationPane")) : class$com$sap$ide$ws$editors$descriptor$ui$panes$SecurityConfigurationPane));
            return null;
        }
    }

    private void doSecurityLevelReset(SelectionEvent event) {
        if (event.widget == this.authmechanism || event.widget == this.basicauthbutton || event.widget == this.certauthbutton || event.widget == this.acceptSAPticket || event.widget == this.transporttype) {
            this.initFeatures(super.getConfiguration().getGlobalFeatures());
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(final SelectionEvent event) {
        if (event.widget != this.tv && event.widget != this.currentselectedbutton && !this.getParentPage().isInResetMode() && !this.getParentPage().isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName((String)this.getDeployData().getDescriptorProjectName())), new ResetPageStateI(){

            public void handleReset() {
                if (event.widget == SecurityConfigurationPane.this.authmechanism || event.widget == SecurityConfigurationPane.this.transporttype || event.widget == SecurityConfigurationPane.this.basicauthbutton || event.widget == SecurityConfigurationPane.this.certauthbutton || event.widget == SecurityConfigurationPane.this.acceptSAPticket) {
                    SecurityConfigurationPane.this.initFeatures(SecurityConfigurationPane.this.features);
                } else if (event.widget == SecurityConfigurationPane.this.authorcheckbox) {
                    SecurityConfigurationPane.this.authorcheckbox.setSelection(SecurityConfigurationPane.this.wscfgauthorizationselected && SecurityConfigurationPane.this.wscfgsecuritylevel > 1);
                    SecurityConfigurationPane.this.authorcheckbox.setEnabled((SecurityConfigurationPane.this.wscfgsecuritylevel & 0xC) > 1 && !SecurityConfigurationPane.this.wsdauthorizationselected);
                } else if (event.widget == SecurityConfigurationPane.this.requestcombo || event.widget == SecurityConfigurationPane.this.responsecombo || event.widget == SecurityConfigurationPane.this.roletable.getTable()) {
                    int index = SecurityConfigurationPane.this.tv.getSelectionCount();
                    SecurityConfigurationPane.this.selectedrolesnames = ((OperationConfigurationImpl)SecurityConfigurationPane.this.configs[index]).getSecurityRoles();
                    SecurityConfigurationPane.this.roletable.setAllChecked(false);
                    int i = 0;
                    while (i < SecurityConfigurationPane.this.selectedrolesnames.size()) {
                        SecurityConfigurationPane.this.roletable.setChecked(SecurityConfigurationPane.this.selectedrolesnames.elementAt(i), true);
                        ++i;
                    }
                    if (SecurityConfigurationPane.this.canhavedocauth) {
                        SecurityConfigurationPane.this.responsecombo.setItems(SecurityConfigurationPane.this.getPolicies("ResponsePolicy"));
                        SecurityConfigurationPane.this.requestcombo.setItems(SecurityConfigurationPane.this.getPolicies("RequestPolicy"));
                        SecurityConfigurationPane.this.responsecombo.setText(SecurityConfigurationPane.this.getPolicy(SecurityConfigurationPane.this.configs[index], "ResponsePolicy"));
                        SecurityConfigurationPane.this.requestcombo.setText(SecurityConfigurationPane.this.getPolicy(SecurityConfigurationPane.this.configs[index], "RequestPolicy"));
                        String descr = SecurityConfigurationPane.this.ptim.getOutboundPolicyShortDescription(SecurityConfigurationPane.this.responsecombo.getText());
                        if (descr != null) {
                            SecurityConfigurationPane.this.responselabel.setText(descr);
                        }
                        if ((descr = SecurityConfigurationPane.this.ptim.getInboundPolicyShortDescription(SecurityConfigurationPane.this.requestcombo.getText())) != null) {
                            SecurityConfigurationPane.this.requestlabel.setText(descr);
                        }
                    }
                }
            }
        })) {
            return;
        }
        this.adjustPageData((TypedEvent)event);
    }

    void adjustPageData(TypedEvent te) {
        if (te.widget == this.tv) {
            int selected = this.tv.getSelectionIndex();
            if (selected > -1) {
                this.selectedrolesnames = ((OperationConfigurationImpl)this.configs[this.tv.getSelectionIndex()]).getSecurityRoles();
                this.lastcheckedelements.clear();
                this.roletable.setAllChecked(false);
                int i = 0;
                while (i < this.selectedrolesnames.size()) {
                    this.roletable.setChecked(this.selectedrolesnames.elementAt(i), true);
                    this.lastcheckedelements.add(this.selectedrolesnames.elementAt(i));
                    ++i;
                }
                this.roletable.setAllGrayed(!this.authorcheckbox.getSelection());
                this.norolepane.getComposite().setVisible(this.roletable.getCheckedElements().length == 0 && this.authorcheckbox.getSelection());
                if (this.canhavedocauth) {
                    this.setPolicycombo(this.configs[selected], this.requestcombo, this.requestlabel, "RequestPolicy", true);
                    this.setPolicycombo(this.configs[selected], this.responsecombo, this.requestlabel, "ResponsePolicy", true);
                }
            }
        } else if (te.widget == this.acceptSAPticket) {
            this.hassso = this.acceptSAPticket.getSelection();
            this.setSSO(this.hassso);
            super.notifyOfChange();
        } else if (te.widget == this.basicauthbutton || te.widget == this.certauthbutton || te.widget == this.transporttype || te.widget == this.authmechanism) {
            Property p;
            if (te.widget == this.authmechanism) {
                String selection;
                int index = this.authmechanism.getSelectionIndex();
                this.basicauthbutton.setVisible(index > this.nonemechanismindex);
                this.certauthbutton.setVisible(index > this.nonemechanismindex);
                this.acceptSAPticket.setVisible(index == this.httpmechanismindex);
                p = this.findProperty(this.features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism");
                if (p == null) {
                    this.features = this.addFeature(this.features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism", MECHANISM_NONE);
                    super.getConfiguration().setGlobalFeatures(this.features);
                    p = this.features[this.features.length - 1].getProperties()[0];
                }
                if (index == this.nonemechanismindex) {
                    String transport = this.transporttype.getText();
                    this.transporttype.setItems(TRANSPORTS);
                    this.transporttype.setText(transport);
                } else if (index == this.httpmechanismindex) {
                    if (!this.basicauthbutton.getSelection() && !this.certauthbutton.getSelection()) {
                        this.basicauthbutton.setSelection(true);
                    }
                    selection = this.transporttype.getText();
                    boolean certenabled = this.transporttype.getText().equals("HTTPS");
                    this.certauthbutton.setEnabled(certenabled);
                    if (!certenabled) {
                        this.certauthbutton.setSelection(false);
                        this.basicauthbutton.setSelection(true);
                    }
                    if (this.certauthbutton.getSelection()) {
                        this.transporttype.setItems(HTTPS_TRANSPORT);
                        this.transporttype.setText(selection);
                    }
                    p.setValue("HTTP");
                } else if (index == this.docmechanismindex) {
                    if (!(this.basicauthbutton.getSelection() || this.certauthbutton.getSelection() || this.acceptSAPticket.getSelection())) {
                        this.basicauthbutton.setSelection(true);
                    }
                    selection = this.transporttype.getText();
                    this.transporttype.setItems(TRANSPORTS);
                    this.transporttype.setText(selection);
                    this.certauthbutton.setEnabled(true);
                    p.setValue("Document");
                }
                this.certauthbutton.setEnabled(this.transporttype.getText().equals("HTTPS") || p.getValue().equals("Document"));
                if (!this.certauthbutton.getVisible()) {
                    selection = this.authmechanism.getText();
                    this.nonemechanismindex = 0;
                    this.httpmechanismindex = 1;
                    if (this.canhavedocauth) {
                        this.authmechanism.setItems(MECHANISMS);
                        this.docmechanismindex = 2;
                    } else {
                        this.authmechanism.setItems(HTTP_AND_NONE);
                        this.docmechanismindex = -1;
                    }
                    this.authmechanism.setText(selection);
                }
            }
            if (te.widget == this.transporttype) {
                String transport = this.transporttype.getText();
                this.certauthbutton.setEnabled(transport.equals("HTTPS") || this.authmechanism.getSelectionIndex() == this.docmechanismindex);
                String mechanismtext = this.authmechanism.getText();
                this.setAuthenticationMechanismCombo();
                this.authmechanism.setText(mechanismtext);
            }
            if (te.widget == this.certauthbutton) {
                int index = this.transporttype.getSelectionIndex();
                p = this.findProperty(this.features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism");
                if (p == null) {
                    this.features = this.addFeature(this.features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism", "Document");
                    super.getConfiguration().setGlobalFeatures(this.features);
                    p = this.features[this.features.length - 1].getProperties()[0];
                }
                if (!p.getValue().equals("Document")) {
                    this.transporttype.setItems(HTTPS_TRANSPORT);
                    if (index > this.transporttype.getItemCount() - 1) {
                        this.transporttype.select(0);
                    } else {
                        this.transporttype.select(index);
                    }
                }
                if (!this.transporttype.getText().equals("HTTPS")) {
                    if ((this.wsdsecuritylevel & 0xC) > 0) {
                        this.authmechanism.setItems(DOCUMENT_MECHANISM);
                        this.nonemechanismindex = -2;
                        this.httpmechanismindex = -1;
                        this.docmechanismindex = 0;
                        this.authmechanism.select(0);
                    } else {
                        this.authmechanism.setItems(DOC_AND_NONE_MECHANISMS);
                        this.nonemechanismindex = 0;
                        this.httpmechanismindex = -1;
                        this.docmechanismindex = 1;
                        this.authmechanism.select(1);
                    }
                } else if (this.authmechanism.getSelectionIndex() != this.docmechanismindex) {
                    this.transporttype.setItems(HTTPS_TRANSPORT);
                    this.transporttype.select(0);
                }
            } else if (te.widget == this.basicauthbutton) {
                String mechanismtext = this.authmechanism.getText();
                if ((this.wsdsecuritylevel & 0xC) == 0) {
                    this.nonemechanismindex = 0;
                    this.httpmechanismindex = 1;
                    if (this.canhavedocauth) {
                        this.authmechanism.setItems(MECHANISMS);
                        this.docmechanismindex = 2;
                    } else {
                        this.authmechanism.setItems(HTTP_AND_NONE);
                        this.docmechanismindex = -1;
                    }
                } else {
                    this.nonemechanismindex = -1;
                    this.httpmechanismindex = 0;
                    if (this.canhavedocauth) {
                        this.authmechanism.setItems(AUTH_MECHANISMS);
                        this.docmechanismindex = 1;
                    } else {
                        this.authmechanism.setItems(HTTP_MECHANISM);
                        this.docmechanismindex = -1;
                    }
                }
                this.authmechanism.setText(mechanismtext);
                if ((this.wsdsecuritylevel & 3) < 1) {
                    int index = this.transporttype.getItemCount() - this.transporttype.getSelectionIndex();
                    this.transporttype.setItems(TRANSPORTS);
                    this.transporttype.select(this.transporttype.getItemCount() - index);
                }
            }
            if (te.widget != this.currentselectedbutton) {
                this.isstateful = this.containsSessionFeature(this.features);
                this.features = this.createDeployTimeFeatures();
                this.authorcheckbox.setSelection((this.wscfgauthorizationselected || this.wsdauthorizationselected) && this.wscfgsecuritylevel > 1);
                this.authorcheckbox.setEnabled((this.wscfgsecuritylevel & 0xC) > 1 && !this.wsdauthorizationselected);
                this.norolepane.getComposite().setVisible(this.roletable.getCheckedElements().length == 0 && this.authorcheckbox.getSelection());
                int i = 0;
                while (i < this.configs.length) {
                    ((OperationConfigurationImpl)this.configs[i]).setSecurityRolesAllowed(this.authorcheckbox.getSelection());
                    ++i;
                }
                boolean enabled = !this.authmechanism.getText().equals(MECHANISM_NONE) && this.authorcheckbox.getSelection();
                this.roletable.setAllGrayed(!enabled);
                this.roletable.getControl().setEnabled(enabled);
                if (this.wscfgsecuritylevel < 1 || !this.wscfgauthorizationselected) {
                    super.getConfiguration().setGlobalFeatures(this.removeAuthorization(this.features));
                } else if (this.wscfgsecuritylevel > 0 && (this.wscfgauthorizationselected || this.wsdauthorizationselected)) {
                    super.getConfiguration().setGlobalFeatures(this.addAuthorization(this.features));
                } else {
                    super.getConfiguration().setGlobalFeatures(this.features);
                }
                if (this.putsso) {
                    this.setSSO(this.hassso);
                }
                if (te.widget instanceof Button) {
                    this.currentselectedbutton = (Button)te.widget;
                }
                this.norolepane.getComposite().setVisible(this.roletable.getCheckedElements().length == 0 && this.authorcheckbox.getSelection());
                int configindex = this.tv.getSelectionIndex();
                if (configindex >= 0 && this.canhavedocauth) {
                    this.setPolicycombo(this.configs[configindex], this.requestcombo, this.requestlabel, "RequestPolicy", false);
                    this.setPolicycombo(this.configs[configindex], this.responsecombo, this.responselabel, "ResponsePolicy", false);
                }
                super.notifyOfChange();
            }
        } else if (te.widget == this.authorcheckbox) {
            this.wscfgauthorizationselected = this.authorcheckbox.getSelection();
            if (!this.wsdauthorizationselected) {
                if (this.wscfgauthorizationselected) {
                    super.getConfiguration().setGlobalFeatures(this.addAuthorization(super.getConfiguration().getGlobalFeatures()));
                } else {
                    super.getConfiguration().setGlobalFeatures(this.removeAuthorization(super.getConfiguration().getGlobalFeatures()));
                }
            }
            boolean enabled = !this.authmechanism.getText().equals(MECHANISM_NONE) && this.authorcheckbox.getSelection();
            this.roletable.setAllGrayed(!enabled);
            this.roletable.getControl().setEnabled(enabled);
            int i = 0;
            while (i < this.configs.length) {
                ((OperationConfigurationImpl)this.configs[i]).setSecurityRolesAllowed(this.authorcheckbox.getSelection());
                ++i;
            }
            this.norolepane.getComposite().setVisible(this.roletable.getCheckedElements().length == 0 && this.authorcheckbox.getSelection());
            super.notifyOfChange();
        } else if (te.widget == this.requestcombo) {
            String descr;
            int index = this.tv.getSelectionIndex();
            if (index > -1) {
                this.setPolicy(this.configs[index], "RequestPolicy", this.requestcombo.getText());
            }
            if ((descr = this.ptim.getInboundPolicyShortDescription(this.requestcombo.getText())) != null) {
                this.requestlabel.setText(descr);
            }
            super.notifyOfChange();
        } else if (te.widget == this.responsecombo) {
            String descr;
            int index = this.tv.getSelectionIndex();
            if (index > -1) {
                this.setPolicy(this.configs[index], "ResponsePolicy", this.responsecombo.getText());
            }
            if ((descr = this.ptim.getOutboundPolicyShortDescription(this.responsecombo.getText())) != null) {
                this.responselabel.setText(descr);
            }
            super.notifyOfChange();
        }
    }

    public Vector getSecurityRoles() {
        Vector<String> v = new Vector<String>();
        WSConfigurationImpl cfg = (WSConfigurationImpl)super.getConfiguration();
        if (!cfg.getIsJavaClass()) {
            DeploymentConfiguration dcfg = super.getDeployData();
            String[] s = dcfg.getSecurityRoles();
            int i = 0;
            while (i < s.length) {
                v.add(s[i]);
                ++i;
            }
        } else {
            JavaClassSecurityRole[] roles = cfg.getJavaSecurityRoles();
            int i = 0;
            while (i < roles.length) {
                v.add(roles[i].getName());
                ++i;
            }
        }
        return v;
    }

    private Vector getSecurityRoles(OperationConfiguration operation) {
        String s;
        Property prop = this.findProperty(operation);
        if (prop != null) {
            s = prop.getValue();
        }
        s = "";
        StringTokenizer st = new StringTokenizer(s);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    private Property findProperty(OperationConfiguration operation) {
        Property[] props;
        Feature feature = this.findFeature(operation);
        if (feature != null && (props = feature.getProperties()) != null) {
            int k = 0;
            while (k < props.length) {
                if ("user-role".equals(props[k].getName())) {
                    return props[k];
                }
                ++k;
            }
        }
        return null;
    }

    private Feature findFeature(OperationConfiguration operation) {
        Feature[] oldFeatures = operation.getFeatures();
        if (oldFeatures != null) {
            int j = 0;
            while (j < oldFeatures.length) {
                if ("http://sap.com/security".equals(oldFeatures[j].getName())) {
                    return oldFeatures[j];
                }
                ++j;
            }
        }
        return null;
    }

    private Property[] getNewProperties(Property[] oldProps, String roles) {
        Property[] newProps = new Property[oldProps.length + 1];
        System.arraycopy(oldProps, 0, newProps, 0, oldProps.length);
        newProps[newProps.length - 1] = new PropertyImpl();
        newProps[newProps.length - 1].setName("user-role");
        newProps[newProps.length - 1].setValue(roles);
        return newProps;
    }

    private void setSecurityRoles(OperationConfiguration operation, String roles) {
        Feature feature = this.findFeature(operation);
        if (feature != null) {
            Property prop = this.findProperty(operation);
            if (prop != null) {
                prop.setValue(roles);
            } else {
                feature.setProperties(this.getNewProperties(feature.getProperties(), roles));
            }
        } else {
            Feature[] oldFeatures = operation.getFeatures();
            Feature[] newFeatures = new Feature[oldFeatures.length + 1];
            System.arraycopy(oldFeatures, 0, newFeatures, 0, oldFeatures.length);
            newFeatures[newFeatures.length - 1] = new FeatureImpl();
            newFeatures[newFeatures.length - 1].setName("http://sap.com/security");
            newFeatures[newFeatures.length - 1].setProperties(this.getNewProperties(new Property[0], roles));
            operation.setFeatures(newFeatures);
        }
    }

    boolean containsSessionFeature(Feature[] features) {
        int i = 0;
        while (i < features.length) {
            if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/session/")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean mustRemoveSecurityRoles() {
        return this.authmechanism.getText().equals(MECHANISM_NONE) || !this.authorcheckbox.getSelection();
    }

    public void updatePage() {
    }

    public boolean mustAddSecurityRoles() {
        return !this.authmechanism.getText().equals(MECHANISM_NONE) || !this.authorcheckbox.getSelection();
    }

    public void setInitialSelectedRadioButton() {
        if (this.basicauthbutton.getSelection()) {
            this.currentselectedbutton = this.basicauthbutton;
        } else if (this.certauthbutton.getSelection()) {
            this.currentselectedbutton = this.certauthbutton;
        } else if (this.acceptSAPticket.getSelection()) {
            this.currentselectedbutton = this.acceptSAPticket;
        }
    }

    boolean containsAuthorization(Feature[] f) {
        int i = 0;
        while (i < f.length) {
            if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/authorization")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Feature[] addAuthorization(Feature[] f) {
        if (!this.containsAuthorization(f)) {
            Feature[] f1 = new Feature[f.length + 1];
            System.arraycopy(f, 0, f1, 0, f.length);
            f1[f.length] = new FeatureImpl();
            f1[f.length].setName("http://www.sap.com/webas/630/soap/features/authorization");
            f1[f.length].setProtocol("SecurityProtocol");
            return f1;
        }
        return f;
    }

    Feature[] removeAuthorization(Feature[] f) {
        if (this.containsAuthorization(f)) {
            Feature[] f1 = new Feature[f.length - 1];
            int j = 0;
            boolean found = false;
            int i = 0;
            while (i < f.length) {
                if (!f[i].getName().equals("http://www.sap.com/webas/630/soap/features/authorization") || found) {
                    f1[j] = f[i];
                    ++j;
                } else {
                    found = true;
                }
                ++i;
            }
            return f1;
        }
        return f;
    }

    public void createTransportPane(IGridLayoutPane parent) {
        IGridLayoutPane transportpane = parent.addGridLayoutPane(WsUiTexts.getString("SecuriytConfigurationPane.Labels.transport"), 2, parent.createGridLayoutData(4, 4, true, true, 1, 2));
        transportpane.addTextLabel(WsUiTexts.getString("SecuriytConfigurationPane.Labels.transportprotocol"));
        this.transporttype = transportpane.addComboBox(TRANSPORTS, true);
        this.transporttype.addSelectionListener((SelectionListener)this);
    }

    public void createAuthenticationPane(IGridLayoutPane parent) {
        IGridLayoutPane authpane = parent.addGridLayoutPane(WsUiTexts.getString("SecuriytConfigurationPane.Labels.authentication"), 3, parent.createGridLayoutData(4, 4, true, true, 1, 2));
        authpane.addTextLabel(WsUiTexts.getString("SecuriytConfigurationPane.Labels.authenticationmechanism"), parent.createGridLayoutData(1, 4, false, true, 1, 1));
        this.authmechanism = authpane.addComboBox(new String[0], "", true, parent.createGridLayoutData(4, 4, true, true, 1, 1));
        this.authmechanism.addSelectionListener((SelectionListener)this);
        this.basicauthbutton = authpane.addRadioButton(WsUiTexts.getString("SecuriytConfigurationPane.Labels.basicauth"), parent.createGridLayoutData(4, 4, true, true, 3, 1));
        this.certauthbutton = authpane.addRadioButton(WsUiTexts.getString("SecuriytConfigurationPane.Labels.certauth"), parent.createGridLayoutData(4, 4, true, true, 3, 1));
        this.acceptSAPticket = authpane.addCheckBox(WsUiTexts.getString("SecuriytConfigurationPane.Labels.acceptsapticket"), false, parent.createGridLayoutData(4, 4, true, true, 3, 1));
        this.basicauthbutton.addSelectionListener((SelectionListener)this);
        this.certauthbutton.addSelectionListener((SelectionListener)this);
        this.acceptSAPticket.addSelectionListener((SelectionListener)this);
    }

    public void createOperationListPane(IGridLayoutPane parent) {
        IGridLayoutPane authpane = parent.addGridLayoutPane(3, parent.createGridLayoutData(4, 4, true, true, 1, 5));
        IGridLayoutPane operationspane = authpane.addGridLayoutPane(WsUiTexts.getString("SecurityConfigurationPane.Labels.operations"), 1, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 2));
        this.tv = operationspane.addList(new String[0], false, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 2));
        this.tv.addPaintListener((PaintListener)this);
        ITabbedPane tpane = authpane.addTabbedPane(this.mainPane.createGridLayoutData(4, 4, true, true, 2, 2));
        IGridLayoutPane authtab = tpane.addGridLayoutPaneAsTab(WsUiTexts.getString("SecurityConfigurationPane.Labels.authorization"), 1);
        IGridLayoutPane securitytab = tpane.addGridLayoutPaneAsTab(WsUiTexts.getString("SecurityConfigurationPane.Labels.docsecurity"), 1);
        this.authorcheckbox = authtab.addCheckBox(WsUiTexts.getString("SecurityConfigurationPane.Labels.useAuthorization"));
        this.authorcheckbox.addSelectionListener((SelectionListener)this);
        this.roletable = authtab.addCheckboxTableViewer(false, this.mainPane.createGridLayoutData(4, 4, true, true, 2, 2));
        this.roletable.addSelectionChangedListener((ISelectionChangedListener)this);
        int selected = this.tv.getSelectionIndex();
        if (selected > -1) {
            this.selectedrolesnames = ((OperationConfigurationImpl)this.configs[selected]).getSecurityRoles();
            this.allroles = this.getSecurityRoles();
            int i = 0;
            while (i < this.allroles.size()) {
                this.roletable.add(this.allroles.elementAt(i));
                ++i;
            }
        }
        IGridLayoutPane sectabpane = securitytab.addGridLayoutPane(1, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 3));
        IGridLayoutPane requestpane = sectabpane.addGridLayoutPane(WsUiTexts.getString("SecurityConfigurationPane.Labels.request"), 1, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 3));
        this.requestcombo = requestpane.addComboBox(new String[0], "", true, this.mainPane.createGridLayoutData(4, 4, true, false, 2, 1));
        this.requestcombo.addSelectionListener((SelectionListener)this);
        this.requestlabel = requestpane.addTextPane("", true, true, this.mainPane.createGridLayoutData(4, 4, true, true, 2, 1));
        IGridLayoutPane responsepane = sectabpane.addGridLayoutPane(WsUiTexts.getString("SecurityConfigurationPane.Labels.response"), 1, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 3));
        this.responsecombo = responsepane.addComboBox(new String[0], "", true, this.mainPane.createGridLayoutData(4, 4, true, false, 2, 1));
        this.responsecombo.addSelectionListener((SelectionListener)this);
        this.responselabel = responsepane.addTextPane("", true, true, this.mainPane.createGridLayoutData(4, 4, true, true, 2, 1));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        block8: {
            if (this.getParentPage().isInResetMode()) break block8;
            if (!this.getParentPage().isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName((String)this.getDeployData().getDescriptorProjectName())), new ResetPageStateI(){

                public void handleReset() {
                    int index = SecurityConfigurationPane.this.tv.getSelectionCount();
                    SecurityConfigurationPane.this.selectedrolesnames = ((OperationConfigurationImpl)SecurityConfigurationPane.this.configs[index]).getSecurityRoles();
                    SecurityConfigurationPane.this.roletable.setAllChecked(false);
                    int i = 0;
                    while (i < SecurityConfigurationPane.this.selectedrolesnames.size()) {
                        SecurityConfigurationPane.this.roletable.setChecked(SecurityConfigurationPane.this.selectedrolesnames.elementAt(i), true);
                        ++i;
                    }
                }
            })) {
                return;
            }
            Object[] elements = this.roletable.getCheckedElements();
            this.selectedrolesnames.clear();
            int i = 0;
            while (i < elements.length) {
                this.selectedrolesnames.add(elements[i]);
                ++i;
            }
            this.norolepane.getComposite().setVisible(this.roletable.getCheckedElements().length == 0 && this.authorcheckbox.getSelection());
            if (this.selectedrolesnames.size() != this.lastcheckedelements.size()) {
                super.notifyOfChange();
                this.lastcheckedelements.clear();
                int j = 0;
                while (j < this.selectedrolesnames.size()) {
                    this.lastcheckedelements.add(this.selectedrolesnames.elementAt(j));
                    ++j;
                }
            } else {
                int i2 = 0;
                while (i2 < this.selectedrolesnames.size()) {
                    if (!this.lastcheckedelements.contains(this.selectedrolesnames.elementAt(i2))) {
                        super.notifyOfChange();
                        this.lastcheckedelements.clear();
                        int j = 0;
                        while (j < this.selectedrolesnames.size()) {
                            this.lastcheckedelements.add(this.selectedrolesnames.elementAt(j));
                            ++j;
                        }
                        break;
                    }
                    ++i2;
                }
            }
        }
    }

    public Feature getWSSecurityFeature(OperationConfiguration cfg) {
        Feature[] f = cfg.getFeatures();
        FeatureImpl f1 = null;
        int i = 0;
        while (i < f.length) {
            if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/wss")) {
                f1 = f[i];
            }
            ++i;
        }
        if (f1 == null) {
            f1 = new FeatureImpl();
            f1.setName("http://www.sap.com/webas/630/soap/features/wss");
            f1.setProtocol("SecurityProtocol");
            Feature[] f2 = new Feature[f.length + 1];
            System.arraycopy(f, 0, f2, 0, f.length);
            f2[f.length] = f1;
            cfg.setFeatures(f2);
        }
        return f1;
    }

    public void setPolicy(OperationConfiguration cfg, String policytype, String policyname) {
        Feature f = this.getWSSecurityFeature(cfg);
        Property[] p = f.getProperties();
        PropertyImpl requestp = null;
        int i = 0;
        while (i < p.length) {
            if (p[i].getName().equals(policytype)) {
                requestp = p[i];
            }
            ++i;
        }
        if (requestp == null) {
            requestp = new PropertyImpl();
            requestp.setName(policytype);
        }
        requestp.setValue(policyname);
    }

    public String getPolicy(OperationConfiguration cfg, String policytype) {
        Feature f = this.getWSSecurityFeature(cfg);
        Property[] p = f.getProperties();
        Property p1 = null;
        int i = 0;
        while (i < p.length) {
            if (p[i].getName().equals(policytype)) {
                p1 = p[i];
            }
            ++i;
        }
        if (p1 == null) {
            Property[] p2 = new Property[p.length + 1];
            System.arraycopy(p, 0, p2, 0, p.length);
            p1 = new PropertyImpl();
            p1.setName(policytype);
            p1.setValue(this.getDefaultPolicyName(policytype));
            p2[p.length] = p1;
            f.setProperties(p2);
        }
        if (p1.getValue().equals("")) {
            p1.setValue(this.getDefaultPolicyName(policytype));
        }
        return p1.getValue();
    }

    public String getDefaultPolicyName(String policytype) {
        String policygroup = this.getPolicyGroup();
        List policies = null;
        if (policytype.equals("RequestPolicy")) {
            policies = this.ptim.getInboundPolicyNamesByFeature(policygroup);
        } else if (policytype.equals("ResponsePolicy")) {
            policies = this.ptim.getOutboundPolicyNamesByFeature("AUTHENTICATION_NONE");
        }
        return (String)policies.get(0);
    }

    public String[] getPolicies(String policytype) {
        String policygroup = this.getPolicyGroup();
        List policies = null;
        if (policytype.equals("RequestPolicy")) {
            policies = this.ptim.getInboundPolicyNamesByFeature(policygroup);
        } else if (policytype.equals("ResponsePolicy")) {
            policies = this.ptim.getOutboundPolicyNamesByFeature("AUTHENTICATION_NONE");
        }
        String[] s = new String[policies.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = (String)policies.get(i);
            ++i;
        }
        return s;
    }

    public void setPolicycombo(OperationConfiguration cfg, Combo combo, Text description, String policytype, boolean initial) {
        int policyindex = -1;
        String policy = this.getPolicy(cfg, policytype);
        String[] policies = this.getPolicies(policytype);
        int i = 0;
        while (i < policies.length) {
            if (policy.equals(policies[i])) {
                policyindex = i;
            }
            ++i;
        }
        combo.setItems(policies);
        if (policyindex == -1) {
            if (initial) {
                combo.add(policy);
                policyindex = combo.getItemCount() - 1;
            } else {
                policyindex = 0;
                String[] inbound = this.getPolicies("RequestPolicy");
                String[] outbound = this.getPolicies("ResponsePolicy");
                int i2 = 0;
                while (i2 < this.configs.length) {
                    boolean found = false;
                    String cfgpolicy = this.getPolicy(this.configs[i2], "RequestPolicy");
                    int j = 0;
                    while (j < inbound.length) {
                        if (cfgpolicy.equals(inbound[j])) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        this.setPolicy(this.configs[i2], "RequestPolicy", inbound[0]);
                    }
                    found = false;
                    cfgpolicy = this.getPolicy(this.configs[i2], "ResponsePolicy");
                    int j2 = 0;
                    while (j2 < outbound.length) {
                        if (cfgpolicy.equals(outbound[j2])) {
                            found = true;
                            break;
                        }
                        ++j2;
                    }
                    if (!found) {
                        this.setPolicy(this.configs[i2], "ResponsePolicy", outbound[0]);
                    }
                    ++i2;
                }
            }
        }
        combo.select(policyindex);
        this.requestlabel.setText(this.ptim.getInboundPolicyShortDescription(this.getPolicy(cfg, "RequestPolicy")));
        this.responselabel.setText(this.ptim.getOutboundPolicyShortDescription(this.getPolicy(cfg, "ResponsePolicy")));
    }

    public Feature getSSOFeature() {
        Property[] p;
        FeatureImpl f = null;
        int i = 0;
        while (i < this.features.length) {
            if (this.features[i].getName().equals("http://www.sap.com/webas/630/soap/features/authentication")) {
                p = this.features[i].getProperties();
                int j = 0;
                while (j < p.length) {
                    if (p[j].getName().equals("SupportsSSO2Authentication")) {
                        f = this.features[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (f == null) {
            f = new FeatureImpl();
            f.setName("http://www.sap.com/webas/630/soap/features/authentication");
            f.setProtocol("SecurityProtocol");
            p = new Property[]{new PropertyImpl()};
            p[0].setName("SupportsSSO2Authentication");
            p[0].setValue("false");
            f.setProperties(p);
            Feature[] f1 = new Feature[this.features.length + 1];
            System.arraycopy(this.features, 0, f1, 0, this.features.length);
            f1[this.features.length] = f;
            this.features = f1;
            super.getConfiguration().setGlobalFeatures(this.features);
        }
        return f;
    }

    public void setSSO(boolean state) {
        Property p = this.findProperty(super.getConfiguration().getGlobalFeatures(), "http://www.sap.com/webas/630/soap/features/authentication", "SupportsSSO2Authentication");
        if (p == null) {
            this.features = this.addFeature(super.getConfiguration().getGlobalFeatures(), "http://www.sap.com/webas/630/soap/features/authentication", "SupportsSSO2Authentication", "false");
            p = this.features[this.features.length - 1].getProperties()[0];
            super.getConfiguration().setGlobalFeatures(this.features);
        }
        p.setValue("" + state);
    }

    private Property findProperty(Feature[] features, String featurename, String propertyname) {
        int i = 0;
        while (i < features.length) {
            if (features[i].getName().equals(featurename)) {
                Property[] props = features[i].getProperties();
                int j = 0;
                while (j < props.length) {
                    if (props[j].getName().equals(propertyname)) {
                        return props[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public Feature[] addFeature(Feature[] source, String name, String propname, String propvalue) {
        FeatureImpl ft = new FeatureImpl();
        Property[] props = new Property[]{new PropertyImpl()};
        props[0].setName(propname);
        props[0].setValue(propvalue);
        ft.setName(name);
        ft.setProperties(props);
        Feature[] features = new Feature[source.length + 1];
        System.arraycopy(source, 0, features, 0, source.length);
        features[source.length] = ft;
        return features;
    }

    public void paintControl(PaintEvent e) {
        if (e.widget instanceof Label) {
            Label l = (Label)e.widget;
            this.setLabelColor(l);
        } else if (e.widget == this.tv) {
            if (this.configs.length > 0 && this.canhavedocauth) {
                this.requestcombo.setItems(this.getPolicies("RequestPolicy"));
                this.responsecombo.setItems(this.getPolicies("ResponsePolicy"));
                this.setPolicycombo(this.configs[0], this.requestcombo, this.requestlabel, "RequestPolicy", true);
                this.setPolicycombo(this.configs[0], this.responsecombo, this.responselabel, "ResponsePolicy", true);
            } else {
                this.requestcombo.setItems(new String[0]);
                this.requestcombo.setEnabled(false);
                this.responsecombo.setItems(new String[0]);
                this.responsecombo.setEnabled(false);
            }
            this.tv.removePaintListener((PaintListener)this);
        }
    }

    String getPolicyGroup() {
        String policygroup = "";
        if (this.authmechanism.getText().equals(MECHANISM_NONE)) {
            policygroup = "AUTHENTICATION_NONE";
        } else if (this.authmechanism.getText().equals(MECHANISM_HTTP)) {
            if (this.basicauthbutton.getSelection()) {
                policygroup = "AUTHENTICATION_TRANSPORT_SECURITY_USERNAME";
            } else if (this.certauthbutton.getSelection()) {
                policygroup = "AUTHENTICATION_TRANSPORT_SECURITY_CERTIFICATE";
            }
        } else if (this.authmechanism.getText().equals(MECHANISM_DOCUMENT)) {
            if (this.basicauthbutton.getSelection()) {
                policygroup = "AUTHENTICATION_MESSAGE_SECURITY_USERNAME";
            } else if (this.certauthbutton.getSelection()) {
                policygroup = "AUTHENTICATION_MESSAGE_SECURITY_CERTIFICATE";
            }
        }
        return policygroup;
    }

    private void setAuthenticationMechanismCombo() {
        if (!this.transporttype.getText().equals("HTTPS") && this.certauthbutton.getSelection() && this.certauthbutton.getVisible()) {
            if ((this.wscfgsecuritylevel & 0xC) > 0) {
                if (this.canhavedocauth) {
                    this.authmechanism.setItems(DOCUMENT_MECHANISM);
                    this.nonemechanismindex = -2;
                    this.httpmechanismindex = -1;
                    this.docmechanismindex = 0;
                    this.authmechanism.select(0);
                }
            } else if (this.canhavedocauth) {
                this.authmechanism.setItems(DOC_AND_NONE_MECHANISMS);
                this.nonemechanismindex = 0;
                this.httpmechanismindex = -1;
                this.docmechanismindex = 1;
                this.authmechanism.select(1);
            }
        } else if ((this.wscfgsecuritylevel & 0xC) == 0) {
            this.nonemechanismindex = 0;
            this.httpmechanismindex = 1;
            if (this.canhavedocauth) {
                this.authmechanism.setItems(MECHANISMS);
                this.docmechanismindex = 2;
            } else {
                this.authmechanism.setItems(HTTP_AND_NONE);
                this.docmechanismindex = -1;
            }
        } else {
            this.nonemechanismindex = -1;
            this.httpmechanismindex = 0;
            if (this.canhavedocauth) {
                this.authmechanism.setItems(AUTH_MECHANISMS);
                this.docmechanismindex = 1;
            } else {
                this.authmechanism.setItems(HTTP_MECHANISM);
                this.docmechanismindex = -1;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

