/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.descriptor.ui.panes;

import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.cfg.DeploymentConfiguration;
import com.sap.ide.ws.configuration.WsConfigurationManager;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.core.editors.FileReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.editors.descriptor.ui.panes.WsDDGenericEditorPane;
import com.sap.ide.ws.soapapp.SoapAppToolPlugin;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.wizards.descriptor.wscfg.pages.NewCfgPage;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.Feature;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.Property;
import com.sap.ide.ws.wsddman.TransportAddress;
import com.sap.ide.ws.wsddman.TransportBinding;
import com.sap.ide.ws.wsddman.WebService;
import com.sap.ide.ws.wsddman.impl0.OperationConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.TransportAddressImpl;
import com.sap.ide.ws.wsddman.impl0.TransportBindingImpl;
import com.sap.ide.ws.wsddman.impl0.WSConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.WebServiceImpl;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class OverviewPane
extends WsDDGenericEditorPane
implements SelectionListener,
ModifyListener {
    private static final Image OPERATION_ICON = SoapAppToolPlugin.getImage((String)"config_wizard/operation1.gif");
    public static final String OVERVIEW_TEXT = WsUiTexts.getString("OverviewPane.Labels.title");
    private static final String DOCUMENTATION = WsUiTexts.getString("OverviewPane.Documentation.line1") + "\n" + WsUiTexts.getString("OverviewPane.Documentation.line2");
    private ISelection selection;
    private IGridLayoutPane mainPane = null;
    private IGridLayoutPane updatepane = null;
    private Text configname;
    private String transportbinding;
    private Text targetaddress = null;
    private boolean defaultmodification = false;
    private Button editdocbutton = null;
    private Button updatebutton = null;
    private Text wsdname;
    private Text authentleveltext;
    private Text authorleveltext;
    private Text trguaranteetext;
    private Text beanname;
    private Text sessionhandling;
    private WebServiceDefinition wsd = null;

    public OverviewPane(Composite parentComposite, EditorItemI parentEditorItem, DeploymentConfiguration dpcfg, Configuration cfg) {
        super(parentComposite, parentEditorItem, dpcfg, cfg);
    }

    public OverviewPane(EditorItemI parentEditorItem, DeploymentConfiguration dpcfg, Configuration cfg) {
        super(parentEditorItem, dpcfg, cfg);
    }

    public void init() {
        if (this.canShowData) {
            this.transportbinding = ((TransportBindingImpl)super.getConfiguration().getTransportBinding()).getName();
            VirtualInterface vi = WebServiceMdoResolver.getReferencedVi((String)super.getDeployData().getDescriptorProjectName(), (WebServiceDefinition)super.getDeployData().getWebServiceDefinition());
            this.defaultmodification = true;
            this.targetaddress.setText(super.getConfiguration().getTransportAddress().getName());
            this.targetaddress.addModifyListener((ModifyListener)this);
            this.defaultmodification = false;
            String projectname = super.getDeploymentConfiguration().getDescriptorProjectName();
            Configuration cfg = super.getConfiguration();
            WebService ws = ((WSConfigurationImpl)cfg).getParent();
            String wsname = ((WebServiceImpl)ws).getInternalName();
            this.updatepane.getComposite().setVisible(!this.checkConsistency(cfg));
            this.wsd = super.getDeployData().getWebServiceDefinition();
            Feature[] f = WsConfigurationManager.getSelectedSoapFeatures(super.getDeployData(), super.getConfiguration());
            this.authorleveltext.setText(WsCoreUiTexts.getString((String)"WsCore.Labels.General.no"));
            this.trguaranteetext.setText("No");
            this.authentleveltext.setText("Basic");
            this.sessionhandling.setText(WsUiTexts.getString("WsDefinitionPane.Labels.stateless"));
            int i = 0;
            while (i < f.length) {
                int j;
                Property[] properties;
                if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/transportguarantee")) {
                    properties = f[i].getProperties();
                    j = 0;
                    while (j < properties.length) {
                        if (properties[j].getName().equals("Level")) {
                            this.trguaranteetext.setText(properties[j].getValue());
                        }
                        ++j;
                    }
                } else if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/authentication")) {
                    properties = f[i].getProperties();
                    j = 0;
                    while (j < properties.length) {
                        if (properties[j].getName().equals("AuthenticationLevel")) {
                            this.authentleveltext.setText(properties[j].getValue());
                        }
                        ++j;
                    }
                } else if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/authorization")) {
                    this.authorleveltext.setText(WsCoreUiTexts.getString((String)"WsCore.Labels.General.yes"));
                } else if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/session/")) {
                    this.sessionhandling.setText(WsUiTexts.getString("WsDefinitionPane.Labels.stateful"));
                }
                ++i;
            }
            if (this.wsd != null) {
                this.wsdname.setText(this.wsd.getName());
            }
            this.beanname.setText(super.getConfiguration().getEndPoint());
        }
    }

    public Control getControl() {
        this.checkWSDAndVI();
        this.mainPane = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)1);
        if (this.canShowData) {
            IGridLayoutPane generalpane = this.mainPane.addGridLayoutPane("", 2, this.mainPane.createGridLayoutData(4, 4, true, false, 1, 2));
            generalpane.addTextLabel(WsUiTexts.getString("OverviewPane.Labels.configName"), generalpane.createGridLayoutData(1, 4, false, false, 1, 1));
            this.configname = generalpane.addTextField(super.getConfiguration().getName(), generalpane.createGridLayoutData(4, 4, true, false, 1, 1));
            this.configname.setEditable(false);
            generalpane.addTextLabel(WsUiTexts.getString("OverviewPane.Labels.activeBinding"), generalpane.createGridLayoutData(1, 4, false, false, 1, 1));
            TransportBindingImpl tb = (TransportBindingImpl)super.getConfiguration().getTransportBinding();
            String trbindingname = NewCfgPage.convertRtBindingNameToDtBingingName((TransportBinding)tb);
            if (trbindingname == null) {
                trbindingname = tb.getDisplayName();
            }
            generalpane.addTextField(trbindingname, true, generalpane.createGridLayoutData(4, 4, true, false, 1, 1));
            generalpane.addTextLabel(WsUiTexts.getString("OverviewPane.Labels.path") + "   ", generalpane.createGridLayoutData(1, 4, false, false, 1, 1));
            this.targetaddress = generalpane.addTextField("", generalpane.createGridLayoutData(4, 4, true, false, 1, 1));
            IGridLayoutPane namepane = this.mainPane.addGridLayoutPane("WSD", 2, this.mainPane.createGridLayoutData(4, 1, true, false, 1, 2));
            namepane.addTextLabel(WsCoreUiTexts.getString((String)"WsCore.Wsd.Labels.name") + "  ", namepane.createGridLayoutData(1, 4, false, true, 1, 2));
            this.wsdname = namepane.addTextField("", true, namepane.createGridLayoutData(4, 4, true, true, 1, 2));
            namepane.addTextLabel(WsUiTexts.getString("OverviewPane.Labels.endpoint") + "  ", namepane.createGridLayoutData(1, 4, false, true, 1, 2));
            this.beanname = namepane.addTextField("", true, namepane.createGridLayoutData(4, 4, true, true, 1, 2));
            namepane.addTextLabel(WsUiTexts.getString("WsDefinitionPane.Labels.sessionHandling") + "  ", namepane.createGridLayoutData(1, 4, false, true, 1, 2));
            this.sessionhandling = namepane.addTextField("", true, namepane.createGridLayoutData(4, 4, true, true, 1, 2));
            namepane.addTextLabel(WsCoreUiTexts.getString((String)"WsCore.Security.Labels.authenticationLevel") + "  ", namepane.createGridLayoutData(1, 4, false, true, 1, 2));
            this.authentleveltext = namepane.addTextField("", true, namepane.createGridLayoutData(4, 4, true, true, 1, 2));
            namepane.addTextLabel(WsCoreUiTexts.getString((String)"WsCore.Security.Labels.authorization") + "  ", namepane.createGridLayoutData(1, 4, false, true, 1, 2));
            this.authorleveltext = namepane.addTextField("", true, namepane.createGridLayoutData(4, 4, true, true, 1, 2));
            namepane.addTextLabel(WsCoreUiTexts.getString((String)"WsCore.Security.Labels.transportGuarantee") + "  ", namepane.createGridLayoutData(1, 4, false, true, 1, 2));
            this.trguaranteetext = namepane.addTextField("", true, namepane.createGridLayoutData(4, 4, true, true, 1, 2));
            this.updatepane = this.mainPane.addGridLayoutPane(WsUiTexts.getString("OverviewPane.Labels.warning"), 2, generalpane.createGridLayoutData(4, 1, true, false, 1, 1));
            Label updatelabel = this.updatepane.addTextLabel(WsUiTexts.getString("OverviewPane.Errors.invalidCfg"), this.mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
            Color c = new Color((Device)updatelabel.getDisplay(), 224, 64, 64);
            updatelabel.setForeground(c);
            this.updatebutton = this.updatepane.addPushButton(WsUiTexts.getString("OverviewPane.Labels.update"), this.mainPane.createGridLayoutData(1, 4, false, true, 1, 1));
            this.updatebutton.addSelectionListener((SelectionListener)this);
        } else {
            this.createErrorLabel(this.mainPane);
        }
        return this.mainPane.getComposite();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (!this.getParentPage().isInResetMode()) {
            if (!this.getParentPage().isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName((String)this.getDeployData().getDescriptorProjectName())), new ResetPageStateI(){

                public void handleReset() {
                }
            })) {
                return;
            }
            this.adjustPageData((TypedEvent)event);
        }
    }

    void adjustPageData(TypedEvent te) {
        if (te.widget == this.targetaddress) {
            TransportAddressImpl ta = new TransportAddressImpl();
            ta.setName(this.targetaddress.getText());
            super.getConfiguration().setTransportAddress((TransportAddress)ta);
            if (!this.defaultmodification) {
                this.notifyOfChange();
            }
        } else if (te.widget == this.updatebutton) {
            WsConfigurationManager.updateConfiguration(super.getConfiguration(), super.getDeployData().getSecurityRoles());
            this.notifyOfChange();
            this.updatepane.getComposite().setVisible(false);
            VirtualInterface vi = WebServiceMdoResolver.getReferencedVi((String)super.getDeployData().getDescriptorProjectName(), (WebServiceDefinition)super.getDeployData().getWebServiceDefinition());
            String string = vi.getRoot().getMetamodel().getName();
        }
    }

    public void modifyText(final ModifyEvent e) {
        if (!this.getParentPage().isInResetMode()) {
            if (!this.getParentPage().isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName((String)this.getDeployData().getDescriptorProjectName())), new ResetPageStateI(){

                public void handleReset() {
                    if (e.widget == OverviewPane.this.targetaddress) {
                        OverviewPane.this.targetaddress.setText(OverviewPane.this.getConfiguration().getTransportAddress().getName());
                    }
                }
            })) {
                return;
            }
            this.adjustPageData((TypedEvent)e);
        }
    }

    private boolean checkConsistency(Configuration cfg) {
        WebServiceDefinition wsd = WebServiceMdoResolver.getWebServiceDefinitionFromWorkSpace((String)((WSConfigurationImpl)cfg).getParent().getGUID());
        VirtualInterface vi = WebServiceMdoResolver.getViForWsd((WebServiceDefinition)wsd);
        Vector<Function> newfunctions = new Vector<Function>();
        Function[] viFunctions = vi.getFunctions();
        int i = 0;
        while (i < viFunctions.length) {
            if (viFunctions[i].getIsExposed()) {
                newfunctions.add(viFunctions[i]);
            }
            ++i;
        }
        OperationConfiguration[] oldcfgs = cfg.getOperationConfigurations();
        if (WsConfigurationManager.operationConfigurationsChanged(oldcfgs, newfunctions)) {
            return false;
        }
        boolean consistent = true;
        int wsdsecuritylevel = 0;
        int wscfgsecuritylevel = 0;
        Feature[] oldfeatures = cfg.getGlobalFeatures();
        Feature[] designtime = WsConfigurationManager.getSelectedSoapFeatures(wsd, super.getConfiguration());
        boolean wscfgauthorizationselected = WsConfigurationManager.containsAuthorization(oldfeatures);
        boolean wsdauthorizationselected = WsConfigurationManager.containsAuthorization(designtime);
        if (wsdauthorizationselected && !wscfgauthorizationselected) {
            consistent = false;
        }
        wsdsecuritylevel = WsConfigurationManager.getWSDSecurityLevel(designtime);
        wscfgsecuritylevel = WsConfigurationManager.getCfgSecurityLevel(oldfeatures);
        if (WsConfigurationManager.insufficientCfgSecurityLevel(wscfgsecuritylevel, wsdsecuritylevel)) {
            consistent = false;
        }
        boolean wsdsession = WsConfigurationManager.containsSession(designtime);
        boolean wscfgsession = WsConfigurationManager.containsSession(oldfeatures);
        boolean bl = consistent = consistent && wsdsession == wscfgsession;
        if (!((WSConfigurationImpl)cfg).getIsJavaClass()) {
            OperationConfiguration[] opcfgs = cfg.getOperationConfigurations();
            String[] securityroles = super.getDeployData().getSecurityRoles();
            int i2 = 0;
            while (i2 < opcfgs.length) {
                Vector oproles = ((OperationConfigurationImpl)opcfgs[i2]).getSecurityRoles();
                int j = 0;
                while (j < oproles.size()) {
                    boolean found = false;
                    int k = 0;
                    while (k < securityroles.length) {
                        found = found || securityroles[k].equals(oproles.elementAt(j));
                        ++k;
                    }
                    if (!found) {
                        consistent = false;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return consistent;
    }
}

