/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.descriptor.ui.panes;

import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.cfg.DeploymentConfiguration;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.core.editors.FileReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import com.sap.ide.ws.editors.descriptor.ui.panes.WsDDGenericEditorPane;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.EntryPointSettings;
import com.sap.ide.ws.wsddman.Input;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.Property;
import com.sap.ide.ws.wsddman.WebService;
import com.sap.ide.ws.wsddman.impl0.EntryPointSettingsImpl;
import com.sap.ide.ws.wsddman.impl0.OperationConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.TransportBindingImpl;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdvancedPane
extends WsDDGenericEditorPane
implements ModifyListener,
SelectionListener {
    public static final String OVERVIEW_TEXT = WsUiTexts.getString("AdvancedPane.Labels.title");
    private static final String DOCUMENTATION = WsUiTexts.getString("AdvancedPane.Documentation.line1") + "\n" + WsUiTexts.getString("AdvancedPane.Documentation.line2") + "\n" + WsUiTexts.getString("AdvancedPane.Documentation.line3") + "\n" + WsUiTexts.getString("AdvancedPane.Documentation.line4") + "\n" + WsUiTexts.getString("AdvancedPane.Documentation.line5") + "\n" + WsUiTexts.getString("AdvancedPane.Documentation.line6") + "\n" + WsUiTexts.getString("AdvancedPane.Documentation.line7") + "\n" + WsUiTexts.getString("AdvancedPane.Documentation.line8") + "\n" + WsUiTexts.getString("AdvancedPane.Documentation.line9") + "\n" + WsUiTexts.getString("AdvancedPane.Documentation.line10");
    private ISelection selection;
    private OperationConfiguration[] configs;
    private Text serviceendpointname;
    private Text wsdlbindingname;
    private Text serverurl;
    private String transportbinding;
    private List operationList;
    private Text soapActionText;
    private Text servletTimeoutText;
    private Button editSetTimeout;
    private String[] operations = null;
    private WebService ws;

    public AdvancedPane(Composite parentComposite, EditorItemI parentEditor, DeploymentConfiguration deployData, Configuration config, WebService parentService) {
        super(parentComposite, parentEditor, deployData, config);
        this.ws = parentService;
    }

    public AdvancedPane(EditorItemI parentEditor, DeploymentConfiguration deployData, Configuration cfg, WebService parentService) {
        this(null, parentEditor, deployData, cfg, parentService);
    }

    public void init() {
        if (this.canShowData) {
            this.configs = super.getConfiguration().getOperationConfigurations();
            this.transportbinding = ((TransportBindingImpl)super.getConfiguration().getTransportBinding()).getName();
            this.operations = new String[this.configs.length];
            this.serviceendpointname.setText(super.getConfiguration().getPortName().getLocalName());
            this.wsdlbindingname.setText(super.getConfiguration().getTransportBinding().getWSDLBindingName().getLocalName());
            this.serverurl.setText(super.getConfiguration().getTargetServerURL());
            this.serviceendpointname.addModifyListener((ModifyListener)this);
            this.wsdlbindingname.addModifyListener((ModifyListener)this);
            this.serverurl.addModifyListener((ModifyListener)this);
            String[] s = new String[this.configs.length];
            this.operationList.addSelectionListener((SelectionListener)this);
            VirtualInterface vi = WebServiceMdoResolver.getReferencedVi((String)super.getDeployData().getDescriptorProjectName(), (WebServiceDefinition)super.getDeployData().getWebServiceDefinition());
            if (vi == null) {
                this.canShowData = false;
                return;
            }
            int i = 0;
            while (i < this.configs.length) {
                Function f = vi.getFunction(this.configs[i].getName());
                ((OperationConfigurationImpl)this.configs[i]).setNameMappedTo(f.getNameMappedTo());
                ++i;
            }
            int i2 = 0;
            while (i2 < this.configs.length) {
                s[i2] = ((OperationConfigurationImpl)this.configs[i2]).getNameMappedTo();
                ++i2;
            }
            this.operationList.setItems(s);
            this.soapActionText.addModifyListener((ModifyListener)this);
            if (s.length > 0) {
                this.operationList.select(0);
            } else {
                this.soapActionText.setEnabled(false);
            }
            EntryPointSettings epSettings = super.getConfiguration().getEntryPointSettings();
            if (epSettings == null) {
                this.servletTimeoutText.setText("1");
            } else {
                Property[] props = epSettings.getProperties();
                Property p = this.findProperty(props, "session-timeout");
                this.servletTimeoutText.setText(p.getValue());
            }
            this.servletTimeoutText.setEditable(false);
            this.editSetTimeout.addSelectionListener((SelectionListener)this);
        }
    }

    public Control getControl() {
        this.checkWSDAndVI();
        VirtualInterface vi = WebServiceMdoResolver.getReferencedVi((String)super.getDeployData().getDescriptorProjectName(), (WebServiceDefinition)super.getDeployData().getWebServiceDefinition());
        this.configs = super.getConfiguration().getOperationConfigurations();
        int i = 0;
        while (i < this.configs.length) {
            Function f = vi.getFunction(this.configs[i].getName());
            if (f == null) {
                this.canShowData = false;
            }
            ++i;
        }
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)1);
        if (this.canShowData) {
            IGridLayoutPane localnamepane = mainPane.addGridLayoutPane(WsUiTexts.getString("AdvancedPane.Labels.localNames"), 2, mainPane.createGridLayoutData(4, 1, true, false, 1, 2));
            localnamepane.addTextLabel(WsUiTexts.getString("AdvancedPane.Labels.wsdlPortName") + "  ", mainPane.createGridLayoutData(1, 4, false, true, 1, 2));
            this.serviceendpointname = localnamepane.addTextField("", mainPane.createGridLayoutData(4, 4, true, true, 1, 2));
            localnamepane.addTextLabel(WsUiTexts.getString("AdvancedPane.Labels.wsdlBindingName") + "  ", mainPane.createGridLayoutData(1, 4, false, true, 1, 2));
            this.wsdlbindingname = localnamepane.addTextField("", mainPane.createGridLayoutData(4, 4, true, true, 1, 2));
            IGridLayoutPane serverpane = mainPane.addGridLayoutPane(WsUiTexts.getString("AdvancedPane.Labels.serverUrl"), 1, mainPane.createGridLayoutData(4, 1, true, false, 1, 2));
            this.serverurl = serverpane.addTextField("", serverpane.createGridLayoutData(4, 4, true, true, 1, 2));
            ITabbedPane settingsPane = mainPane.addTabbedPane(mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
            IGridLayoutPane soapPane = settingsPane.addGridLayoutPaneAsTab(WsUiTexts.getString("AdvancedPane.Labels.soapSettings"), 2);
            IGridLayoutPane operationPane = soapPane.addGridLayoutPane(WsUiTexts.getString("AdvancedPane.Labels.operations"), 1, mainPane.createGridLayoutData(4, 4, true, true, 1, 1));
            this.operationList = operationPane.addList(new String[0], false, mainPane.createGridLayoutData(4, 4, true, true, 1, 2));
            IGridLayoutPane soapActionPane = soapPane.addGridLayoutPane(WsUiTexts.getString("AdvancedPane.Labels.soapAction"), 1, mainPane.createGridLayoutData(4, 1, true, false, 1, 1));
            this.soapActionText = soapActionPane.addTextField("", soapPane.createGridLayoutData(4, 1, true, false, 1, 1));
            IGridLayoutPane servletPane = settingsPane.addGridLayoutPaneAsTab(WsUiTexts.getString("AdvancedPane.Labels.servletSettings"), 3);
            servletPane.addTextLabel(WsUiTexts.getString("AdvancedPane.Labels.sessionTimeout") + " ", servletPane.createGridLayoutData(1, 1, false, false, 1, 1));
            this.servletTimeoutText = servletPane.addTextField("", servletPane.createGridLayoutData(4, 1, true, false, 1, 1));
            this.editSetTimeout = servletPane.addPushButton("Edit");
        } else {
            this.createErrorLabel(mainPane);
        }
        return mainPane.getComposite();
    }

    void adjustPageData(TypedEvent te) {
        if (te.widget == this.serviceendpointname) {
            super.getConfiguration().getPortName().setLocalName(this.serviceendpointname.getText());
        } else if (te.widget == this.wsdlbindingname) {
            super.getConfiguration().getTransportBinding().getWSDLBindingName().setLocalName(this.wsdlbindingname.getText());
        } else if (te.widget == this.serverurl) {
            super.getConfiguration().setTargetServerURL(this.serverurl.getText());
        } else if (te.widget == this.operationList) {
            int index = this.operationList.getSelectionIndex();
            if (index >= 0) {
                OperationConfiguration config = this.configs[this.operationList.getSelectionIndex()];
                Input in = config.getTransportBindingConfiguration().getInput();
                Property[] props = in.getProperties();
                Property p = this.findProperty(props, "soapAction");
                this.soapActionText.removeModifyListener((ModifyListener)this);
                this.soapActionText.setText(p.getValue());
                this.soapActionText.addModifyListener((ModifyListener)this);
            }
        } else if (te.widget == this.soapActionText) {
            OperationConfiguration config = this.configs[this.operationList.getSelectionIndex()];
            Input in = config.getTransportBindingConfiguration().getInput();
            Property[] props = in.getProperties();
            Property p = this.findProperty(props, "soapAction");
            p.setValue(this.soapActionText.getText());
        }
        if (te.widget != this.operationList && te.widget != this.editSetTimeout) {
            super.notifyOfChange();
        } else if (te.widget == this.editSetTimeout) {
            TimeOutDialog tod = new TimeOutDialog(this.editSetTimeout.getShell(), this.servletTimeoutText.getText());
            tod.open();
            if (tod.okPressed) {
                EntryPointSettings epSettings = super.getConfiguration().getEntryPointSettings();
                if (epSettings == null) {
                    epSettings = new EntryPointSettingsImpl();
                    ((EntryPointSettingsImpl)epSettings).setDefaultProperties();
                    super.getConfiguration().setEntryPointSettings(epSettings);
                }
                Property p = this.findProperty(epSettings.getProperties(), "session-timeout");
                p.setValue(tod.getInteger());
                this.servletTimeoutText.setText(tod.getInteger());
                super.notifyOfChange();
            }
        }
    }

    public void modifyText(final ModifyEvent e) {
        if (!this.getParentPage().isInResetMode()) {
            if (!this.getParentPage().isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName((String)this.getDeployData().getDescriptorProjectName())), new ResetPageStateI(){

                public void handleReset() {
                    int index;
                    if (e.widget == AdvancedPane.this.serviceendpointname) {
                        AdvancedPane.this.serviceendpointname.setText(AdvancedPane.this.getConfiguration().getPortName().getLocalName());
                    } else if (e.widget == AdvancedPane.this.serverurl) {
                        AdvancedPane.this.serverurl.setText(AdvancedPane.this.getConfiguration().getTargetServerURL());
                    } else if (e.widget == AdvancedPane.this.wsdlbindingname) {
                        AdvancedPane.this.wsdlbindingname.setText(AdvancedPane.this.getConfiguration().getTransportBinding().getWSDLBindingName().getLocalName());
                    } else if (e.widget == AdvancedPane.this.soapActionText && (index = AdvancedPane.this.operationList.getSelectionIndex()) >= 0) {
                        OperationConfiguration config = AdvancedPane.this.configs[AdvancedPane.this.operationList.getSelectionIndex()];
                        Input in = config.getTransportBindingConfiguration().getInput();
                        Property[] props = in.getProperties();
                        Property p = AdvancedPane.this.findProperty(props, "soapAction");
                        AdvancedPane.this.soapActionText.setText(p.getValue());
                    }
                }
            })) {
                return;
            }
            this.adjustPageData((TypedEvent)e);
        }
    }

    private Property findProperty(Property[] props, String propertyName) {
        Property p = null;
        int i = 0;
        while (i < props.length) {
            if (props[i].getName().equals(propertyName)) {
                p = props[i];
                break;
            }
            ++i;
        }
        return p;
    }

    public void setRO(boolean readonly) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget != this.operationList && !this.getParentPage().isInResetMode() && !this.getParentPage().isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName((String)this.getDeployData().getDescriptorProjectName())), new ResetPageStateI(){

            public void handleReset() {
            }
        })) {
            return;
        }
        this.adjustPageData((TypedEvent)e);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    class TimeOutDialog
    extends Dialog
    implements SelectionListener,
    KeyListener {
        Button okbutton = null;
        Button cancelbutton = null;
        Text timeoutValueText = null;
        String timeoutValue;
        boolean okPressed = false;

        public TimeOutDialog(Shell parent, String timeoutValue) {
            super(parent);
            this.timeoutValue = timeoutValue;
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            c.getShell().setText(WsUiTexts.getString("AdvancedPane.Dialogs.enterInteger"));
            return c;
        }

        public Control createContents(Composite parent) {
            Point p = parent.computeSize(300, 100);
            parent.setSize(p);
            parent.setLayout((Layout)new FillLayout());
            Composite c = (Composite)this.createDialogArea(parent);
            c.setLayout((Layout)new FillLayout());
            IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)c, (int)1);
            mainPane.setMargin(12, 12);
            IGridLayoutPane internalpane = mainPane.addGridLayoutPane(1, mainPane.createGridLayoutData(4, 2, true, false, 2, 1));
            this.timeoutValueText = internalpane.addTextField(this.timeoutValue, mainPane.createGridLayoutData(4, 2, true, false, 2, 1));
            IGridLayoutPane buttoncontainer = mainPane.addGridLayoutPane(1, mainPane.createGridLayoutData(4, 2, false, false, 1, 2));
            IGridLayoutPane pane = buttoncontainer.addGridLayoutPane(1, buttoncontainer.createGridLayoutData(4, 2, true, false, 1, 2));
            pane.addTextLabel("");
            IGridLayoutPane buttonpane = buttoncontainer.addGridLayoutPane(3, buttoncontainer.createGridLayoutData(4, 2, true, false, 1, 2));
            this.okbutton = buttonpane.addPushButton("  " + WsUiTexts.getString("AdvancedPane.Dialogs.OK") + "  ", mainPane.createGridLayoutData(3, 1, false, false, 1, 2));
            buttonpane.addTextLabel("  ", mainPane.createGridLayoutData(2, 1, false, false, 1, 2));
            this.cancelbutton = buttonpane.addPushButton("  " + WsUiTexts.getString("AdvancedPane.Dialogs.Cancel") + "  ", mainPane.createGridLayoutData(1, 2, false, false, 1, 2));
            this.okbutton.addSelectionListener((SelectionListener)this);
            this.cancelbutton.addSelectionListener((SelectionListener)this);
            this.timeoutValueText.addKeyListener((KeyListener)this);
            return mainPane.getComposite();
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.okbutton) {
                this.onOK();
            } else {
                this.close();
            }
        }

        public boolean getOKPressed() {
            return this.okPressed;
        }

        public String getInteger() {
            return this.timeoutValue;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void onOK() {
            try {
                Integer i = new Integer(this.timeoutValueText.getText());
                this.okPressed = true;
                this.timeoutValue = this.timeoutValueText.getText();
                this.close();
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.okbutton.getShell(), (String)WsUiTexts.getString("AdvancedPane.Errors.error"), (String)(WsUiTexts.getString("AdvancedPane.Errors.invalidInteger") + "\n" + ex.toString()));
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13) {
                this.onOK();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

