/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.descriptor.pages;

import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.editors.descriptor.pages.ConfigurationWrapper;
import com.sap.ide.ws.editors.descriptor.ui.tree.ConfigurationChildNodes;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.WebService;
import java.util.Hashtable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class WsDDContentProvider
implements ITreeContentProvider {
    private EditorItemI parentEditorPage;
    private Hashtable configWrapperTable = new Hashtable();
    private Hashtable configChildNodeTable = new Hashtable();

    public WsDDContentProvider(EditorItemI parentEditorPage) {
        this.parentEditorPage = parentEditorPage;
        this.initConfigWrapperTable();
    }

    public void initConfigWrapperTable() {
        DeploymentDescriptor dd = (DeploymentDescriptor)this.parentEditorPage.getEditingObject();
        WebService[] services = dd.getWebServices();
        int i = 0;
        while (i < services.length) {
            Configuration[] configs = services[i].getConfigurations();
            ConfigurationWrapper[] wrapperList = new ConfigurationWrapper[configs.length];
            int j = 0;
            while (j < configs.length) {
                wrapperList[j] = new ConfigurationWrapper(services[i], configs[j]);
                this.configChildNodeTable.put(wrapperList[j], new ConfigurationChildNodes(configs[j], services[i], this.parentEditorPage));
                ++j;
            }
            this.configWrapperTable.put(services[i], wrapperList);
            ++i;
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DeploymentDescriptor) {
            return ((DeploymentDescriptor)parentElement).getWebServices();
        }
        if (parentElement instanceof WebService) {
            if (this.configWrapperTable.containsKey(parentElement)) {
                return (ConfigurationWrapper[])this.configWrapperTable.get(parentElement);
            }
            System.err.println("Web Service: " + ((WebService)parentElement).getInternalName() + " not found in list...");
            return null;
        }
        if (parentElement instanceof ConfigurationWrapper) {
            if (this.configChildNodeTable.containsKey(parentElement)) {
                return ((ConfigurationChildNodes)this.configChildNodeTable.get(parentElement)).getChildList();
            }
            return null;
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof DeploymentDescriptor || element instanceof WebService || element instanceof ConfigurationWrapper;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement.equals("")) {
            return new Object[]{this.parentEditorPage.getEditingObject()};
        }
        return new Object[]{inputElement};
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

