/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.descriptor.pages;

import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.core.editors.FileReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.editors.descriptor.pages.ConfigurationWrapper;
import com.sap.ide.ws.editors.descriptor.pages.WsDDTreeEditorPage;
import com.sap.ide.ws.wizards.descriptor.ws.AddWsToDescriptorWizard;
import com.sap.ide.ws.wizards.descriptor.wscfg.NewWsCfgWizard;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.WebService;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class AddRemoveCallback
implements IAddRemoveCallback {
    private EditorItemI parentEditorItem;
    private HandleReadOnlyStateI readStateHandler;

    public AddRemoveCallback(EditorItemI parentEditorItem) {
        this.parentEditorItem = parentEditorItem;
        this.readStateHandler = new FileReadOnlyStateHandler(DescriptorManager.getDescriptorFileByProjectName((String)((WsDDTreeEditorPage)parentEditorItem).getEjbJarProjectName()));
    }

    public boolean canAddElement(Object currentSelection) {
        if (currentSelection instanceof WebService) {
            return true;
        }
        return currentSelection instanceof DeploymentDescriptor;
    }

    public boolean canRemoveElement(Object currentSelection) {
        return currentSelection instanceof WebService || currentSelection instanceof ConfigurationWrapper;
    }

    public boolean isChangeAllowed() {
        return !this.readStateHandler.isReadOnly() || !(this.readStateHandler.isDtrRelevant() ? !this.readStateHandler.checkOutFromDtr() : !this.readStateHandler.changeFileReadOnlyFlag());
    }

    public Object addElement(Object currentSelection) {
        if (this.isChangeAllowed()) {
            if (currentSelection instanceof DeploymentDescriptor) {
                return this.addWebService();
            }
            if (currentSelection instanceof WebService) {
                return this.addConfiguration((WebService)currentSelection);
            }
        }
        return null;
    }

    public boolean removeElement(Object currentSelection) {
        if (this.isChangeAllowed()) {
            if (currentSelection instanceof WebService) {
                return this.deleteWebService((WebService)currentSelection);
            }
            if (currentSelection instanceof ConfigurationWrapper) {
                return this.deleteConfiguration((ConfigurationWrapper)currentSelection);
            }
        }
        return false;
    }

    private WebService addWebService() {
        AddWsToDescriptorWizard wizard = new AddWsToDescriptorWizard(((WsDDTreeEditorPage)this.parentEditorItem).getEjbJarProjectName());
        wizard.setForcePreviousAndNextButtons(false);
        WizardDialog dialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            return wizard.getNewWebService();
        }
        return null;
    }

    private Configuration addConfiguration(WebService service) {
        NewWsCfgWizard wizard = new NewWsCfgWizard(service, ((WsDDTreeEditorPage)this.parentEditorItem).getEjbJarProjectName(), (DeploymentDescriptor)this.parentEditorItem.getEditingObject());
        wizard.setForcePreviousAndNextButtons(false);
        WizardDialog dialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            return wizard.getConfiguration();
        }
        return null;
    }

    private boolean deleteConfiguration(ConfigurationWrapper wrapper) {
        Configuration config = wrapper.getConfig();
        WebService service = wrapper.getParentService();
        service.removeConfiguration(config.getName());
        return true;
    }

    private boolean deleteWebService(WebService service) {
        DeploymentDescriptor dd = (DeploymentDescriptor)this.parentEditorItem.getEditingObject();
        dd.deleteWebService(service.getGUID(), service.getInternalName());
        return true;
    }
}

