/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.editors.descriptor;

import com.sap.ide.ws.core.decorators.WsLabelDecorator;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.core.editors.GenericMultiPageEditor;
import com.sap.ide.ws.core.editors.GenericMultiPageEditorPage;
import com.sap.ide.ws.core.services.editors.DescriptorEditorI;
import com.sap.ide.ws.decorator.DescriptorDecoratorLabelProvider;
import com.sap.ide.ws.editors.descriptor.pages.WsDDTreeEditorPage;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.tssap.j2ee.core.providers.vi.ui.WsUIPlugin;
import com.tssap.util.help.ContextHelp;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class WsDDEditor
extends GenericMultiPageEditor
implements DescriptorEditorI,
IResourceChangeListener {
    public static final String EDITOR_ID = "com.sap.ide.ws.editors.descriptor.WsDDEditor";
    private WsDDTreeEditorPage descriptorPage;
    private int descriptorPageIndex;
    private DeploymentDescriptor dd;
    private String descriptorProjectName;
    private static final String WS_DD_TEXT = "WS Deployment Descriptor";

    public WsDDEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected String getProjectName() {
        return this.descriptorProjectName;
    }

    public Image getTitleImage() {
        return WsLabelDecorator.getInstance().decorateImage(WsUIPlugin.getImage((String)"web_services/webservice/WebServiceDescriptor.gif"), (Object)new DescriptorDecoratorLabelProvider(this.descriptorProjectName, "/META-INF/ws-deployment-descriptor.xml", "com.sap.ide.ws.checkMarker"));
    }

    public void updateUi() {
        this.setTitleImage(this.getTitleImage());
        this.refresh();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projectDeltas;
        IResourceDelta rootDelta;
        if ((event.getType() == 1 || event.getType() == 4) && (rootDelta = event.getDelta()) != null && (projectDeltas = rootDelta.getAffectedChildren()) != null) {
            int i = 0;
            while (i < projectDeltas.length) {
                if ((projectDeltas[i].getFlags() == 16384 || projectDeltas[i].getKind() == 2) && projectDeltas[i].getResource() instanceof IProject && projectDeltas[i].getResource().getName().equals(this.descriptorProjectName) && !projectDeltas[i].getResource().isAccessible()) {
                    final IWorkbenchPage page = this.getEditorSite().getPage();
                    WsDDEditor editor = this;
                    editor.getEditorSite().getShell().getDisplay().syncExec(new Runnable((IEditorPart)editor){
                        private final /* synthetic */ IEditorPart val$editor;
                        {
                            this.val$editor = val$editor;
                        }

                        public void run() {
                            page.closeEditor(this.val$editor, true);
                        }
                    });
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                }
                ++i;
            }
        }
    }

    public Object getEditingObject() {
        return this.dd;
    }

    public String getDescriptorContainingProjectName() {
        return this.getEjbJarProjectName();
    }

    public String getEjbJarProjectName() {
        return this.descriptorProjectName;
    }

    public void refreshTitleImage() {
        Image image = WsUIPlugin.getImage((String)"web_services/webservice/WebServiceDescriptor.gif");
        this.setTitleImage(WsLabelDecorator.getInstance().decorateImage(image, (Object)new DescriptorDecoratorLabelProvider(this.getDescriptorContainingProjectName(), "/META-INF/ws-deployment-descriptor.xml", "com.sap.ide.ws.checkMarker")));
    }

    public void setPageAndIndex(GenericMultiPageEditorPage page, int index) {
        if (page instanceof WsDDTreeEditorPage) {
            this.descriptorPage = (WsDDTreeEditorPage)page;
            this.descriptorPageIndex = index;
            this.descriptorPage.setTreeProvider();
        }
    }

    protected boolean doSaveTask() {
        DescriptorManager.saveDeploymentDescriptor((DeploymentDescriptor)this.dd, (String)this.descriptorProjectName);
        return true;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof FileEditorInput) {
            this.descriptorProjectName = ((FileEditorInput)input).getFile().getProject().getName();
        }
        if (this.descriptorProjectName != null) {
            this.dd = DescriptorManager.getDeploymentDescriptor((String)this.descriptorProjectName);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createPages() {
        this.getContainer().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                ContextHelp.show((String)"com.sap.devmanual.doc.user", (String)"WSCONF");
            }
        });
        WsDDTreeEditorPage descriptorPage = new WsDDTreeEditorPage(this.getContainer(), (EditorItemI)this);
        int overviewIndex = this.addPage((Control)descriptorPage.getControl());
        this.setPageText(overviewIndex, WS_DD_TEXT);
        this.setPageAndIndex(descriptorPage, overviewIndex);
        this.refreshTitleImage();
    }

    public void refresh() {
        this.descriptorPage.refresh();
    }

    public boolean isEditedObjectReadOnly() {
        return !DescriptorManager.getDescriptorFile((String)this.descriptorProjectName).canWrite();
    }
}

