/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.decorator;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.ws.WSDRoot;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.metamodel.ws.plugin.WSRootManager;
import com.sap.ide.ws.core.adapter.MetamodelResourceAdapter;
import com.sap.ide.ws.core.decorators.DecoratedElementI;
import com.sap.ide.ws.core.markers.ResourceMarkerManager;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.tssap.selena.model.elements.Element;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class WsdDecoratorFlagProvider
implements DecoratedElementI {
    private WebServiceDefinition wsd;

    public WsdDecoratorFlagProvider(WebServiceDefinition wsd) {
        this.wsd = wsd;
    }

    public WsdDecoratorFlagProvider(Element element) {
        this.wsd = this.getMdoForEntity(element);
    }

    public IMarker[] getMarkers() {
        IMarker[] markers = WsdDecoratorFlagProvider.getWsdMarkers(MetamodelResourceAdapter.mdoToResource((MainDevelopmentObject)this.wsd));
        return markers;
    }

    public static IMarker[] getWsdMarkers(IResource mdoResource) {
        IMarker[] textCheckMarkers = ResourceMarkerManager.getResourceMarkers((IResource)mdoResource, (String)"com.sap.ide.ws.wsd_text_check_marker");
        IMarker[] wsdCheckMarkers = ResourceMarkerManager.getResourceMarkers((IResource)mdoResource, (String)"com.sap.ide.ws.wsd_check_marker");
        IMarker[] result = new IMarker[wsdCheckMarkers.length + textCheckMarkers.length];
        int i = 0;
        while (i < textCheckMarkers.length) {
            result[i] = textCheckMarkers[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < wsdCheckMarkers.length) {
            result[i2 + textCheckMarkers.length] = wsdCheckMarkers[i2];
            ++i2;
        }
        return result;
    }

    private WebServiceDefinition getMdoForEntity(Element element) {
        String projectName = element.getModel().getUniqueName().getName();
        String mdoPack = element.getUniqueName().getLocation();
        String mdoName = element.getUniqueName().getName();
        WebServiceDefinition[] wsds = this.getWsdsForProject(projectName);
        int i = 0;
        while (i < wsds.length) {
            if (wsds[i].getPackage().equals(mdoPack) && wsds[i].getName().equals(mdoName)) {
                return wsds[i];
            }
            ++i;
        }
        return null;
    }

    private WebServiceDefinition[] getWsdsForProject(String projectName) {
        block7: {
            WSDRoot root = null;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            try {
                if (!project.exists() || !project.isOpen() || !project.hasNature("org.eclipse.jdt.core.javanature")) break block7;
                try {
                    root = WSRootManager.getWSRoot((Metamodel)MetamodelManager.getMetamodel((String)projectName));
                }
                catch (Exception e) {
                    WebServiceCorePlugin.logError((Throwable)e, this.getClass());
                }
                if (root != null) {
                    try {
                        return root.getWebServiceDefinitions();
                    }
                    catch (Exception e) {
                        WebServiceCorePlugin.logError((Throwable)e, this.getClass());
                    }
                }
            }
            catch (CoreException e) {
                WebServiceCorePlugin.logError((Throwable)e, this.getClass());
            }
        }
        return new WebServiceDefinition[0];
    }
}

