/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.configuration;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.InterfaceType;
import com.sap.ide.metamodel.vi.Parameter;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.Property;
import com.sap.ide.metamodel.ws.SoapApplication;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.endpoints.EndpointReference;
import com.sap.ide.webservices.mdos.ProjectViRefs;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.cfg.DeploymentConfiguration;
import com.sap.ide.ws.cfg.ep.Endpoint;
import com.sap.ide.ws.cfg.ep.ejb.EJB;
import com.sap.ide.ws.cfg.ep.ejb.impl.EJBImpl;
import com.sap.ide.ws.cfg.ep.java.JavaClass;
import com.sap.ide.ws.cfg.ep.java.impl.JavaClassImpl;
import com.sap.ide.ws.configuration.WsConfigurationData;
import com.sap.ide.ws.core.services.editors.MdoEditorUtils;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.soapapp.FeatureConstants;
import com.sap.ide.ws.soapapp.SOAPApplicationDt;
import com.sap.ide.ws.soapapp.SOAPApplicationFactoryDt;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.Fault;
import com.sap.ide.ws.wsddman.Feature;
import com.sap.ide.ws.wsddman.Input;
import com.sap.ide.ws.wsddman.JavaClassSecurityRole;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.Output;
import com.sap.ide.ws.wsddman.TransportBinding;
import com.sap.ide.ws.wsddman.WebService;
import com.sap.ide.ws.wsddman.impl0.DeployTimeFeatures;
import com.sap.ide.ws.wsddman.impl0.FaultImpl;
import com.sap.ide.ws.wsddman.impl0.FeatureImpl;
import com.sap.ide.ws.wsddman.impl0.InputImpl;
import com.sap.ide.ws.wsddman.impl0.OperationConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.OutputImpl;
import com.sap.ide.ws.wsddman.impl0.PropertyImpl;
import com.sap.ide.ws.wsddman.impl0.TransportBindingImpl;
import com.sap.ide.ws.wsddman.impl0.WSConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.WebServiceImpl;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.impl.SessionBean;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityRole;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class WsConfigurationManager
implements FeatureConstants {
    private static String SESSION_FEATURE_NAME = "http://www.sap.com/webas/630/soap/features/session";
    private static boolean mustaddsecurityroles;
    public static int EP_TYPE_EJB;
    public static int EP_TYPE_JAVA_CLASS;

    public static DeploymentConfiguration createConfigutationInfo(String configName, String ejbJarProjectName, WebService service) {
        WebServiceDefinition[] definition = WebServiceMdoResolver.getWsdsForWorkspace();
        int i = 0;
        while (i < definition.length) {
            if (definition[i].getGuid().equals(service.getGUID())) {
                return WsConfigurationManager.createConfigurationInfo(configName, service, ejbJarProjectName, definition[i]);
            }
            ++i;
        }
        return null;
    }

    public static DeploymentConfiguration createConfigurationInfo(String configName, WebService service, String descriptorProjectName, WebServiceDefinition wsDefinition) {
        ProjectViRefs ref = WebServiceMdoResolver.resolveReferencedVi((String)descriptorProjectName, (WebServiceDefinition)wsDefinition);
        EJB epData = null;
        VirtualInterface vi = null;
        if (ref != null) {
            vi = ref.getVi(0);
        }
        if (vi != null) {
            com.sap.ide.metamodel.vi.EndpointReference eRef = vi.getEndpointReference();
            if (EndpointAnalyser.getType((com.sap.ide.metamodel.vi.EndpointReference)eRef).equals(EndpointReference.EJB_TYPE)) {
                epData = WsConfigurationManager.getEjbData(service.getEJBNameTemp(), ref.getProjectName(), descriptorProjectName, wsDefinition);
            } else if (EndpointAnalyser.getType((com.sap.ide.metamodel.vi.EndpointReference)eRef).equals(EndpointReference.CLASS_TYPE)) {
                epData = WsConfigurationManager.getJavaClassData(EndpointAnalyser.getEndPointName((com.sap.ide.metamodel.vi.EndpointReference)eRef));
            }
        }
        return new WsConfigurationData(wsDefinition, service.getInternalName(), descriptorProjectName, (Endpoint)epData, configName);
    }

    private static void checkWsdState(WebServiceDefinition wsd) {
        IEditorPart editor;
        MessageDialog dlg;
        if ((wsd.isModified() || wsd.getTextPool().isModified()) && (dlg = new MessageDialog(Display.getCurrent().getActiveShell(), WsCoreUiTexts.getString((String)"DialogTitles.warning"), null, WsCoreUiTexts.getString((String)"WsCore.Wsd.Messages.wsdSaved"), 4, new String[]{"OK"}, 1)).open() == 0 && (editor = MdoEditorUtils.findEditorPartForMdo((MainDevelopmentObject)wsd)) != null) {
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static Configuration createConfiguration(WebService service, String configName, String transportBinding, String defaultConfType, String descriptorProjectName, WebServiceDefinition wsd) {
        SOAPApplicationDt[] soapApps;
        WsConfigurationManager.checkWsdState(wsd);
        Configuration config = service.addConfiguration(configName);
        DeploymentConfiguration cfg = WsConfigurationManager.createConfigurationInfo(configName, service, descriptorProjectName, wsd);
        if (transportBinding != null) {
            TransportBindingImpl tpb = new TransportBindingImpl();
            tpb.setName(transportBinding);
            config.setTransportBinging((TransportBinding)tpb);
        }
        if (defaultConfType != null && (soapApps = SOAPApplicationFactoryDt.createSOAPApplication((String)"EP_TYPE_EJB")) != null && soapApps.length > 0) {
            soapApps[0].fillAsDefaultConfiguration(defaultConfType, config, cfg);
        }
        WsConfigurationManager.setOperationConfigurations(service, cfg);
        return config;
    }

    private static void setOperationConfigurations(WebService service, DeploymentConfiguration deployCfg) {
        IEditorPart editor;
        MessageDialog dlg;
        VirtualInterface vi = WebServiceMdoResolver.getReferencedVi((String)deployCfg.getDescriptorProjectName(), (WebServiceDefinition)deployCfg.getWebServiceDefinition());
        if (vi.isModified() && (dlg = new MessageDialog(Display.getCurrent().getActiveShell(), WsCoreUiTexts.getString((String)"DialogTitles.warning"), null, WsCoreUiTexts.getString((String)"WsCore.Vi.Messages.viSaved"), 4, new String[]{"OK"}, 1)).open() == 0 && (editor = MdoEditorUtils.findEditorPartForMdo((MainDevelopmentObject)vi)) != null) {
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        WebServiceDefinition wsd = deployCfg.getWebServiceDefinition();
        ArrayList operationCfg = new ArrayList();
        if (vi != null) {
            Function[] functions = vi.getFunctions();
            operationCfg = WsConfigurationManager.convertFunctions(functions);
        }
        OperationConfiguration[] opcfgs = new OperationConfiguration[operationCfg.size()];
        Configuration cfg = service.getConfiguration(deployCfg.getConfigurationName());
        if (cfg.getGlobalFeatures().length == 0) {
            Feature[] deploytimefeatures = WsConfigurationManager.addDeployTimeFeatures(WsConfigurationManager.getSelectedSoapFeatures(deployCfg, cfg));
            cfg.setGlobalFeatures(deploytimefeatures);
        } else {
            ArrayList<Feature> al = new ArrayList<Feature>();
            Feature[] designtime = WsConfigurationManager.getSelectedSoapFeatures(deployCfg, cfg);
            Feature[] allfeatures = cfg.getGlobalFeatures();
            int i = 0;
            while (i < designtime.length) {
                al.add(designtime[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < allfeatures.length) {
                if (((FeatureImpl)allfeatures[i2]).isDeployTimeFeature()) {
                    al.add(allfeatures[i2]);
                }
                ++i2;
            }
            allfeatures = new Feature[al.size()];
            allfeatures = al.toArray(allfeatures);
            cfg.setGlobalFeatures(allfeatures);
        }
        ((WSConfigurationImpl)cfg).setOwnerName("urn:" + wsd.getName() + "/" + vi.getName());
        ((WSConfigurationImpl)cfg).setPortVi(vi.getPackage(), vi.getName() + ".videf");
        ((WSConfigurationImpl)cfg).setWSD(wsd.getPackage(), wsd.getName() + ".wsdef");
        ((WSConfigurationImpl)cfg).addMissingOperations(operationCfg.toArray(opcfgs), vi);
        ((WSConfigurationImpl)cfg).setDefaultTransportAddress(service.getInternalName());
        ((WSConfigurationImpl)cfg).wsdlporttypename.setLocalName(vi.getName());
        int i = 0;
        while (i < opcfgs.length) {
            if (mustaddsecurityroles) {
                ((OperationConfigurationImpl)opcfgs[i]).setSecurityRoles(WsConfigurationManager.getSecurityRoles(deployCfg));
            }
            Input in = opcfgs[i].getTransportBindingConfiguration().getInput();
            ((InputImpl)in).setDefaultProperties();
            Output out = opcfgs[i].getTransportBindingConfiguration().getOutput();
            ((OutputImpl)out).setDefaultProperties();
            Fault[] f = opcfgs[i].getTransportBindingConfiguration().getFaults();
            int j = 0;
            while (j < f.length) {
                ((FaultImpl)f[j]).setDefaultProperties();
                ++j;
            }
            ++i;
        }
        TransportBindingImpl tb = (TransportBindingImpl)cfg.getTransportBinding();
        String standardnamespace = "urn:" + deployCfg.getWebServiceDefinition().getName();
        ((WebServiceImpl)service).getName().setNamespaceURI(standardnamespace);
        ((WebServiceImpl)service).setStandardNamespace(standardnamespace);
        cfg.getWSDLPortTypeName().setNamespaceURI(standardnamespace);
        cfg.getPortName().setNamespaceURI(standardnamespace);
        if (tb == null) {
            tb = new TransportBindingImpl();
            tb.setName("HTTP SOAP");
            cfg.setTransportBinging((TransportBinding)tb);
        } else if (tb.getName().equals("")) {
            tb.setName("HTTP SOAP");
        }
        tb.getWSDLBindingName().setNamespaceURI(standardnamespace);
        tb.setRelatedConfigs(cfg.getOperationConfigurations());
        String beanname = service.getEJBNameTemp();
        cfg.setBeanName(beanname);
    }

    public static Feature[] addDeployTimeFeatures(Feature[] designtimef) {
        DeployTimeFeatures dtf = new DeployTimeFeatures();
        Feature[] deploytimefeatures = dtf.createDeployTimeFeatures(designtimef);
        mustaddsecurityroles = dtf.mustAddSecurityRoles();
        if (WsConfigurationManager.containsAuthorization(designtimef)) {
            deploytimefeatures = WsConfigurationManager.addAuthorization(deploytimefeatures);
        }
        return deploytimefeatures;
    }

    public static Feature[] getSelectedSoapFeatures(DeploymentConfiguration deployCfg, Configuration cfg) {
        SoapApplication app = ((WSConfigurationImpl)cfg).getIsJavaClass() ? deployCfg.getWebServiceDefinition().getSoapApplication(SOAPApplicationFactoryDt.convertConstant((InterfaceType)InterfaceType.JAVACLASS)) : deployCfg.getWebServiceDefinition().getSoapApplication(SOAPApplicationFactoryDt.convertConstant((InterfaceType)InterfaceType.EJB));
        if (app != null) {
            return WsConfigurationManager.convertFeatures(app.getFeatures());
        }
        return new Feature[0];
    }

    public static Feature[] getSelectedSoapFeatures(WebServiceDefinition wsd, Configuration cfg) {
        SoapApplication app = ((WSConfigurationImpl)cfg).getIsJavaClass() ? wsd.getSoapApplication(SOAPApplicationFactoryDt.convertConstant((InterfaceType)InterfaceType.JAVACLASS)) : wsd.getSoapApplication(SOAPApplicationFactoryDt.convertConstant((InterfaceType)InterfaceType.EJB));
        if (app != null) {
            return WsConfigurationManager.convertFeatures(app.getFeatures());
        }
        return new Feature[0];
    }

    private static Feature[] convertFeatures(com.sap.ide.metamodel.ws.Feature[] features) {
        ArrayList<FeatureImpl> featureList = new ArrayList<FeatureImpl>();
        int i = 0;
        while (i < features.length) {
            FeatureImpl newFeature = new FeatureImpl();
            newFeature.setName(features[i].getName());
            if (newFeature.getName().equals("http://www.sap.com/webas/630/soap/features/transportguarantee") || newFeature.getName().equals("http://www.sap.com/webas/630/soap/features/authentication") || newFeature.getName().equals("http://www.sap.com/webas/630/soap/features/authorization")) {
                newFeature.setProtocol("SecurityProtocol");
            }
            Property[] props = features[i].getProperties();
            ArrayList<PropertyImpl> propertyList = new ArrayList<PropertyImpl>();
            int j = 0;
            while (j < props.length) {
                PropertyImpl prop = new PropertyImpl();
                prop.setName(props[j].getName());
                prop.setValue(props[j].getValue());
                propertyList.add(prop);
                ++j;
            }
            com.sap.ide.ws.wsddman.Property[] apiProps = new com.sap.ide.ws.wsddman.Property[propertyList.size()];
            apiProps = propertyList.toArray(apiProps);
            newFeature.setProperties(apiProps);
            featureList.add(newFeature);
            ++i;
        }
        return featureList.toArray(new Feature[featureList.size()]);
    }

    public static String[] getSecurityRoles(String descriptorProjectName) {
        ISecurityRole[] roles;
        IEjbJar ejbjarDescriptor;
        ArrayList<String> roleList = new ArrayList<String>();
        if (J2eeProjectManager.getEjbModule((String)descriptorProjectName) != null && (ejbjarDescriptor = J2eeProjectManager.getEjbModule((String)descriptorProjectName).getDescriptor()) != null && (roles = ejbjarDescriptor.getAssemblyDescriptor().getSecurityRoles()) != null) {
            int i = 0;
            while (i < roles.length) {
                if (roles[i].getRoleName() != null) {
                    roleList.add(roles[i].getRoleName().getValue());
                }
                ++i;
            }
        }
        return roleList.toArray(new String[roleList.size()]);
    }

    public static Vector getSecurityRoles(DeploymentConfiguration deployCfg) {
        Vector<String> v = new Vector<String>();
        String[] s = deployCfg.getSecurityRoles();
        int i = 0;
        while (i < s.length) {
            v.add(s[i]);
            ++i;
        }
        return v;
    }

    private static JavaClass getJavaClassData(String implClassQName) {
        return new JavaClassImpl(implClassQName);
    }

    private static EJB getEjbData(String beanName, String referemcedEJBProjectName, String ejbJarProjectName, WebServiceDefinition wsDefinition) {
        IEnterpriseJavaBean bean = null;
        bean = J2eeProjectManager.getEjbModule((String)ejbJarProjectName).getReferencedEjb(beanName);
        if (bean != null) {
            IEnterpriseJavaBean sourceBean = J2eeProjectManager.getEjbModule((String)referemcedEJBProjectName).getEnterpriseBean(bean.getDefaultEjbName());
            if (sourceBean instanceof SessionBean) {
                return new EJBImpl(beanName, "", WsConfigurationManager.isStatefulFeatureSet(wsDefinition));
            }
            return new EJBImpl(beanName, "");
        }
        return null;
    }

    private static boolean isStatefulFeatureSet(WebServiceDefinition wsDefinition) {
        com.sap.ide.metamodel.ws.Feature[] features = wsDefinition.getSoapApplications()[0].getFeatures();
        int i = 0;
        while (i < features.length) {
            if (features[i].getName().equals(SESSION_FEATURE_NAME)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ArrayList convertFunctions(Function[] functions) {
        ArrayList<OperationConfigurationImpl> operationCfg = new ArrayList<OperationConfigurationImpl>();
        int i = 0;
        while (i < functions.length) {
            if (functions[i].getIsExposed()) {
                OperationConfigurationImpl opcfg = new OperationConfigurationImpl();
                opcfg.setName(functions[i].getName());
                com.sap.ide.metamodel.vi.Fault[] faults = functions[i].getFaults();
                ArrayList<FaultImpl> operationfaults = new ArrayList<FaultImpl>();
                int j = 0;
                while (j < faults.length) {
                    FaultImpl f = new FaultImpl();
                    f.setName(faults[j].getName());
                    operationfaults.add(f);
                    ++j;
                }
                Fault[] wsdfaults = new Fault[operationfaults.size()];
                opcfg.getTransportBindingConfiguration().setFaults(operationfaults.toArray(wsdfaults));
                Parameter[] params = functions[i].getIncomingParameters();
                Vector<String> params1 = new Vector<String>();
                Vector<String> paramtypes = new Vector<String>();
                int j2 = 0;
                while (j2 < params.length) {
                    String paramtype = params[j2].getMappedTypeReference().getName();
                    if (paramtype.equals("java.lang.String") || paramtype.equals("byte[]")) {
                        params1.add(params[j2].getName());
                        paramtypes.add(paramtype);
                    }
                    ++j2;
                }
                opcfg.setIncomingParameters(params1, paramtypes);
                params1.clear();
                paramtypes.clear();
                params = functions[i].getOutgoingParameters();
                int j3 = 0;
                while (j3 < params.length) {
                    String paramtype = params[j3].getMappedTypeReference().getName();
                    if (paramtype.equals("java.lang.String") || paramtype.equals("byte[]")) {
                        params1.add(params[j3].getName());
                        paramtypes.add(paramtype);
                    }
                    ++j3;
                }
                opcfg.setOutgoingParameters(params1, paramtypes);
                operationCfg.add(opcfg);
            }
            ++i;
        }
        return operationCfg;
    }

    static Feature findFeature(Feature[] features, String name) {
        int i = 0;
        while (i < features.length) {
            if (!((FeatureImpl)features[i]).isDeployTimeFeature() && features[i].getName().equals(name)) {
                return features[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean checkfeature(Feature[] designtime, Feature[] features, String name) {
        Feature f1 = WsConfigurationManager.findFeature(features, name);
        Feature f2 = WsConfigurationManager.findFeature(designtime, name);
        if (f1 != null && f2 != null) {
            String value1 = f1.getProperties()[0].getValue();
            String value2 = f2.getProperties()[0].getValue();
            return value1.equals(value2);
        }
        return f1 == null && f2 == null;
    }

    public static int getWSDSecurityLevel(Feature[] features) {
        int transport = 0;
        int authentication = 0;
        int i = 0;
        while (i < features.length) {
            com.sap.ide.ws.wsddman.Property[] p;
            if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/transportguarantee")) {
                p = features[i].getProperties();
                if (p[0].getName().equals("Level")) {
                    if (p[0].getValue().equals("No")) {
                        transport = 0;
                    } else if (p[0].getValue().equals("Both")) {
                        transport = 1;
                    }
                }
            } else if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/authentication") && (p = features[i].getProperties())[0].getName().equals("AuthenticationLevel")) {
                if (p[0].getValue().equals("None")) {
                    authentication = 0;
                } else if (p[0].getValue().equals("Basic")) {
                    authentication = 4;
                } else if (p[0].getValue().equals("Strong")) {
                    authentication = 8;
                }
            }
            ++i;
        }
        return authentication | transport;
    }

    public static int getCfgSecurityLevel(Feature[] features) {
        int transport = 0;
        int authentication = 0;
        int i = 0;
        while (i < features.length) {
            com.sap.ide.ws.wsddman.Property[] p;
            if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/transportguarantee")) {
                p = features[i].getProperties();
                if (p[0].getName().equals("TLSType") && p[0].getValue().equals("SSL")) {
                    transport = 1;
                }
            } else if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/authentication") && (p = features[i].getProperties())[0].getName().equals("AuthenticationMethod")) {
                if (p[0].getValue().equals("BasicAuth")) {
                    authentication = 4;
                } else if (p[0].getValue().equals("CertAuth")) {
                    authentication = 8;
                }
            }
            ++i;
        }
        return transport | authentication;
    }

    public static void updateConfiguration(Configuration cfg, String[] securityroles) {
        Vector<String> v;
        WebServiceDefinition wsd = WebServiceMdoResolver.getWebServiceDefinitionFromWorkSpace((String)((WSConfigurationImpl)cfg).getParent().getGUID());
        VirtualInterface vi = WebServiceMdoResolver.getViForWsd((WebServiceDefinition)wsd);
        Vector<Function> newfunctions = new Vector<Function>();
        Function[] viFunctions = vi.getFunctions();
        int i = 0;
        while (i < viFunctions.length) {
            if (viFunctions[i].getIsExposed()) {
                newfunctions.add(viFunctions[i]);
            }
            ++i;
        }
        OperationConfiguration[] oldcfgs = cfg.getOperationConfigurations();
        if (WsConfigurationManager.operationConfigurationsChanged(oldcfgs, newfunctions)) {
            ArrayList operationCfg = WsConfigurationManager.convertFunctions(viFunctions);
            OperationConfiguration[] opcfgs = new OperationConfiguration[operationCfg.size()];
            ((WSConfigurationImpl)cfg).addMissingOperations(operationCfg.toArray(opcfgs), vi);
            boolean[] newlyadded = new boolean[opcfgs.length];
            int i2 = 0;
            while (i2 < opcfgs.length) {
                newlyadded[i2] = true;
                int j = 0;
                while (j < oldcfgs.length) {
                    if (opcfgs[i2].getName().equals(oldcfgs[j].getName())) {
                        newlyadded[i2] = false;
                        opcfgs[i2] = oldcfgs[j];
                    }
                    ++j;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < opcfgs.length) {
                com.sap.ide.metamodel.vi.Fault[] faults = vi.getFunction(opcfgs[i3].getName()).getFaults();
                ArrayList<FaultImpl> operationfaults = new ArrayList<FaultImpl>();
                int j = 0;
                while (j < faults.length) {
                    FaultImpl f = new FaultImpl();
                    f.setName(faults[j].getName());
                    operationfaults.add(f);
                    ++j;
                }
                Fault[] wsdfaults = new Fault[operationfaults.size()];
                opcfgs[i3].getTransportBindingConfiguration().setFaults(operationfaults.toArray(wsdfaults));
                if (newlyadded[i3]) {
                    ((OperationConfigurationImpl)opcfgs[i3]).setNameMappedTo(vi.getFunction(opcfgs[i3].getName()).getNameMappedTo());
                    if (WsConfigurationManager.mustAddSecurity(cfg)) {
                        if (((WSConfigurationImpl)cfg).getIsJavaClass()) {
                            JavaClassSecurityRole[] roles = ((WSConfigurationImpl)cfg).getJavaSecurityRoles();
                            v = new Vector();
                            int j2 = 0;
                            while (j2 < roles.length) {
                                v.add(roles[j2].getName());
                                ++j2;
                            }
                            ((OperationConfigurationImpl)opcfgs[i3]).setSecurityRoles(v);
                        } else {
                            ((OperationConfigurationImpl)opcfgs[i3]).setSecurityRoles(new Vector());
                        }
                    }
                }
                ++i3;
            }
            cfg.setOperationConfigurations(opcfgs);
        }
        boolean consistent = true;
        int wsdsecuritylevel = 0;
        int wscfgsecuritylevel = 0;
        Feature[] oldfeatures = cfg.getGlobalFeatures();
        Feature[] designtime = WsConfigurationManager.getSelectedSoapFeatures(wsd, cfg);
        boolean wscfgauthorizationselected = WsConfigurationManager.containsAuthorization(oldfeatures);
        boolean wsdauthorizationselected = WsConfigurationManager.containsAuthorization(designtime);
        consistent = WsConfigurationManager.checkfeature(designtime, oldfeatures, "http://www.sap.com/webas/630/soap/features/authentication");
        boolean bl = consistent = consistent && WsConfigurationManager.checkfeature(designtime, oldfeatures, "http://www.sap.com/webas/630/soap/features/transportguarantee");
        if (wsdauthorizationselected && !wscfgauthorizationselected) {
            consistent = false;
        }
        wsdsecuritylevel = WsConfigurationManager.getWSDSecurityLevel(designtime);
        wscfgsecuritylevel = WsConfigurationManager.getCfgSecurityLevel(oldfeatures);
        if (WsConfigurationManager.insufficientCfgSecurityLevel(wscfgsecuritylevel, wsdsecuritylevel)) {
            consistent = false;
        }
        if (WsConfigurationManager.containsSession(designtime) != WsConfigurationManager.containsSession(oldfeatures)) {
            consistent = false;
        }
        if (!consistent) {
            if (WsConfigurationManager.insufficientCfgSecurityLevel(wscfgsecuritylevel, wsdsecuritylevel)) {
                DeployTimeFeatures dtf = new DeployTimeFeatures();
                oldfeatures = dtf.createDeployTimeFeatures(designtime);
            }
            if (wscfgauthorizationselected || wsdauthorizationselected) {
                oldfeatures = WsConfigurationManager.addAuthorization(oldfeatures);
            }
            oldfeatures = WsConfigurationManager.containsSession(designtime) ? WsConfigurationManager.addSession(oldfeatures) : WsConfigurationManager.removeSession(oldfeatures);
            cfg.setGlobalFeatures(oldfeatures);
        }
        if (!((WSConfigurationImpl)cfg).getIsJavaClass()) {
            OperationConfiguration[] opcfgs = cfg.getOperationConfigurations();
            int i4 = 0;
            while (i4 < opcfgs.length) {
                Vector oproles = ((OperationConfigurationImpl)opcfgs[i4]).getSecurityRoles();
                v = new Vector<String>();
                boolean allrolesfound = true;
                int j = 0;
                while (j < oproles.size()) {
                    boolean found = false;
                    int k = 0;
                    while (k < securityroles.length) {
                        found = found || securityroles[k].equals(oproles.elementAt(j));
                        ++k;
                    }
                    boolean bl2 = allrolesfound = allrolesfound && found;
                    if (found) {
                        v.add((String)oproles.elementAt(j));
                    }
                    ++j;
                }
                if (!allrolesfound) {
                    ((OperationConfigurationImpl)opcfgs[i4]).setSecurityRoles(v);
                }
                ++i4;
            }
        }
    }

    public static boolean containsAuthorization(Feature[] f) {
        int i = 0;
        while (i < f.length) {
            if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/authorization")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean operationConfigurationsChanged(OperationConfiguration[] oldcfgs, Vector newfunctions) {
        if (oldcfgs.length != newfunctions.size()) {
            return true;
        }
        int i = 0;
        while (i < oldcfgs.length) {
            boolean found = false;
            int j = 0;
            while (j < newfunctions.size()) {
                if (oldcfgs[i].getName().equals(((Function)newfunctions.elementAt(j)).getName())) {
                    Fault[] wsddfaults;
                    found = true;
                    com.sap.ide.metamodel.vi.Fault[] faults = ((Function)newfunctions.elementAt(i)).getFaults();
                    if (faults.length != (wsddfaults = oldcfgs[i].getTransportBindingConfiguration().getFaults()).length) {
                        return true;
                    }
                    int k = 0;
                    while (k < faults.length) {
                        boolean found1 = false;
                        int l = 0;
                        while (l < wsddfaults.length) {
                            if (faults[k].getName().equals(wsddfaults[l].getName())) {
                                found1 = true;
                            }
                            ++l;
                        }
                        if (!found1) {
                            return true;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            if (!found) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Feature[] addAuthorization(Feature[] f) {
        if (!WsConfigurationManager.containsAuthorization(f)) {
            Feature[] f1 = new Feature[f.length + 1];
            System.arraycopy(f, 0, f1, 0, f.length);
            f1[f.length] = new FeatureImpl();
            f1[f.length].setName("http://www.sap.com/webas/630/soap/features/authorization");
            f1[f.length].setProtocol("SecurityProtocol");
            return f1;
        }
        return f;
    }

    public static boolean containsSession(Feature[] f) {
        int i = 0;
        while (i < f.length) {
            if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/session/")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Feature[] addSession(Feature[] f) {
        if (!WsConfigurationManager.containsSession(f)) {
            Feature[] f1 = new Feature[f.length + 1];
            System.arraycopy(f, 0, f1, 0, f.length);
            f1[f.length] = new FeatureImpl();
            f1[f.length].setName("http://www.sap.com/webas/630/soap/features/session/");
            f1[f.length].setProtocol("HTTP_StatefulProtocol");
            com.sap.ide.ws.wsddman.Property[] props = new com.sap.ide.ws.wsddman.Property[]{new PropertyImpl()};
            props[0].setName("SessionMethod");
            props[0].setValue("httpCookies");
            f1[f.length].setProperties(props);
            return f1;
        }
        return f;
    }

    private static boolean mustAddSecurity(Configuration cfg) {
        Feature author = null;
        Feature authen = null;
        Feature transport = null;
        Feature[] features = cfg.getGlobalFeatures();
        int i = 0;
        while (i < features.length) {
            if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/authorization")) {
                author = features[i];
            } else if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/authentication")) {
                if (((FeatureImpl)features[i]).isDeployTimeFeature()) {
                    authen = features[i];
                }
            } else if (features[i].getName().equals("http://www.sap.com/webas/630/soap/features/transportguarantee") && ((FeatureImpl)features[i]).isDeployTimeFeature()) {
                transport = features[i];
            }
            ++i;
        }
        if (author == null || authen == null || transport == null) {
            return false;
        }
        com.sap.ide.ws.wsddman.Property[] p1 = authen.getProperties();
        com.sap.ide.ws.wsddman.Property[] p2 = transport.getProperties();
        return !p1[0].getName().equals("None") || !p2[0].getName().equals("No");
    }

    public static Feature[] removeSession(Feature[] f) {
        if (WsConfigurationManager.containsSession(f)) {
            Feature[] f1 = new Feature[f.length - 1];
            int j = 0;
            boolean found = false;
            int i = 0;
            while (i < f.length) {
                if (!f[i].getName().equals("http://www.sap.com/webas/630/soap/features/session/") || found) {
                    f1[j] = f[i];
                    ++j;
                } else {
                    found = true;
                }
                ++i;
            }
            return f1;
        }
        return f;
    }

    public static boolean insufficientCfgSecurityLevel(int configsecurity, int wsdsecurity) {
        return (configsecurity & 3) < (wsdsecurity & 3) || (configsecurity & 0xC) < (wsdsecurity & 0xC);
    }

    static {
        EP_TYPE_EJB = 1;
        EP_TYPE_JAVA_CLASS = 2;
    }
}

