/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.configuration;

import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.ws.configuration.WSDDGeneratorStruct;
import com.sap.ide.ws.configuration.WsConfigurationManager;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.DeploymentDescriptorManager;
import com.sap.ide.ws.wsddman.Fault;
import com.sap.ide.ws.wsddman.ImplementationLink;
import com.sap.ide.ws.wsddman.Input;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.Output;
import com.sap.ide.ws.wsddman.TransportBinding;
import com.sap.ide.ws.wsddman.WebService;
import com.sap.ide.ws.wsddman.impl0.FaultImpl;
import com.sap.ide.ws.wsddman.impl0.ImplementationLinkImpl;
import com.sap.ide.ws.wsddman.impl0.InputImpl;
import com.sap.ide.ws.wsddman.impl0.OutputImpl;
import com.sap.ide.ws.wsddman.impl0.TransportBindingImpl;
import com.sap.ide.ws.wsddman.impl0.WSConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.WebServiceImpl;
import java.util.ArrayList;

public class WSDDGenerator {
    WSDDGeneratorStruct struct = null;

    public WSDDGenerator(WSDDGeneratorStruct data) {
        this.struct = data;
    }

    public DeploymentDescriptor createWSDD() {
        DeploymentDescriptor dd = DeploymentDescriptorManager.newInstance().newDeploymentDescriptor();
        WebService ws = dd.addWebService();
        ((WebServiceImpl)ws).setVIAndWSDNames(this.struct.getVISource().getName(), this.struct.getWSDSource().getName());
        ws.setEJBNameTemp(this.struct.getImplementationLink());
        Configuration cfg = ws.addConfiguration("configuration1");
        VirtualInterface vi = this.struct.getVISource();
        WebServiceDefinition wsd = this.struct.getWSDSource();
        ArrayList operationCfg = new ArrayList();
        if (vi != null) {
            Function[] functions = vi.getFunctions();
            operationCfg = WsConfigurationManager.convertFunctions(functions);
        }
        OperationConfiguration[] opcfgs = new OperationConfiguration[operationCfg.size()];
        ((WSConfigurationImpl)cfg).setOwnerName("urn:" + wsd.getName() + "/" + vi.getName());
        ((WSConfigurationImpl)cfg).setPortVi(vi.getPackage(), vi.getName() + ".videf");
        ((WSConfigurationImpl)cfg).setWSD(wsd.getPackage(), wsd.getName() + ".wsdef");
        ((WSConfigurationImpl)cfg).addMissingOperations(operationCfg.toArray(opcfgs), vi);
        ((WSConfigurationImpl)cfg).setDefaultTransportAddress(ws.getInternalName());
        ((WSConfigurationImpl)cfg).wsdlporttypename.setLocalName(vi.getName());
        int i = 0;
        while (i < opcfgs.length) {
            Input in = opcfgs[i].getTransportBindingConfiguration().getInput();
            ((InputImpl)in).setDefaultProperties();
            Output out = opcfgs[i].getTransportBindingConfiguration().getOutput();
            ((OutputImpl)out).setDefaultProperties();
            Fault[] f = opcfgs[i].getTransportBindingConfiguration().getFaults();
            int j = 0;
            while (j < f.length) {
                ((FaultImpl)f[j]).setDefaultProperties();
                ++j;
            }
            ++i;
        }
        TransportBindingImpl tb = (TransportBindingImpl)cfg.getTransportBinding();
        String standardnamespace = "urn:" + wsd.getName();
        ((WebServiceImpl)ws).getName().setNamespaceURI(standardnamespace);
        ((WebServiceImpl)ws).setStandardNamespace(standardnamespace);
        cfg.getWSDLPortTypeName().setNamespaceURI(standardnamespace);
        cfg.getPortName().setNamespaceURI(standardnamespace);
        if (tb == null) {
            tb = new TransportBindingImpl();
            tb.setName("HTTP SOAP");
            cfg.setTransportBinging((TransportBinding)tb);
        } else if (tb.getName().equals("")) {
            tb.setName("HTTP SOAP");
        }
        tb.getWSDLBindingName().setNamespaceURI(standardnamespace);
        tb.setRelatedConfigs(cfg.getOperationConfigurations());
        ImplementationLinkImpl ilink = new ImplementationLinkImpl();
        ilink.setID(this.struct.getImplementationLink());
        ilink.setProperties(this.struct.getImplLinkProperties());
        ((WSConfigurationImpl)cfg).setImplLink((ImplementationLink)ilink);
        return dd;
    }
}

