/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.builder.modules;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.webservices.mdos.WebServiceMdoResolver;
import com.sap.ide.ws.configuration.WsConfigurationManager;
import com.sap.ide.ws.core.adapter.MetamodelResourceAdapter;
import com.sap.ide.ws.core.builder.ModularBuilderModuleI;
import com.sap.ide.ws.core.builder.result.BuildResult;
import com.sap.ide.ws.core.builder.result.BuildResultEntry;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.markers.ResourceMarkerManager;
import com.sap.ide.ws.core.services.editors.DescriptorEditorUtils;
import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.ide.ws.editors.descriptor.WsDDEditor;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.Fault;
import com.sap.ide.ws.wsddman.Feature;
import com.sap.ide.ws.wsddman.OperationConfiguration;
import com.sap.ide.ws.wsddman.WebService;
import com.sap.ide.ws.wsddman.impl0.FeatureImpl;
import com.sap.ide.ws.wsddman.impl0.OperationConfigurationImpl;
import com.sap.ide.ws.wsddman.impl0.WSConfigurationImpl;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorPart;

public class WsConfigCheckModule
implements ModularBuilderModuleI {
    private static WsConfigCheckModule mInstance;
    public static final String BUILDER_ID_WS_CHECK = "com.sap.ide.ws.ws_config_check";
    public static final String CHECK_MARKER_ID = "com.sap.ide.ws.checkMarker";
    public static final String MARKER_ATTRIBUTE_WS_CFG = "ws_cfg";

    private WsConfigCheckModule() {
    }

    public static WsConfigCheckModule getInstance() {
        if (mInstance == null) {
            mInstance = new WsConfigCheckModule();
        }
        return mInstance;
    }

    public String getModuleId() {
        return BUILDER_ID_WS_CHECK;
    }

    public void check(int kind, IProject project, IResourceDelta delta, BuildResult checkResult) {
        this.deleteOldMarkers(project);
        this.doCheck(checkResult, project);
    }

    public void applyCheckResult(BuildResult checkResult) {
        ArrayList checkResultEntries = checkResult.getCheckResultEntries();
        int i = 0;
        while (i < checkResultEntries.size()) {
            BuildResultEntry checkRes = (BuildResultEntry)checkResultEntries.get(i);
            IResource resource = checkRes.getResource();
            try {
                IMarker lMarker = this.configToResource(checkRes.getResource().getName()).createMarker(CHECK_MARKER_ID);
                if (lMarker != null) {
                    lMarker.setAttribute("message", (Object)checkRes.getMessage());
                    lMarker.setAttribute("severity", checkRes.getKind());
                    lMarker.setAttribute("location", (Object)((DescriptorCheckResult)checkRes).getConfigName());
                    lMarker.setAttribute(MARKER_ATTRIBUTE_WS_CFG, (Object)(checkRes.getResource().getName() + "/meta-inf/ws-deployment-descriptor.xml"));
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
            ++i;
        }
    }

    public boolean isProjectRelevant(IProject project) {
        return WebServiceFilterFactory.isEndpointProject((IProject)project);
    }

    public void updateOpenEditorIcons(BuildResult result, IProject project) {
        IProject[] descriptorProjects = WebServiceMdoResolver.getDescriptorContainingProjects();
        int i = 0;
        while (i < descriptorProjects.length) {
            IEditorPart part = DescriptorEditorUtils.findEditorPartForDescriptor((String)descriptorProjects[i].getName());
            if (part != null && part instanceof WsDDEditor) {
                ((WsDDEditor)part).updateUi();
            }
            ++i;
        }
    }

    private void deleteOldMarkers(IProject project) {
        this.deleteMarkersForProject(project.getName());
    }

    private IResource configToResource(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile lResource = project.getFile((IPath)new Path("/META-INF/ws-deployment-descriptor.xml"));
        if (lResource == null || !lResource.exists()) {
            lResource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return lResource;
    }

    private void deleteMarkersForProject(String projectName) {
        try {
            this.configToResource(projectName).deleteMarkers(CHECK_MARKER_ID, false, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doCheck(BuildResult checkResult, IProject project) {
        block14: {
            dd = DescriptorManager.getDeploymentDescriptor((String)project.getName());
            if (dd == null) break block14;
            services = dd.getWebServices();
            i = 0;
            while (i < services.length) {
                if (J2eeProjectManager.getEjbModule((String)project.getName()) == null) ** GOTO lbl-1000
                modelUin = ModelUinSupport.createModelUin((String)project.getName());
                if (ModelAccess.getModel((UniqueName)modelUin) == null) {
                    ModelAccess.createModel((UniqueName)modelUin);
                }
                if ((beans = J2eeProjectManager.getEjbModule((String)project.getName()).getDescriptor().getEnterpriseBeans()) == null) ** GOTO lbl-1000
                sessionBeanRefs = beans.getSessions();
                found = false;
                j = 0;
                while (j < sessionBeanRefs.length) {
                    if (services[i].getEJBNameTemp().equals(sessionBeanRefs[j].getEjbName().getValue())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    checkResult.addEntry((BuildResultEntry)new DescriptorCheckResult(WsUiTexts.getString("WsConfigCheckModule.errors.noBeanRef"), services[i].getInternalname(), project.getName()));
                } else if ((wsd = WebServiceMdoResolver.resolveWsdReferenceByGuidForProject((String)project.getName(), (String)services[i].getGUID())) == null) {
                    checkResult.addEntry((BuildResultEntry)new DescriptorCheckResult(WsUiTexts.getString("WsConfigCheckModule.errors.noWsd"), services[i].getInternalname(), project.getName()));
                } else if (ResourceMarkerManager.getWsdFaultyMarkers((String)project.getName(), (String)MetamodelResourceAdapter.mdoToResource((MainDevelopmentObject)wsd).getProjectRelativePath().toOSString(), (String)"com.sap.ide.ws.wsd_check_marker").length <= 0) {
                    if (services[i].getConfigurations().length < 1) {
                        checkResult.addEntry((BuildResultEntry)new DescriptorCheckResult(WsUiTexts.getString("WsConfigCheckModule.errors.noConfig"), services[i].getInternalname(), project.getName()));
                    } else {
                        vi = WebServiceMdoResolver.getViForWsd((WebServiceDefinition)wsd);
                        functions = vi.getFunctions();
                        configs = services[i].getConfigurations();
                        j = 0;
                        while (j < configs.length) {
                            viResult = this.checkConfigForVI(services[i], configs[j], functions, project.getName());
                            if (viResult != null) {
                                checkResult.addEntry((BuildResultEntry)viResult);
                            }
                            if ((wsdResult = this.checkConfigForWSD(services[i], configs[j], wsd, project.getName())) != null) {
                                checkResult.addEntry((BuildResultEntry)wsdResult);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private DescriptorCheckResult checkConfigs(WebService service, Configuration configuration, Function[] viFunctions, String projectName) {
        int numberOfExposedFunctions = 0;
        int i = 0;
        while (i < viFunctions.length) {
            if (viFunctions[i].getIsExposed()) {
                ++numberOfExposedFunctions;
            }
            ++i;
        }
        if (configuration.getOperationConfigurations().length != numberOfExposedFunctions) {
            return new DescriptorCheckResult(WsUiTexts.getString("WsConfigCheckModule.errors.invalidConfig"), service.getInternalname() + "/" + configuration.getName(), projectName);
        }
        return null;
    }

    private boolean operationConfigurationsChanged(OperationConfiguration[] oldcfgs, Vector newfunctions) {
        if (oldcfgs.length != newfunctions.size()) {
            return true;
        }
        int i = 0;
        while (i < oldcfgs.length) {
            boolean found = false;
            int j = 0;
            while (j < newfunctions.size()) {
                if (oldcfgs[i].getName().equals(((Function)newfunctions.elementAt(j)).getName())) {
                    Fault[] wsddfaults;
                    found = true;
                    com.sap.ide.metamodel.vi.Fault[] faults = ((Function)newfunctions.elementAt(i)).getFaults();
                    if (faults.length != (wsddfaults = oldcfgs[i].getTransportBindingConfiguration().getFaults()).length) {
                        return true;
                    }
                    int k = 0;
                    while (k < faults.length) {
                        boolean found1 = false;
                        int l = 0;
                        while (l < wsddfaults.length) {
                            if (faults[k].getName().equals(wsddfaults[l].getName())) {
                                found1 = true;
                            }
                            ++l;
                        }
                        if (!found1) {
                            return true;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            if (!found) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private DescriptorCheckResult checkConfigForVI(WebService service, Configuration configuration, Function[] viFunctions, String projectName) {
        Vector<Function> newfunctions = new Vector<Function>();
        int i = 0;
        while (i < viFunctions.length) {
            if (viFunctions[i].getIsExposed()) {
                newfunctions.add(viFunctions[i]);
            }
            ++i;
        }
        if (this.operationConfigurationsChanged(configuration.getOperationConfigurations(), newfunctions)) {
            return new DescriptorCheckResult(WsUiTexts.getString("WsConfigCheckModule.errors.invalidConfigVi"), service.getInternalname() + "/" + configuration.getName(), projectName);
        }
        return null;
    }

    private boolean containsAuthorization(Feature[] f) {
        int i = 0;
        while (i < f.length) {
            if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/authorization")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Feature findFeature(Feature[] features, String name) {
        int i = 0;
        while (i < features.length) {
            if (!((FeatureImpl)features[i]).isDeployTimeFeature() && features[i].getName().equals(name)) {
                return features[i];
            }
            ++i;
        }
        return null;
    }

    boolean checkfeature(Feature[] designtime, Feature[] features, String name) {
        Feature f1 = this.findFeature(features, name);
        Feature f2 = this.findFeature(designtime, name);
        if (f1 != null && f2 != null) {
            String value1 = f1.getProperties()[0].getValue();
            String value2 = f2.getProperties()[0].getValue();
            return value1.equals(value2);
        }
        return f1 == null && f2 == null;
    }

    private DescriptorCheckResult checkConfigForWSD(WebService service, Configuration configuration, WebServiceDefinition wsd, String projectName) {
        int i;
        boolean consistent = true;
        int wsdsecuritylevel = 0;
        int wscfgsecuritylevel = 0;
        Feature[] features = configuration.getGlobalFeatures();
        Feature[] designtime = WsConfigurationManager.getSelectedSoapFeatures(wsd, configuration);
        boolean wscfgauthorizationselected = this.containsAuthorization(features);
        boolean wsdauthorizationselected = this.containsAuthorization(designtime);
        if (wsdauthorizationselected && !wscfgauthorizationselected) {
            consistent = false;
        }
        Vector<Feature> temp = new Vector<Feature>();
        if (consistent) {
            i = 0;
            while (i < features.length) {
                if (((FeatureImpl)features[i]).isDeployTimeFeature()) {
                    temp.add(features[i]);
                }
                ++i;
            }
        }
        features = new Feature[temp.size()];
        i = 0;
        while (i < temp.size()) {
            features[i] = (Feature)temp.elementAt(i);
            ++i;
        }
        wscfgsecuritylevel = WsConfigurationManager.getCfgSecurityLevel(features);
        if (WsConfigurationManager.insufficientCfgSecurityLevel(wscfgsecuritylevel, wsdsecuritylevel = WsConfigurationManager.getWSDSecurityLevel(designtime))) {
            consistent = false;
        }
        boolean wsdsession = WsConfigurationManager.containsSession(designtime);
        boolean wscfgsession = WsConfigurationManager.containsSession(features);
        boolean bl = consistent = consistent && wsdsession == wscfgsession;
        if (!consistent) {
            return new DescriptorCheckResult(WsUiTexts.getString("WsConfigCheckModule.errors.invalidConfigWsd"), service.getInternalname() + "/" + configuration.getName(), projectName);
        }
        return null;
    }

    private DescriptorCheckResult checkConfigForEJBJarXML(WebService service, Configuration configuration, WebServiceDefinition wsd, String projectName) {
        if (!((WSConfigurationImpl)configuration).getIsJavaClass()) {
            String[] ejbjarroles = WsConfigurationManager.getSecurityRoles(projectName);
            OperationConfiguration[] opcfgs = configuration.getOperationConfigurations();
            int i = 0;
            while (i < opcfgs.length) {
                Vector oproles = ((OperationConfigurationImpl)opcfgs[i]).getSecurityRoles();
                int j = 0;
                while (j < oproles.size()) {
                    boolean found = false;
                    int k = 0;
                    while (k < ejbjarroles.length) {
                        found = found || ejbjarroles[k].equals(oproles.elementAt(j));
                        ++k;
                    }
                    if (!found) {
                        return new DescriptorCheckResult(WsUiTexts.getString("WsConfigCheckModule.errors.invalidConfigEjbjar"), service.getInternalname() + "/" + configuration.getName(), projectName);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private class DescriptorCheckResult
    extends BuildResultEntry {
        private String elementName;

        public DescriptorCheckResult(String message, String elementName, String projectName) {
            super((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), 2, "", message, "");
            this.elementName = elementName;
        }

        public String getConfigName() {
            return this.elementName;
        }
    }
}

