/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.actions.descriptor;

import com.sap.ide.ws.core.actions.GenericMultiDeleteAction;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.text.WsUiTexts;
import com.tssap.j2ee.core.providers.ws.WsConfigModelInfo;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;

public class MultipleDeleteWsConfigurationAction
extends GenericMultiDeleteAction {
    private static final String DISPLAY_NAME = WsUiTexts.getString("MultipleDeleteWsConfigurationAction.actionName");
    private static final String DISPLAY_INFO = WsUiTexts.getString("MultipleDeleteWsConfigurationAction.actionInfo");
    private static final String DESCRIPTION = WsUiTexts.getString("MultipleDeleteWsConfigurationAction.actionDescription");
    private static final ICategory CATEGORY = Category.createDisplayableCategory((ICategory)Category.DELETE, (String)DESCRIPTION, (String)DISPLAY_NAME, (String)DISPLAY_INFO, null);
    private int counterOfRelevantElements = 0;

    public MultipleDeleteWsConfigurationAction() {
        super(CATEGORY, DISPLAY_NAME);
    }

    protected boolean isMultiplyAvailable() {
        return false;
    }

    public boolean isEnabled(Element[] elements) {
        return !DescriptorManager.isDescriptorReadOnly((String)elements[0].getModel().getUniqueName().getName());
    }

    public boolean isAvailable(Element[] elements) {
        this.counterOfRelevantElements = 0;
        int i = 0;
        while (i < elements.length && this.counterOfRelevantElements < 3) {
            if (WsConfigModelInfo.isWsConfiguration((UniqueName)elements[i].getUniqueName())) {
                ++this.counterOfRelevantElements;
            }
            ++i;
        }
        return this.counterOfRelevantElements > 0;
    }

    public void run(Element[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (WsConfigModelInfo.isWsConfiguration((UniqueName)elements[i].getUniqueName()) && this.warnUserAboutDelete("Web Service Configuration", elements[i].getUniqueName().getName())) {
                elements[i].delete();
            }
            ++i;
        }
    }
}

