/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.actions.descriptor;

import com.sap.ide.metamodel.ws.WebServiceDefinition;
import com.sap.ide.webservices.tsmodel.wsd.provider.WSDDataSourceManager;
import com.sap.ide.ws.core.actions.GenericSingleDeleteAction;
import com.sap.ide.ws.core.descriptor.DescriptorManager;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.editors.DescriptorEditorUtils;
import com.sap.ide.ws.text.WsUiTexts;
import com.sap.ide.ws.wsddman.Configuration;
import com.sap.ide.ws.wsddman.DeploymentDescriptor;
import com.sap.ide.ws.wsddman.WebService;
import com.tssap.j2ee.core.providers.ws.WsModelMetaInfo;
import com.tssap.j2ee.model.DeleteFailedException;
import com.tssap.j2ee.model.wsd.dd.IWebServiceDefinition;
import com.tssap.j2ee.model.wsd.impl.WsdRefListHandler;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;

public class DeleteWsdProxyAction
extends GenericSingleDeleteAction {
    private static final String DISPLAY_NAME = WsUiTexts.getString("DeleteWsdProxyAction.actionName");
    private static final String DISPLAY_INFO = WsUiTexts.getString("DeleteWsdProxyAction.actionInfo");
    private static final String DESCRIPTION = WsUiTexts.getString("DeleteWsdProxyAction.actionDescription");
    private static final ICategory CATEGORY = Category.createDisplayableCategory((ICategory)Category.DEFAULT, (String)DESCRIPTION, (String)DISPLAY_NAME, (String)DISPLAY_INFO, null);

    public DeleteWsdProxyAction() {
        super(CATEGORY, DISPLAY_NAME);
    }

    public boolean isEnabled(Element element) {
        return !DescriptorManager.isDescriptorReadOnly((String)element.getModel().getUniqueName().getName());
    }

    public boolean isAvailable(Element element) {
        return WsModelMetaInfo.isWsdReference((UniqueName)element.getUniqueName());
    }

    public void run(Element element) {
        if (this.warnUserAboutDelete("Web Service " + element.getUniqueName().getName() + " will be deleted, continue?")) {
            Entity descriptor = element.getParent();
            IWebServiceDefinition definition = WsdRefListHandler.getWebServiceDefinition((Element)element);
            if (definition != null) {
                try {
                    this.closeAllDependentConfigEditors(element.getModel().getUniqueName().getName(), element);
                    definition.delete(false);
                }
                catch (DeleteFailedException e) {
                    WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
                }
                String projectName = descriptor.getModel().getUniqueName().getName();
                DeploymentDescriptor dd = DescriptorManager.getDeploymentDescriptor((String)projectName);
                if (dd.getWebServices().length < 1) {
                    descriptor.delete();
                }
            }
        }
    }

    private void closeAllDependentConfigEditors(String projectName, Element wsdReference) {
        DeploymentDescriptor dd = DescriptorManager.getDeploymentDescriptor((String)projectName);
        WebServiceDefinition wsd = WSDDataSourceManager.getWebServiceDefinition((Entity)ProxyMetaInfo.getSourceEntity((UniqueName)wsdReference.getUniqueName()));
        WebService service = dd.getWebService(wsd.getGuid(), WsModelMetaInfo.getWsReferenceName((UniqueName)wsdReference.getUniqueName()));
        Configuration[] cfgs = service.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            DescriptorEditorUtils.closeEditor((String)wsdReference.getModel().getUniqueName().getName());
            ++i;
        }
    }

    public ICategory getCategory() {
        return CATEGORY;
    }
}

