/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsnavigator;

import com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedComplexType;
import com.sap.engine.services.webservices.wsnavigator.TreeListener;
import com.sap.engine.services.webservices.wsnavigator.WSNavigatorUtils;

class TestTreeListener
implements TreeListener {
    private String indent = "";

    TestTreeListener() {
    }

    public void enter() {
        this.indent = this.indent + "    ";
    }

    public void leave() {
        this.indent = this.indent.substring(0, this.indent.length() - 4);
    }

    public void addOperationNode(String operationName) {
        System.out.println(operationName);
    }

    public void addNode(String id, String name, Class javaType, Object value, Class[] superClasses, int flags) {
        StringBuffer buf = new StringBuffer(this.indent);
        if ((flags & 8) != 8) {
            buf.append(name);
        }
        buf.append("(" + WSNavigatorUtils.class2string(javaType) + ')');
        if (value == null) {
            buf.append("[NULL]");
        } else if (value instanceof GeneratedComplexType) {
            buf.append("[COMPLEX]");
        } else if (value.getClass().isArray()) {
            buf.append("[ARRAY]");
        } else {
            buf.append("[" + value + ']');
        }
        if ((flags & 4) == 4) {
            buf.append(" NULL ");
        }
        if ((flags & 2) == 2) {
            buf.append(" SEND ");
        }
        if ((flags & 1) == 1) {
            buf.append(" ARRAY_ADD ");
        }
        if ((flags & 8) == 8) {
            buf.append(" ARRAY_REMOVE ");
        }
        if (superClasses != null) {
            buf.append('<');
            int i = 0;
            while (i < superClasses.length) {
                buf.append(superClasses[i].getName());
                ++i;
            }
            buf.append('>');
        }
        buf.append("@" + id);
        System.out.println(buf);
    }
}

