/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.services.webservices.jaxrpc.encoding.ExtendedTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.XMLTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlMarshalException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;

public class SOAPSerializationContext {
    private Hashtable properties = new Hashtable();
    private ExtendedTypeMapping typeMapping;
    private boolean setType = true;
    private boolean encoded = false;

    public boolean isEncoded() {
        return this.encoded;
    }

    public void setEncoded(boolean encoded) {
        this.encoded = encoded;
    }

    public void setProperty(String s, Object o) {
        this.properties.put(s, o);
    }

    public Object getProperty(String s) {
        return this.properties.get(s);
    }

    public void removeProperty(String s) {
        this.properties.remove(s);
    }

    public boolean containsProperty(String s) {
        return this.properties.containsKey(s);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public void clearContext() {
        this.typeMapping = null;
        this.properties.clear();
        this.setType = true;
        this.encoded = false;
    }

    public boolean getTypeUse() {
        if (this.encoded) {
            return true;
        }
        return this.setType;
    }

    public void setTypeUse(boolean typeUse) {
        this.setType = typeUse;
    }

    public String toString() {
        return this.properties.toString();
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = (ExtendedTypeMapping)typeMapping;
    }

    public ExtendedTypeMapping getExtendedTypeMapping() {
        return this.typeMapping;
    }

    public void setExtendedTypeMapping(ExtendedTypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public SerializerBase getSerializer(QName qName, String className) throws XmlMarshalException {
        XMLTypeMapping xmlTypeMapping = this.typeMapping.getXmlTypeMapping(qName);
        if (xmlTypeMapping == null) {
            throw new XmlMarshalException("webservices_3104", qName.getNamespaceURI(), (Object)qName.getLocalPart(), (Object)className);
        }
        return xmlTypeMapping.getSerializer(className, this);
    }

    public SerializerBase getSerializer(QName qName, Class javaClass) throws XmlMarshalException {
        XMLTypeMapping xmlTypeMapping = this.typeMapping.getXmlTypeMapping(qName);
        if (xmlTypeMapping == null) {
            throw new XmlMarshalException("webservices_3104", qName.getNamespaceURI(), (Object)qName.getLocalPart(), (Object)javaClass.getName());
        }
        return xmlTypeMapping.getSerializer(javaClass, this);
    }

    public XMLTypeMapping getSerializerAll(QName qName, String className) throws XmlMarshalException {
        XMLTypeMapping xmlTypeMapping = this.typeMapping.getXmlTypeMapping(qName);
        if (xmlTypeMapping == null) {
            throw new XmlMarshalException("webservices_3104", qName.getNamespaceURI(), (Object)qName.getLocalPart(), (Object)className);
        }
        return xmlTypeMapping;
    }

    public XMLTypeMapping getSerializerAll(QName qName) throws XmlMarshalException {
        XMLTypeMapping xmlTypeMapping = this.typeMapping.getXmlTypeMapping(qName);
        if (xmlTypeMapping == null) {
            throw new XmlMarshalException("webservices_3104", qName.getNamespaceURI(), (Object)qName.getLocalPart(), (Object)"unknown");
        }
        return xmlTypeMapping;
    }
}

