/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo;
import com.sap.engine.services.webservices.jaxrpc.encoding.InstanceCreator;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationState;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlUnmarshalException;
import java.lang.reflect.Array;
import java.rmi.UnmarshalException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;

public class DocumentArrayBuilder
implements InstanceCreator {
    private Object resultObject;
    private FieldInfo field;
    private SOAPDeserializationContext context;
    private boolean completed;
    private ArrayList arrayContent;
    private Class resultClass;
    private SOAPDeserializationState state;
    private int unloaded;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Stack;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$HashSet;

    public DocumentArrayBuilder(Class resultClass, FieldInfo field, SOAPDeserializationContext context) {
        this.field = field;
        this.context = context;
        this.resultClass = resultClass;
        this.arrayContent = new ArrayList();
        this.completed = false;
        this.resultObject = null;
        this.state = null;
        this.unloaded = 0;
    }

    private Class getComponentClass() throws XmlUnmarshalException {
        if ((class$java$util$List == null ? (class$java$util$List = DocumentArrayBuilder.class$("java.util.List")) : class$java$util$List).isAssignableFrom(this.resultClass)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = DocumentArrayBuilder.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if ((class$java$util$Set == null ? (class$java$util$Set = DocumentArrayBuilder.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(this.resultClass)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = DocumentArrayBuilder.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (this.resultClass.isArray()) {
            return this.resultClass.getComponentType();
        }
        throw new XmlUnmarshalException("webservices_3132", this.field.fieldJavaName, (Object)this.resultObject.getClass().getName());
    }

    public boolean readContent(XMLTokenReader reader) throws UnmarshalException {
        this.completed = true;
        int index = 0;
        Class componentClass = this.getComponentClass();
        DeserializerBase deserializer = this.context.getDeserializer(this.field.getTypeQName(), componentClass.getName());
        while (reader.getState() == 1 && reader.getLocalNameCharArray().equals((Object)this.field.fieldLocalName)) {
            Object content = deserializer.deserialize(reader, this.context, componentClass);
            try {
                reader.next();
                reader.passChars();
            }
            catch (ParserException p) {
                throw new XmlUnmarshalException("webservices_3125", p);
            }
            if (content == null && !this.field.nillable) {
                throw new XmlUnmarshalException("webservices_3117", this.field.fieldLocalName);
            }
            if (content != null && content instanceof SOAPDeserializationState) {
                SOAPDeserializationState currentState = (SOAPDeserializationState)content;
                if (currentState.isComplete()) {
                    if (currentState.getInstance() == null && !this.field.nillable) {
                        throw new XmlUnmarshalException("webservices_3117", this.field.fieldLocalName);
                    }
                    this.arrayContent.add(currentState.getInstance());
                    ++index;
                } else {
                    if (this.state == null) {
                        this.state = new SOAPDeserializationState();
                        this.state.setInstanceCreator(this);
                    }
                    currentState.registerListener(this.state, index, -1);
                    ++this.unloaded;
                    this.completed = false;
                }
            } else {
                this.arrayContent.add(content);
            }
            ++index;
        }
        if (this.completed) {
            this.fill_result(componentClass);
        }
        return this.completed;
    }

    private void fill_result(Class componentClass) {
        if (this.resultClass.isArray()) {
            Object resultArr = Array.newInstance(componentClass, this.arrayContent.size());
            int j = 0;
            while (j < this.arrayContent.size()) {
                Array.set(resultArr, j, this.arrayContent.get(j));
                ++j;
            }
            this.resultObject = resultArr;
        } else {
            AbstractCollection result;
            if (this.resultClass == (class$java$util$ArrayList == null ? (class$java$util$ArrayList = DocumentArrayBuilder.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
                this.resultObject = this.arrayContent;
            }
            if (this.resultClass == (class$java$util$Vector == null ? (class$java$util$Vector = DocumentArrayBuilder.class$("java.util.Vector")) : class$java$util$Vector)) {
                result = new Vector();
                ((Vector)result).addAll(this.arrayContent);
                this.resultObject = result;
            }
            if (this.resultClass == (class$java$util$Stack == null ? (class$java$util$Stack = DocumentArrayBuilder.class$("java.util.Stack")) : class$java$util$Stack)) {
                result = new Stack();
                ((Vector)result).addAll(this.arrayContent);
                this.resultObject = result;
            }
            if (this.resultClass == (class$java$util$LinkedList == null ? (class$java$util$LinkedList = DocumentArrayBuilder.class$("java.util.LinkedList")) : class$java$util$LinkedList)) {
                result = new LinkedList();
                ((LinkedList)result).addAll(this.arrayContent);
                this.resultObject = result;
            }
            if (this.resultClass == (class$java$util$List == null ? (class$java$util$List = DocumentArrayBuilder.class$("java.util.List")) : class$java$util$List)) {
                this.resultObject = this.arrayContent;
            }
            if (this.resultClass == (class$java$util$HashSet == null ? (class$java$util$HashSet = DocumentArrayBuilder.class$("java.util.HashSet")) : class$java$util$HashSet)) {
                result = new HashSet();
                result.addAll(this.arrayContent);
                this.resultObject = result;
            }
        }
    }

    public final void _setFieldObject(Object content, int index, int subindex) throws UnmarshalException {
        if (subindex == -1) {
            this.arrayContent.set(index, content);
            --this.unloaded;
            if (this.unloaded == 0) {
                Class javaClass = this.getComponentClass();
                this.fill_result(javaClass);
                this.completed = true;
            }
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Object getResultObject() {
        return this.resultObject;
    }

    public SOAPDeserializationState getState() {
        return this.state;
    }

    public void setState(SOAPDeserializationState state) {
        this.state = state;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

