/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.services.webservices.jaxm.soap.SSLSocketUtilInterface;
import com.sap.exception.io.SAPIOException;
import com.sap.tc.logging.Location;
import iaik.security.ssl.KeyAndCert;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SSLUtilUsingHttpsLibImpl
implements SSLSocketUtilInterface {
    static final int HASMAP_SIZE = 128;
    private static HashMap secureConnectionCache;
    static Class secureConnectionFactoryClass;
    static Constructor secureConnectionConstructor;
    static Method setIgnoreServerCertificatesMethod;
    static Method createSocketMethod;
    static Method createSocketOverProxyMethod;
    static Method getProxySocketMethod;
    static Method getProxySocketWithAuthenticationMethod;
    static Boolean initialized;
    static Location LOCATION;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxm$soap$SSLUtilUsingHttpsLibImpl;
    static /* synthetic */ Class array$Ljava$security$cert$Certificate;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$Socket;

    public SSLUtilUsingHttpsLibImpl() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Boolean bl = initialized;
        synchronized (bl) {
            if (!initialized.booleanValue()) {
                secureConnectionFactoryClass = Class.forName("com.sap.security.core.server.https.SecureConnectionFactory");
                Class[] constructorClasses = new Class[]{array$Ljava$security$cert$Certificate == null ? (array$Ljava$security$cert$Certificate = SSLUtilUsingHttpsLibImpl.class$("[Ljava.security.cert.Certificate;")) : array$Ljava$security$cert$Certificate, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = SSLUtilUsingHttpsLibImpl.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
                secureConnectionConstructor = secureConnectionFactoryClass.getConstructor(constructorClasses);
                Method[] methods = secureConnectionFactoryClass.getMethods();
                createSocketMethod = secureConnectionFactoryClass.getMethod("createSocket", class$java$lang$String == null ? (class$java$lang$String = SSLUtilUsingHttpsLibImpl.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                createSocketOverProxyMethod = secureConnectionFactoryClass.getMethod("createSocket", class$java$lang$String == null ? (class$java$lang$String = SSLUtilUsingHttpsLibImpl.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$net$Socket == null ? (class$java$net$Socket = SSLUtilUsingHttpsLibImpl.class$("java.net.Socket")) : class$java$net$Socket);
                getProxySocketMethod = Class.forName("com.sap.security.core.server.https.Utils").getMethod("getProxySocket", class$java$lang$String == null ? (class$java$lang$String = SSLUtilUsingHttpsLibImpl.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = SSLUtilUsingHttpsLibImpl.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                getProxySocketWithAuthenticationMethod = Class.forName("com.sap.security.core.server.https.Utils").getMethod("getProxySocket", class$java$lang$String == null ? (class$java$lang$String = SSLUtilUsingHttpsLibImpl.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = SSLUtilUsingHttpsLibImpl.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = SSLUtilUsingHttpsLibImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SSLUtilUsingHttpsLibImpl.class$("java.lang.String")) : class$java$lang$String);
                setIgnoreServerCertificatesMethod = secureConnectionFactoryClass.getMethod("setIgnoreServerCertificate", Boolean.TYPE);
                Constructor<?> LRUHashMapConstructor = Class.forName("com.sap.security.core.server.util0.LRUHashMap").getConstructor(Integer.TYPE);
                secureConnectionCache = (HashMap)LRUHashMapConstructor.newInstance(new Integer(128));
                initialized = new Boolean(true);
            }
        }
    }

    public Socket createSSLSocket(String host, int port, List clientCertificateList, List serverCertificateList, boolean ignoreServerCertificates) throws IOException, UnknownHostException {
        try {
            Object connectionFactory = this.getSecureConnectionFactory(clientCertificateList, serverCertificateList, ignoreServerCertificates);
            Socket socket = (Socket)createSocketMethod.invoke(connectionFactory, host, new Integer(port));
            return socket;
        }
        catch (SecurityException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getTargetException().getClass().getName() + " " + e.getTargetException().getMessage(), e.getTargetException());
            }
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
    }

    public Socket createSSLSocket(String host, int port, String proxyHost, int proxyPort, List clientCertificateList, List serverCertificateList, boolean ignoreServerCertificates) throws IOException, UnknownHostException {
        try {
            Object connectionFactory = this.getSecureConnectionFactory(clientCertificateList, serverCertificateList, ignoreServerCertificates);
            Socket socket = (Socket)getProxySocketMethod.invoke(null, host, new Integer(port), proxyHost, new Integer(proxyPort));
            return (Socket)createSocketOverProxyMethod.invoke(connectionFactory, host, new Integer(port), socket);
        }
        catch (SecurityException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getTargetException().getClass().getName() + " " + e.getTargetException().getMessage(), e.getTargetException());
            }
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
    }

    public Socket createSSLSocket(String host, int port, String proxyHost, int proxyPort, String proxyUser, String proxyPassword, List clientCertificateList, List serverCertificateList, boolean ignoreServerCertificates) throws IOException, UnknownHostException {
        try {
            Object connectionFactory = this.getSecureConnectionFactory(clientCertificateList, serverCertificateList, ignoreServerCertificates);
            Socket socket = (Socket)getProxySocketWithAuthenticationMethod.invoke(null, host, new Integer(port), proxyHost, new Integer(proxyPort), proxyUser, proxyPassword);
            return (Socket)createSocketOverProxyMethod.invoke(connectionFactory, host, new Integer(port), socket);
        }
        catch (SecurityException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getTargetException().getClass().getName() + " " + e.getTargetException().getMessage(), e.getTargetException());
            }
            throw new SAPIOException(LOCATION, "Could not create SSL socket:" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
    }

    private Object getSecureConnectionFactory(List clientCertificateList, List serverCertificateList, boolean ignoreServerCertificates) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Iterator certIterator;
        String secureConnectionFactoryCacheKey = "ignoreServerCertificates=" + ignoreServerCertificates + ";";
        if (clientCertificateList != null) {
            secureConnectionFactoryCacheKey = secureConnectionFactoryCacheKey + "ClientCert={";
            certIterator = clientCertificateList.iterator();
            while (certIterator.hasNext()) {
                KeyAndCert keyAndCert = (KeyAndCert)certIterator.next();
                X509Certificate[] certificates = keyAndCert.getCertificateChain();
                int i = 0;
                while (i < certificates.length) {
                    secureConnectionFactoryCacheKey = secureConnectionFactoryCacheKey + certificates[i].getIssuerDN().getName() + "/" + certificates[i].getSubjectDN().getName() + ";";
                    ++i;
                }
            }
            secureConnectionFactoryCacheKey = secureConnectionFactoryCacheKey + "}";
        }
        if (!ignoreServerCertificates) {
            secureConnectionFactoryCacheKey = secureConnectionFactoryCacheKey + "TrustedCert={";
            if (serverCertificateList != null) {
                certIterator = serverCertificateList.iterator();
                while (certIterator.hasNext()) {
                    X509Certificate trustedCertificate = (X509Certificate)certIterator.next();
                    secureConnectionFactoryCacheKey = secureConnectionFactoryCacheKey + trustedCertificate.getIssuerDN().getName() + "/" + trustedCertificate.getSubjectDN().getName() + ";";
                }
            }
            secureConnectionFactoryCacheKey = secureConnectionFactoryCacheKey + "}";
        }
        if (!secureConnectionCache.containsKey(secureConnectionFactoryCacheKey)) {
            Certificate[] trustedServerCertificates = null;
            if (serverCertificateList != null) {
                trustedServerCertificates = serverCertificateList.toArray(new Certificate[0]);
            }
            Object[] keyAndCertObjects = null;
            if (clientCertificateList != null) {
                keyAndCertObjects = clientCertificateList.toArray();
            }
            Object connectionFactory = secureConnectionConstructor.newInstance(trustedServerCertificates, keyAndCertObjects);
            setIgnoreServerCertificatesMethod.invoke(connectionFactory, new Boolean(ignoreServerCertificates));
            secureConnectionCache.put(secureConnectionFactoryCacheKey, connectionFactory);
        }
        return secureConnectionCache.get(secureConnectionFactoryCacheKey);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        initialized = new Boolean(false);
        LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$webservices$jaxm$soap$SSLUtilUsingHttpsLibImpl == null ? (class$com$sap$engine$services$webservices$jaxm$soap$SSLUtilUsingHttpsLibImpl = SSLUtilUsingHttpsLibImpl.class$("com.sap.engine.services.webservices.jaxm.soap.SSLUtilUsingHttpsLibImpl")) : class$com$sap$engine$services$webservices$jaxm$soap$SSLUtilUsingHttpsLibImpl));
    }
}

