/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.services.webservices.jaxm.soap.SSLSocketUtilInterface;
import com.sap.engine.services.webservices.jaxm.soap.SSLWSSessionManager;
import com.sap.engine.services.webservices.jaxm.soap.V3ChainVerifier;
import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLClientContext;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLSocket;
import iaik.security.ssl.SessionManager;
import iaik.security.ssl.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;

public class SSLUtilImpl
implements SSLSocketUtilInterface {
    public Socket createSSLSocket(String host, int port, List clientCertificateList, List serverCertificateList, boolean ignoreServerCertificates) throws IOException, UnknownHostException {
        SSLSocket sock;
        Iterator certIterator;
        SSLClientContext sslContext = new SSLClientContext();
        sslContext.setSessionManager((SessionManager)new SSLWSSessionManager());
        if (clientCertificateList != null) {
            certIterator = clientCertificateList.iterator();
            while (certIterator.hasNext()) {
                sslContext.addClientCredentials((KeyAndCert)certIterator.next());
            }
        }
        if (!ignoreServerCertificates) {
            sslContext.setChainVerifier((ChainVerifier)new V3ChainVerifier());
            if (serverCertificateList != null) {
                certIterator = serverCertificateList.iterator();
                while (certIterator.hasNext()) {
                    sslContext.addTrustedCertificate((X509Certificate)certIterator.next());
                }
            }
        }
        if ((sock = new SSLSocket(host, port, (SSLContext)sslContext)).getSession() != null) {
            sock.getSession().invalidate();
            sock.renegotiate();
        }
        if ("true".equals(System.getProperty("debug"))) {
            sock.setDebugStream((OutputStream)System.out);
        }
        return sock;
    }

    public Socket createSSLSocket(String host, int port, String proxyHost, int proxyPort, List clientCertificateList, List serverCertificateList, boolean ignoreServerCertificates) throws IOException, UnknownHostException {
        SSLSocket sock;
        Iterator certIterator;
        SSLClientContext sslContext = new SSLClientContext();
        sslContext.setSessionManager((SessionManager)new SSLWSSessionManager());
        if (clientCertificateList != null) {
            certIterator = clientCertificateList.iterator();
            while (certIterator.hasNext()) {
                sslContext.addClientCredentials((KeyAndCert)certIterator.next());
            }
        }
        if (!ignoreServerCertificates) {
            sslContext.setChainVerifier((ChainVerifier)new V3ChainVerifier());
            if (serverCertificateList != null) {
                certIterator = serverCertificateList.iterator();
                while (certIterator.hasNext()) {
                    sslContext.addTrustedCertificate((X509Certificate)certIterator.next());
                }
            }
        }
        if ((sock = Utils.proxyConnect((String)host, (int)port, (SSLContext)sslContext, (InetAddress)InetAddress.getByName(proxyHost), (int)proxyPort)).getSession() != null) {
            sock.getSession().invalidate();
            sock.renegotiate();
        }
        if ("true".equals(System.getProperty("debug"))) {
            sock.setDebugStream((OutputStream)System.out);
        }
        return sock;
    }

    public Socket createSSLSocket(String host, int port, String proxyHost, int proxyPort, String proxyUser, String proxyPassword, List clientCertificateList, List serverCertificateList, boolean ignoreServerCertificates) throws IOException, UnknownHostException {
        throw new IOException("SSL over Proxy with proxy authentication failure. Missing library tc_sec_https.jar. Please see SAP Note 753002 2004");
    }
}

